UNIT NumPro;

INTERFACE

PROCEDURE Assert(condition: Boolean; reason: String);
FUNCTION Byte2Hex(val: Byte): String;
FUNCTION Word2Dec(val: Word): String;
FUNCTION Byte2Dec(val: Byte): String;
PROCEDURE DecByte(var b: Byte; x: Byte);
PROCEDURE IncByte(var b: Byte; x: Byte);
PROCEDURE DecWord(var w: Word; x: Word);
PROCEDURE IncWord(var w: Word; x: Word);
FUNCTION MinInt(a, b: Integer): Integer;
FUNCTION MaxInt(a, b: Integer): Integer;
FUNCTION TenToThe(p: Integer): Word;
FUNCTION Pow(base, expo: Double): Double;

IMPLEMENTATION

PROCEDURE Assert(condition: Boolean; reason: String);
BEGIN
    IF NOT condition THEN
    BEGIN
        WriteLn('## Assertion failed!');
        IF (Length(reason) = 0) THEN
            WriteLn('## Internal program error.')
        ELSE
            WriteLn('## ' + reason + '.');
        Halt(2);
    END
END;

FUNCTION Byte2Hex(val: Byte): String;
VAR
    c1, c2: Char;
    rep:    Array[0..15] of Char;
BEGIN
    rep := '0123456789ABCDEF';
    c1 := Rep[val DIV 16];
    c2 := Rep[val MOD 16];
    Byte2Hex := (c1 + '' + c2);
END;

FUNCTION Word2Dec(val: Word): String;
VAR
    i: Integer;
    r: Word;
    s: String[5];
BEGIN
    r := val;
    s := '12345';
    FOR i := 5 DOWNTO 1 DO
    BEGIN
        IF ((i < 5) AND (r = 0)) THEN
            s[i] := ' '
        ELSE
            s[i] := chr($30 + (r MOD 10));
        r := r DIV 10;
    END;
    Word2Dec := s;
END;

FUNCTION Byte2Dec(val: Byte): String;
VAR
    i: Integer;
    r: Word;
    s: String[3];
BEGIN
    r := val;
    s := '123';
    FOR i := 3 DOWNTO 1 DO
    BEGIN
        IF ((i < 3) AND (r = 0)) THEN
            s[i] := ' '
        ELSE
            s[i] := chr($30 + (r MOD 10));
        r := r DIV 10;
    END;
    Byte2Dec := s;
END;

PROCEDURE DecByte(var b: Byte; x: Byte);
BEGIN
    IF (b <= x) THEN
        b := 0
    ELSE
        Dec(b, x);
END;

PROCEDURE IncByte(var b: Byte; x: Byte);
BEGIN
    IF (b >= ($FF - x)) THEN
        b := $FF
    ELSE
        Inc(b, x);
END;

PROCEDURE DecWord(var w: Word; x: Word);
BEGIN
    IF (w <= x) THEN
        w := 0
    ELSE
        Dec(w, x);
END;

PROCEDURE IncWord(var w: Word; x: Word);
BEGIN
    IF (w >= ($FFFF - x)) THEN
        w := $FFFF
    ELSE
        Inc(w, x);
END;

FUNCTION MinInt(a, b: Integer): Integer;
BEGIN
   IF (a < b) THEN
      MinInt := a
   ELSE
      MinInt := b;
END;

FUNCTION MaxInt(a, b: Integer): Integer;
BEGIN
   IF (a > b) THEN
      MaxInt := a
   ELSE
      MaxInt := b;
END;

FUNCTION TenToThe(p: Integer): Word;
BEGIN
    Assert(p >= 0, 'Invalid use of TenToThe (p too small)');
    Assert(p <= 4, 'Invalid use of TenToThe (p too large)');
    CASE p OF
        0: TenToThe := 1;
        1: TenToThe := 10;
        2: TenToThe := 100;
        3: TenToThe := 1000;
        4: TenToThe := 10000;
    END
END;

FUNCTION Pow(base, expo: Double): Double;
BEGIN
    Pow := Exp(expo * Ln(base));
END;

END.