UNIT VgaPro;

INTERFACE

USES Graph,   {VGA output}
     Drivers, {EGA/VGA driver}
     KeyPro,  {Keyboard input}
     NumPro;  {Number utilities}

PROCEDURE InitGraphics;
PROCEDURE ExitGraphics;
PROCEDURE ShowMessageBox(cap, msg: String);
FUNCTION ShowQuestion(cap, msg: String): Boolean;
FUNCTION EditWordValue(old: Word; cap: String): Word;
FUNCTION EditString(old: String; cap: String; max: Integer): String;

IMPLEMENTATION

PROCEDURE EGAVGADriverProc; EXTERNAL;
{$L EGAVGA.OBJ}

PROCEDURE InitGraphics;
VAR
    bgiDriver: Integer;
    videoMode: Integer;
    errorCode: Integer;
BEGIN
    errorCode := RegisterBGIDriver(@EGAVGADriverProc);
    Assert(errorCode >= 0,
        'Failed to register linked graphics driver: ' +
        GraphErrorMsg(errorCode));
    bgiDriver := VGA;
    videoMode := VGAHI;
    InitGraph(bgiDriver, videoMode, '');
    errorCode := GraphResult;
    Assert(errorCode = grOk,
        'Could not initialize VGA driver: ' +
        GraphErrorMsg(errorCode));
END;

PROCEDURE ExitGraphics;
BEGIN
    CloseGraph;
END;

PROCEDURE ShowMessageBox(cap, msg: String);
VAR
    key: Word;
BEGIN
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 223);
    SetColor(15);
    Rectangle(160, 160, 479, 223);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    OutTextXY(168, 192, msg);
    SetColor(4); OutTextXY(168, 208, 'Enter');
    SetColor(8); OutTextXY(216, 208, 'Confirm');
    REPEAT
        key := ReadKeyPro;
    UNTIL (key = KEY_ENTER);
END;

FUNCTION ShowQuestion(cap, msg: String): Boolean;
VAR
    key: Word;
BEGIN
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 223);
    SetColor(15);
    Rectangle(160, 160, 479, 223);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    OutTextXY(168, 192, msg);
    SetColor(4); OutTextXY(168, 208, 'Y');
    SetColor(8); OutTextXY(184, 208, 'Yes (Confirm)');
    SetColor(4); OutTextXY(304, 208, 'N');
    SetColor(8); OutTextXY(320, 208, 'No (Cancel)');
    REPEAT
        key := ReadKeyPro;
    UNTIL ((key = KEY_Y) OR (key = KEY_N));
    ShowQuestion := (key = KEY_Y);
END;

FUNCTION EditWordValue(old: Word; cap: String): Word;
VAR
    new:        Word;
    p:          Integer;
    key:        Word;
    lv, mv, rv: Word;
BEGIN
    EditWordValue := old;
    new := old;
    p := 0;
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 226);
    SetColor(15);
    Rectangle(160, 160, 479, 226);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    SetColor(4); OutTextXY(168, 208, 'Left/Right');
    SetColor(8); OutTextXY(256, 208, 'Select');
    SetColor(4); OutTextXY(320, 208, 'Up/Down/0-9');
    SetColor(8); OutTextXY(416, 208, 'Set');
    SetColor(4); OutTextXY(168, 216, 'Enter');
    SetColor(8); OutTextXY(216, 216, 'Confirm');
    SetColor(4); OutTextXY(288, 216, 'Esc');
    SetColor(8); OutTextXY(320, 216, 'Cancel');
    REPEAT
        SetFillStyle(SolidFill, 7);
        Bar(300, 189, 339, 201);
        SetColor(15);
        OutTextXY(300, 192, Word2Dec(new));
        Line(332-(8*p), 189, 339-(8*p), 189);
        Line(332-(8*p), 201, 339-(8*p), 201);
        key := ReadKeyPro;
        CASE key OF
            KEY_LEFT:
                IF (p < 4) THEN Inc(p);
            KEY_RIGHT:
                IF (p > 0) THEN Dec(p);
            KEY_UP:
                IncWord(new, TenToThe(p));
            KEY_DOWN:
                DecWord(new, TenToThe(p));
            KEY_ENTER:
                EditWordValue := new;
            ELSE
                IF ((key >= KEY_0) AND (key <= KEY_9)) THEN
                BEGIN
                    IF (p < 4) THEN
                       lv := (new DIV TenToThe(p+1)) * TenToThe(p+1)
                    ELSE
                       lv := 0;
                    mv := (key - KEY_0) * TenToThe(p);
                    rv := new MOD TenToThe(p);
                    new := lv + mv + rv;
                    IF (p > 0) THEN Dec(p);
                END;
        END
    UNTIL ((key = KEY_ESC) OR (key = KEY_ENTER));
END;

FUNCTION EditString(old: String; cap: String; max: Integer): String;
VAR
    new: String;
    x:   Integer;
    key: Word;
BEGIN
    EditString := old;
    new := old;
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 226);
    SetColor(15);
    Rectangle(160, 160, 479, 226);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    SetColor(4); OutTextXY(168, 208, 'A-Z/0-9/..');
    SetColor(8); OutTextXY(256, 208, 'Append');
    SetColor(4); OutTextXY(320, 208, 'Backspace');
    SetColor(8); OutTextXY(400, 208, 'Clear');
    SetColor(4); OutTextXY(168, 216, 'Enter');
    SetColor(8); OutTextXY(216, 216, 'Confirm');
    SetColor(4); OutTextXY(288, 216, 'Esc');
    SetColor(8); OutTextXY(320, 216, 'Cancel');
    REPEAT
        SetColor(15);
        OutTextXY(168, 192, new);
        x := (8*Length(new))+168;
        Line(x, 202, x+7, 202);
        key := ReadKeyPro;
        IF ((key >= $20) AND (key <= $7F)) THEN
        BEGIN
           IF (Length(new) < max) THEN
           BEGIN
               new := new + chr(key);
               SetColor(7);
               Line(x, 202, x+7, 202);
           END;
        END ELSE BEGIN
            CASE key OF
                KEY_BKSPC:
                    IF (Length(new) > 0) THEN
                    BEGIN
                        SetFillStyle(SolidFill, 7);
                        Bar(x-8, 189, x+7, 202);
                        new := Copy(new, 1, Length(new)-1);
                    END;
                KEY_ENTER:
                    EditString := new;
            END;
        END;
    UNTIL ((key = KEY_ESC) OR (key = KEY_ENTER));
END;

END.