unit BMP;

{this is a 'work in progress' unit}

interface

uses Objects, Graph, crt;

{*** Bitmap file header ***}

type BITMAPFILEHEADER = record
                              bfType      : word;
                              bfSize      : longint;
                              bfReserved1 : word;
                              bfReserved2 : word;
                              bfOffBits   : longint;
                        end;

const bfTypeID = 19778; {19778 = 'BM'}

{*** Bitmap info header ***}

type BITMAPINFOHEADER = record
                              biSize          : longint;
                              biWidth         : longint;
                              biHeight        : longint;
                              biPlanes        : word;
                              biBitCount      : word;
                              biCompression   : longint;
                              biSizeImage     : longint;
                              biXPelsPerMeter : longint;
                              biYPelsPerMeter : longint;
                              biClrUsed       : longint;
                              biClrImportant  : longint;
                        end;

{*** RGBQUAD palette structure ***}

type RGBQUAD = record
                     rgbBlue     : byte;
                     rgbGreen    : byte;
                     rgbRed      : byte;
                     rgbReserved : byte;
               end;

{*** OS/2 bitmap core header ***}

type BITMAPCOREHEADER = record
                              bcSize     : longint;
                              bcWidth    : word;
                              bcHeight   : word;
                              bcPlanes   : word;
                              bcBitCount : word;
                        end;

{*** OS/2 RGBTRIPLE palette structure ***}

type RGBTRIPLE = record
                       rgbtBlue  : byte;
                       rgbtGreen : byte;
                       rgbtRed   : byte;
                 end;

{*** Quad palette arrays ***}

type TQuadPalette2      = array[0..1] of RGBQUAD;
     TQuadPalette16     = array[0..15] of RGBQUAD;
     TQuadPalette256    = array[0..255] of RGBQUAD;

{*** Triple palette arrays ***}

type TTriplePalette2    = array[0..1] of RGBTRIPLE;
     TTriplePalette16   = array[0..15] of RGBTRIPLE;
     TTriplePalette256  = array[0..255] of RGBTRIPLE;

{*** Bitmap file constants ***}

const BMP_INVALID = 1000;
      BMP_WINDOWS = 1001;
      BMP_OS2     = 1002;

{*** Bitmap compression constants ***}

const BI_RGB  = 0;
      BI_RLE8 = 1;
      BI_RLE4 = 2;

{*** Fixed palette (3:3:2) used for 24bit images ***}

{$I BMPPAL24}

{*** BMP functions/procedures ***}

function  GetBMPFileType(var S : TStream) : word;
procedure GetBMPFileHeader(var S : TStream; var Hdr : BITMAPFILEHEADER);
procedure GetBMPInfoHeader(var S : TStream; var Hdr : BITMAPINFOHEADER);
procedure GetBMPCoreHeader(var S : TStream; var Hdr : BITMAPCOREHEADER);

procedure LoadQuadPalette2(var S : TStream; var P : TQuadPalette2);
procedure LoadQuadPalette16(var S : TStream; var P : TQuadPalette16);
procedure LoadQuadPalette256(var S : TStream; var P : TQuadPalette256);

procedure LoadTriplePalette2(var S : TStream; var P : TTriplePalette2);
procedure LoadTriplePalette16(var S : TStream; var P : TTriplePalette16);
procedure LoadTriplePalette256(var S : TStream; var P : TTriplePalette256);

function  GetPalIndex(R, G, B : byte) : byte;

procedure DecodeWinBMP2(var S : TStream);
procedure DecodeWinBMP16(var S : TStream);
procedure DecodeWinBMP256(var S : TStream);
procedure DecodeWinBMP16M(var S : TStream);

procedure DecodeOS2BMP2(var S : TStream);
procedure DecodeOS2BMP16(var S : TStream);
procedure DecodeOS2BMP256(var S : TStream);
procedure DecodeOS2BMP16M(var S : TStream);

{******}

implementation

{******}

procedure GetBMPFileHeader(var S : TStream; var Hdr : BITMAPFILEHEADER);

var SPos : longint;

begin
     SPos:= S.GetPos;
     S.Seek(0);
     S.Read(Hdr, sizeof(BITMAPFILEHEADER));
     S.Seek(SPos);
end;

{******}

function GetBMPFileType(var S : TStream) : word;

var Hdr     : BITMAPFILEHEADER;
    SPos    : longint;
    BMPType : word;
    bcSize  : longint;

begin
     SPos:= S.GetPos;
     S.Seek(0);
     S.Read(Hdr, sizeof(BITMAPFILEHEADER));


     if Hdr.bfType <> bfTypeID then
     begin
          S.Seek(SPos);
          GetBMPFileType:= BMP_INVALID;
          exit;
     end;

     S.Read(bcSize, sizeof(bcSize));
     if bcSize = sizeof(BITMAPCOREHEADER) then BMPType:= BMP_OS2
                                          else BMPType:= BMP_WINDOWS;

     S.Seek(SPos);
     GetBMPFileType:= BMPType;
end;

{******}

procedure GetBMPInfoHeader(var S : TStream; var Hdr : BITMAPINFOHEADER);

var SPos : longint;

begin
     SPos:= S.GetPos;
     S.Seek(sizeof(BITMAPFILEHEADER));
     S.Read(Hdr, sizeof(BITMAPINFOHEADER));
     S.Seek(SPos);
end;

{******}

procedure GetBMPCoreHeader(var S : TStream; var Hdr : BITMAPCOREHEADER);

var SPos : longint;

begin
     SPos:= S.GetPos;
     S.Seek(sizeof(BITMAPFILEHEADER));
     S.Read(Hdr, sizeof(BITMAPCOREHEADER));
     S.Seek(SPos);
end;

{******}

procedure LoadQuadPalette2(var S : TStream; var P : TQuadPalette2);

var SPos : longint;
    Loop : byte;

begin
     SPos:= S.GetPos;
     S.Seek(sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

     for Loop:= 0 to 1 do
     begin
          S.Read(P[Loop], sizeof(RGBQUAD));
     end;
     S.Seek(SPos);
end;

{******}

procedure LoadQuadPalette16(var S : TStream; var P : TQuadPalette16);

var SPos : longint;
    Loop : byte;

begin
     SPos:= S.GetPos;
     S.Seek(sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

     for Loop:= 0 to 15 do
     begin
          S.Read(P[Loop], sizeof(RGBQUAD));
     end;
     S.Seek(SPos);
end;

{******}

procedure LoadQuadPalette256(var S : TStream; var P : TQuadPalette256);

var SPos : longint;
    Loop : byte;

begin
     SPos:= S.GetPos;
     S.Seek(sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

     for Loop:= 0 to 255 do
     begin
          S.Read(P[Loop], sizeof(RGBQUAD));
     end;
     S.Seek(SPos);
end;

{******}

procedure LoadTriplePalette2(var S : TStream; var P : TTriplePalette2);

var SPos : longint;
    Loop : byte;

begin
     SPos:= S.GetPos;
     S.Seek(sizeof(BITMAPFILEHEADER) + sizeof(BITMAPCOREHEADER));

     for Loop:= 0 to 1 do
     begin
          S.Read(P[Loop], sizeof(RGBTRIPLE));
     end;
     S.Seek(SPos);
end;

{******}

procedure LoadTriplePalette16(var S : TStream; var P : TTriplePalette16);

var SPos : longint;
    Loop : byte;

begin
     SPos:= S.GetPos;
     S.Seek(sizeof(BITMAPFILEHEADER) + sizeof(BITMAPCOREHEADER));

     for Loop:= 0 to 15 do
     begin
          S.Read(P[Loop], sizeof(RGBTRIPLE));
     end;
     S.Seek(SPos);
end;

{******}

procedure LoadTriplePalette256(var S : TStream; var P : TTriplePalette256);

var SPos : longint;
    Loop : byte;

begin
     SPos:= S.GetPos;
     S.Seek(sizeof(BITMAPFILEHEADER) + sizeof(BITMAPCOREHEADER));

     for Loop:= 0 to 255 do
     begin
          S.Read(P[Loop], sizeof(RGBTRIPLE));
     end;
     S.Seek(SPos);
end;

{******}

function GetPalIndex(R, G, B : byte) : byte;

begin
     GetPalIndex:= ((B shr 6) or ((G shr 3) and $1C) or (R and $E0));
end;

{******}

procedure DecodeWinBMP2(var S : TStream);

{******}

procedure DecodeRGB(Width, Height : longint);

var X, Y       : word;
    C1         : byte;
    C2         : array[1..8] of byte;
    C3         : byte;

begin
     X:= 0;
     Y:= Height;

     while Y > 0 do
     begin
          while X <= Width do
          begin
               S.Read(C1, sizeof(C1));

               C2[1]:= (C1 and $80) shr 7;
               C2[2]:= (C1 and $40) shr 6;
               C2[3]:= (C1 and $20) shr 5;
               C2[4]:= (C1 and $10) shr 4;
               C2[5]:= (C1 and $08) shr 3;
               C2[6]:= (C1 and $04) shr 2;
               C2[7]:= (C1 and $02) shr 1;
               C2[8]:= (C1 and $01);

               for C3:= 1 to 8 do
               begin
                    PutPixel(X, Y, C2[C3]);
                    Inc(X);
               end;
          end;
          X:= 0;
          Dec(Y);
     end;
end;

{******}

var Pal        : TQuadPalette2;
    bmfh       : BITMAPFILEHEADER;
    bmih       : BITMAPINFOHEADER;
    loop       : byte;

begin
     LoadQuadPalette2(S, Pal);
     for Loop:= 0 to 1 do
         SetRGBPalette(Loop, Pal[Loop].rgbRed,
                             Pal[Loop].rgbGreen,
                             Pal[Loop].rgbBlue);

     GetBMPFileHeader(S, bmfh);
     GetBMPInfoHeader(S, bmih);

     S.Seek(bmfh.bfOffBits);

     case bmih.biCompression of
          BI_RGB : DecodeRGB(bmih.biWidth, bmih.biHeight);
     end;
end;

{******}

procedure DecodeWinBMP16(var S : TStream);

{******}

procedure DecodeRGB(Width, Height : longint);

var X, Y       : word;
    C1, C2, C3 : byte;

begin
     X:= 0;
     Y:= Height;

     while Y > 0 do
     begin
          while X <= Width do
          begin
               S.Read(C1, sizeof(C1));
               C2:= (C1 and $F0) shr 4;
               PutPixel(X, Y, C2);
               Inc(X);
               C3:= (C1 and $0F);
               PutPixel(X, Y, C3);
               Inc(X);
          end;
          X:= 0;
          Dec(Y);
     end;
end;

{******}

procedure DecodeRLE4(FHdr : BITMAPFILEHEADER; IHdr : BITMAPINFOHEADER);

var B1, B2  : byte;
    dx, dy  : byte;
    X, Y    : integer;
    Loop    : byte;
    Value   : byte;
    C1, C2  : byte;
    Count   : byte;
    Temp    : byte;
    Size    : longint;

begin
     X:= 0;
     Y:= IHdr.biHeight;

     S.Seek(FHdr.bfOffBits);
     Size:= S.GetSize;

     while S.GetPos < Size do
     begin
          S.Read(B1, sizeof(B1));

          if (B1 <> 0) then
          begin
               Count:= B1;
               S.Read(Value, sizeof(Value));
               C1:= (Value and $F0) shr 4;
               C2:= (Value and $0F);
               
               Loop:= Count;
               while (Loop > 0) do
               begin
                    PutPixel(X, Y, C1);
                    Inc(X);
                    Dec(Loop);
                    if Loop > 0 then
                    begin
                         PutPixel(X, Y, C2);
                         Inc(X);
                         Dec(Loop);
                    end;
               end;
          end
          else
          begin
               S.Read(B2, sizeof(B2));

               if (B2 = 0) then
               begin
                    Dec(Y);
                    X:= 0;
               end
               else if (B2 = 1) then
                    begin
                         exit;
                    end
                    else if (B2 = 2) then
                         begin
                              S.Read(dx, sizeof(dx));
                              S.Read(dy, sizeof(dy));
                              Inc(X, dx);
                              Inc(Y, dy);
                         end
                         else if (B2 >= 3) then
                              begin
                                   Loop:= B2;
                                   while Loop > 0 do
                                   begin
                                        S.Read(Value, sizeof(Value));
                                        C1:= (Value and $F0) shr 4;
                                        C2:= (Value and $0F);

                                        PutPixel(X, Y, C1);
                                        Inc(X);
                                        Dec(Loop);
                                        if Loop > 0 then
                                        begin
                                             PutPixel(X, Y, C2);
                                             Inc(X);
                                             Dec(Loop);
                                        end;
                                   end;
                                   S.Read(Temp, sizeof(Temp));
                                   if (Temp <> 0) or ((X >= 319) and
                                      (Odd(S.GetPos - FHdr.bfOffBits)))
                                      then S.Seek(S.GetPos - 1);
                              end;
          end;
     end;
end;

{******}

var Pal        : TQuadPalette16;
    bmfh       : BITMAPFILEHEADER;
    bmih       : BITMAPINFOHEADER;
    loop       : byte;

begin
     LoadQuadPalette16(S, Pal);
     for Loop:= 0 to 15 do
         SetRGBPalette(Loop, Pal[Loop].rgbRed,
                             Pal[Loop].rgbGreen,
                             Pal[Loop].rgbBlue);

     GetBMPFileHeader(S, bmfh);
     GetBMPInfoHeader(S, bmih);

     S.Seek(bmfh.bfOffBits);

     case bmih.biCompression of
          BI_RGB  : DecodeRGB(bmih.biWidth, bmih.biHeight);
          BI_RLE4 : DecodeRLE4(bmfh, bmih);
     end;
end;

{******}

procedure DecodeWinBMP256(var S : TStream);

{******}

procedure DecodeRGB(Width, Height : longint);

var X, Y : word;
    C    : byte;

begin
     X:= 0;
     Y:= Height;

     while Y > 0 do
     begin
          while X <= Width do
          begin
               S.Read(C, sizeof(C));
               PutPixel(X, Y, C);
               Inc(X);
          end;
          X:= 0;
          Dec(Y);
     end;
end;

{******}

procedure DecodeRLE8(FHdr : BITMAPFILEHEADER; IHdr : BITMAPINFOHEADER);

var B1, B2  : byte;
    dx, dy  : byte;
    X, Y    : integer;
    Loop    : byte;
    Value   : byte;
    Count   : byte;
    Temp    : byte;
    Size    : longint;

begin
     X:= 0;
     Y:= IHdr.biHeight;

     S.Seek(FHdr.bfOffBits);
     Size:= S.GetSize;

     while S.GetPos < Size do
     begin
          S.Read(B1, sizeof(B1));

          if (B1 <> 0) then
          begin
               Count:= B1;
               S.Read(Value, sizeof(Value));

               for Loop:= 1 to Count do
               begin
                    PutPixel(X, Y, Value);
                    Inc(X);
               end;
          end
          else
          begin
               S.Read(B2, sizeof(B2));

               if (B2 = 0) then
               begin
                    Dec(Y);
                    X:= 0;
               end
               else if (B2 = 1) then
                    begin
                         exit;
                    end
                    else if (B2 = 2) then
                         begin
                              S.Read(dx, sizeof(dx));
                              S.Read(dy, sizeof(dy));
                              Inc(X, dx);
                              Inc(Y, dy);
                         end
                         else if (B2 >= 3) then
                              begin
                                   for Loop:= 1 to B2 do
                                   begin
                                        S.Read(Value, sizeof(Value));
                                        PutPixel(X, Y, Value);
                                        Inc(X);
                                   end;
                                   S.Read(Temp, sizeof(Temp));
                                   if (Temp <> 0) or ((X >= 319) and
                                      (Odd(S.GetPos - FHdr.bfOffBits)))
                                      then S.Seek(S.GetPos - 1);
                              end;
          end;
     end;
end;

{******}

var Pal        : TQuadPalette256;
    bmfh       : BITMAPFILEHEADER;
    bmih       : BITMAPINFOHEADER;
    loop       : byte;

begin
     LoadQuadPalette256(S, Pal);
     for Loop:= 0 to 255 do
         SetRGBPalette(Loop, Pal[Loop].rgbRed,
                             Pal[Loop].rgbGreen,
                             Pal[Loop].rgbBlue);

     GetBMPFileHeader(S, bmfh);
     GetBMPInfoHeader(S, bmih);

     S.Seek(bmfh.bfOffBits);

     case bmih.biCompression of
          BI_RGB  : DecodeRGB(bmih.biWidth, bmih.biHeight);
          BI_RLE8 : DecodeRLE8(bmfh, bmih);
     end;
end;

{******}

procedure DecodeWinBMP16M(var S : TStream);

{******}

procedure DecodeRGB(Width, Height : longint);

var X, Y    : word;
    R,G,B,I : byte;

begin
     X:= 0;
     Y:= Height;

     while Y > 0 do
     begin
          while X <= Width do
          begin
               S.Read(R, sizeof(R));
               S.Read(G, sizeof(G));
               S.Read(B, sizeof(B));
               I:= GetPalIndex(R, G, B);
               PutPixel(X, Y, I);
               Inc(X);
          end;
          X:= 0;
          Dec(Y);
     end;
end;

{******}

var Pal        : TQuadPalette256;
    bmfh       : BITMAPFILEHEADER;
    bmih       : BITMAPINFOHEADER;
    loop       : word;
    index      : byte;

begin
     Loop:= 0;
     Index:= 0;
     while (Loop < 768) do
     begin
          Pal[Index].rgbRed:= orthopalette[Loop];
          Inc(Loop);
          Pal[Index].rgbGreen:= orthopalette[Loop];
          Inc(Loop);
          Pal[Index].rgbBlue:= orthopalette[Loop];
          Inc(Loop);
          SetRGBPalette(Index, Pal[Index].rgbRed,
                               Pal[Index].rgbGreen,
                               Pal[Index].rgbBlue);
          Inc(Index);
     end;

     GetBMPFileHeader(S, bmfh);
     GetBMPInfoHeader(S, bmih);

     S.Seek(bmfh.bfOffBits);

     case bmih.biCompression of
          BI_RGB  : DecodeRGB(bmih.biWidth, bmih.biHeight);
     end;
end;


{******}

procedure DecodeOS2BMP2(var S : TStream);

{******}

procedure DecodeRGB(Width, Height : word);

var X, Y       : word;
    C1         : byte;
    C2         : array[1..8] of byte;
    C3         : byte;

begin
     X:= 0;
     Y:= Height;

     while Y > 0 do
     begin
          while X <= Width do
          begin
               S.Read(C1, sizeof(C1));

               C2[1]:= (C1 and $80) shr 7;
               C2[2]:= (C1 and $40) shr 6;
               C2[3]:= (C1 and $20) shr 5;
               C2[4]:= (C1 and $10) shr 4;
               C2[5]:= (C1 and $08) shr 3;
               C2[6]:= (C1 and $04) shr 2;
               C2[7]:= (C1 and $02) shr 1;
               C2[8]:= (C1 and $01);

               for C3:= 1 to 8 do
               begin
                    PutPixel(X, Y, C2[C3]);
                    Inc(X);
               end;
          end;
          X:= 0;
          Dec(Y);
     end;
end;

{******}

var Pal        : TTriplePalette2;
    bmfh       : BITMAPFILEHEADER;
    bmch       : BITMAPCOREHEADER;
    loop       : byte;

begin
     LoadTriplePalette2(S, Pal);
     for Loop:= 0 to 1 do
         SetRGBPalette(Loop, Pal[Loop].rgbtRed,
                             Pal[Loop].rgbtGreen,
                             Pal[Loop].rgbtBlue);

     GetBMPFileHeader(S, bmfh);
     GetBMPCoreHeader(S, bmch);

     S.Seek(bmfh.bfOffBits);
     DecodeRGB(bmch.bcWidth, bmch.bcHeight);
end;

{******}

procedure DecodeOS2BMP16(var S : TStream);

{******}

procedure DecodeRGB(Width, Height : word);

var X, Y       : word;
    C1, C2, C3 : byte;

begin
     X:= 0;
     Y:= Height;

     while Y > 0 do
     begin
          while X <= Width do
          begin
               S.Read(C1, sizeof(C1));
               C2:= (C1 and $F0) shr 4;
               PutPixel(X, Y, C2);
               Inc(X);
               C3:= (C1 and $0F);
               PutPixel(X, Y, C3);
               Inc(X);
          end;
          X:= 0;
          Dec(Y);
     end;
end;

{******}

var Pal        : TTriplePalette16;
    bmfh       : BITMAPFILEHEADER;
    bmch       : BITMAPCOREHEADER;
    loop       : byte;

begin
     LoadTriplePalette16(S, Pal);
     for Loop:= 0 to 15 do
         SetRGBPalette(Loop, Pal[Loop].rgbtRed,
                             Pal[Loop].rgbtGreen,
                             Pal[Loop].rgbtBlue);

     GetBMPFileHeader(S, bmfh);
     GetBMPCoreHeader(S, bmch);

     S.Seek(bmfh.bfOffBits);
     DecodeRGB(bmch.bcWidth, bmch.bcHeight);
end;

{******}

procedure DecodeOS2BMP256(var S : TStream);

{******}

procedure DecodeRGB(Width, Height : word);

var X, Y : word;
    C    : byte;

begin
     X:= 0;
     Y:= Height;

     while Y > 0 do
     begin
          while X <= Width do
          begin
               S.Read(C, sizeof(C));
               PutPixel(X, Y, C);
               Inc(X);
          end;
          X:= 0;
          Dec(Y);
     end;
end;

{******}

var Pal        : TTriplePalette256;
    bmfh       : BITMAPFILEHEADER;
    bmch       : BITMAPCOREHEADER;
    loop       : byte;

begin
     LoadTriplePalette256(S, Pal);
     for Loop:= 0 to 255 do
         SetRGBPalette(Loop, Pal[Loop].rgbtRed,
                             Pal[Loop].rgbtGreen,
                             Pal[Loop].rgbtBlue);

     GetBMPFileHeader(S, bmfh);
     GetBMPCoreHeader(S, bmch);

     S.Seek(bmfh.bfOffBits);
     DecodeRGB(bmch.bcWidth, bmch.bcHeight);
end;

{******}

procedure DecodeOS2BMP16M(var S : TStream);

{******}

procedure DecodeRGB(Width, Height : word);

var X, Y    : word;
    R,G,B,I : byte;

begin
     X:= 0;
     Y:= Height;

     while Y > 0 do
     begin
          while X <= Width do
          begin
               S.Read(R, sizeof(R));
               S.Read(G, sizeof(G));
               S.Read(B, sizeof(B));
               I:= GetPalIndex(R, G, B);
               PutPixel(X, Y, I);
               Inc(X);
          end;
          X:= 0;
          Dec(Y);
     end;
end;

{******}

var Pal        : TTriplePalette256;
    bmfh       : BITMAPFILEHEADER;
    bmch       : BITMAPCOREHEADER;
    loop       : word;
    index      : byte;

begin
     Loop:= 0;
     Index:= 0;
     while (Loop < 768) do
     begin
          Pal[Index].rgbtRed:= orthopalette[Loop];
          Inc(Loop);
          Pal[Index].rgbtGreen:= orthopalette[Loop];
          Inc(Loop);
          Pal[Index].rgbtBlue:= orthopalette[Loop];
          Inc(Loop);
          Inc(Index);
          SetRGBPalette(Index, Pal[Index].rgbtRed,
                               Pal[Index].rgbtGreen,
                               Pal[Index].rgbtBlue);
     end;

     for Loop:= 0 to 255 do

     GetBMPFileHeader(S, bmfh);
     GetBMPCoreHeader(S, bmch);

     S.Seek(bmfh.bfOffBits);
     DecodeRGB(bmch.bcWidth, bmch.bcHeight);
end;

{******}

end.