program TestSJoy;

uses SJOY, SERROR, CRT;

{******}

function JoyDirStr(Dir : byte) : string;

var s : string;

begin
     case Dir of
          JOY_CENTRE    : s:= 'CENTRE';
          JOY_UP        : s:= 'UP';
          JOY_DOWN      : s:= 'DOWN';
          JOY_LEFT      : s:= 'LEFT';
          JOY_RIGHT     : s:= 'RIGHT';
          JOY_UPLEFT    : s:= 'UP LEFT';
          JOY_UPRIGHT   : s:= 'UP RIGHT';
          JOY_DOWNRIGHT : s:= 'DOWN RIGHT';
          JOY_DOWNLEFT  : s:= 'DOWN LEFT';
     end;
     JoyDirStr:= s;
end;

{******}

var UseJoy : byte;
    Ch     : char;

begin
     ClrScr;
     writeln('SJOY test program.');
     writeln;
     writeln('Game adaptor detected         : ', DetectJoysticks);
     writeln('Number of joysticks connected : ', GetTotalJoysticks);
     writeln('Joystick 1 installed          : ', GetInstalledJoystick(1));
     writeln('Joystick 2 installed          : ', GetInstalledJoystick(2));
     writeln;
     readkey;
     if not DetectJoysticks then exit;
     if GetInstalledJoystick(1) then UseJoy:= 1 else UseJoy:= 2;
     ClrScr;
     writeln('Calibrating joystick ', UseJoy, ', please wait...');
     InitJoysticks;
     ClrScr;
     repeat
           GotoXY(1, 1);
           writeln('Joystick ', UseJoy, ' test.');
           GotoXY(1, 3);
           writeln('XCentre   : ', Joysticks[UseJoy].XCentre);
           GotoXY(1, 4);
           writeln('YCentre   : ', Joysticks[UseJoy].YCentre);
           GotoXY(1, 5);
           writeln('XOffset   :                ');
           GotoXY(13, 5);
           writeln(Joysticks[UseJoy].XOffset);
           GotoXY(1, 6);
           writeln('YOffset   :                ');
           GotoXY(13, 6);
           writeln(Joysticks[UseJoy].YOffset);
           GotoXY(1, 7);
           writeln('XPosition :                ');
           GotoXY(13, 7);
           writeln(Joysticks[UseJoy].XPosition);
           GotoXY(1, 8);
           writeln('YPosition :                ');
           GotoXY(13, 8);
           writeln(Joysticks[UseJoy].YPosition);
           GotoXY(1, 9);
           writeln('Range     : ', Joysticks[UseJoy].Range);
           GotoXY(1, 10);
           writeln('Direction :                ');
           GotoXY(13, 10);
           writeln(JoyDirStr(Joysticks[UseJoy].Direction));
           GotoXY(1, 11);
           writeln('Button 1  :                ');
           GotoXY(13, 11);
           writeln(Joysticks[UseJoy].Button1);
           GotoXY(1, 12);
           writeln('Button 2  :                ');
           GotoXY(13, 12);
           writeln(Joysticks[UseJoy].Button2);
           GotoXY(1, 13);
           writeln('Error code:                ');
           GotoXY(13, 13);
           writeln(Lo(SErrorCode));

{           ch:= upcase(readkey);}
{           ClrScr;}
           GetJoystickStatus(UseJoy);
     until keypressed{ch = 'Q'};
     readkey;
end.

