program TestSMem;

uses Crt, SXMS, SEMS, SDMA, SERROR, SUTILS;

var BlockSize   : word;
    BlockHandle : word;

begin
     ClrScr;
     writeln('XMS driver present : ', XMS_Detect);
     XMS_Init;
     EMS_Init;
     writeln('XMS version        : ', Hi(XMS_GetVersion), '.', Lo(XMS_GetVersion));
     writeln('XMM version        : ', Hi(XMS_GetXMMVersion), '.', Lo(XMS_GetVersion));
     writeln('HMA present        : ', XMS_GetHMAPresent);
     writeln('Total XMS free     : ', XMS_GetTotalFree, 'K');
     writeln('Largest free block : ', XMS_GetLargestFree, 'K');
     writeln('Available upper mem: ', XMS_GetFreeUMB, 'K');
     writeln;
     writeln('EMS driver present : ', EMS_Detect);
     writeln('EMS version        : ', Hi(EMS_GetVersion), '.', Lo(EMS_GetVersion));
     writeln('EMS total pages    : ', EMS_GetTotalPages, ' (', (EMS_GetTotalPages * 16), 'K)');
     writeln('EMS free pages     : ', EMS_GetFreePages, ' (', (EMS_GetFreePages * 16), 'K)');
     writeln('EMS page frame     : ', U_DecToHex(EMS_GetPageFrame));
     writeln;
     readkey;

     {*** XMS test ***}
     BlockSize:= XMS_GetLargestFree div 2;
     writeln('Allocating ', BlockSize, 'K XMS.');
     BlockHandle:= XMS_EMBGetMem(BlockSize);
     writeln('Handle             : ', BlockHandle);
     writeln('Error code         : ', U_DecToHex(SErrorCode));
     writeln('Total XMS free     : ', XMS_GetTotalFree, 'K');
     writeln('Largest free block : ', XMS_GetLargestFree, 'K');
     readkey;
     writeln;
     writeln('Freeing memory.');
     XMS_EMBFreeMem(BlockHandle);
     writeln('Error code         : ', U_DecToHex(SErrorCode));
     writeln('Total XMS free     : ', XMS_GetTotalFree, 'K');
     writeln('Largest free block : ', XMS_GetLargestFree, 'K');
     readkey;
     writeln;
     writeln;
     {*** EMS test ***}
     BlockSize:= EMS_GetFreePages;
     writeln('Allocating ', BlockSize * 16, 'K EMS.');
     BlockHandle:= EMS_GetMem(BlockSize);
     writeln('Handle             : ', BlockHandle);
     writeln('Error code         : ', U_DecToHex(SErrorCode));
     writeln('Total EMS free     : ', EMS_GetFreePages * 16, 'K');

     readkey;
     writeln;
     writeln('Freeing memory.');
     EMS_FreeMem(BlockHandle);
     writeln('Error code         : ', U_DecToHex(SErrorCode));
     writeln('Total EMS free     : ', EMS_GetFreePages * 16, 'K');
     readkey;

end.