unit SGFX_PAL;

(* Information
   

   Program Title : SGFX Palette handling library.
   External name : SGFXPAL.TPU
   Version       : 2.0
   Start date    : 30/12/96
   Last update   : 30/12/96
   Author        : Rob Anderton.
   Description   : Palette manipulation routines for the SGFX32 library.
*)

interface

{******}

function Pal_RGB(wR, wG, wB : word) : longint;

{******}

implementation

{******}

uses SGFX32;

{******}

function Pal_RGB(wR, wG, wB : word) : longint;

(* Pal_RGB - converts R,G,B values into a the correct form for the current
             graphics mode.                                                 *)

begin
     wr:= lo(wr);
     wg:= lo(wg);
     wb:= lo(wb);

     case GFX_Screen.ModeInfo.bMemModel of
                  MEM_PACKED8 : Pal_RGB:= wr;  {Not meant for 8bpp modes}
                  MEM_PLANAR8 : Pal_RGB:= wr;

                  MEM_TRUE15  : Pal_RGB:= ((wr shr 3) shl 5 +
                                           (wg shr 3)) shl 5 +
                                           (wb shr 3);

                  MEM_TRUE16  : Pal_RGB:= ((wr shr 3) shl 6 +
                                           (wg shr 2)) shl 5 +
                                           (wb shr 3);

                  MEM_TRUE24,
                  MEM_TRUE32  : Pal_RGB:= ((longint(wr) shl 8 + wg)
                                                        shl 8 + wb);
     end;
end;

{******}

end.