unit SGFX_VGA;

(* Information
   

   Program Title : SGFX VGA Library.
   External name : SGFX_VGA.TPU
   Version       : 2.0
   Start date    : 29/12/96
   Last update   : 29/12/96
   Author        : Rob Anderton.
   Description   : Standard VGA mode 13h graphics routines for SGFX32.

*)

interface

{******}

procedure VGA_Init;
procedure VGA_Done;

{******}

implementation

{******}

uses SGFX32;

{******}

function VGA_GetVideoName(ModeInfo : TModeRec) : string;

begin
     if (ModeInfo.wMode < $1001) or
        (ModeInfo.wMode > $1001) or
        (ModeInfo.wChip <> 0) then VGA_GetVideoName:= ''
                              else VGA_GetVideoName:= 'Standard VGA chipset';
end;

{******}

procedure VGA_Cls(lCol : longint); assembler;

asm
   mov  ax, VID_SEG
   mov  es, ax
   xor  di, di
   mov  al, [byte(lCol)]
   mov  ah, al
   mov  bx, ax
   db   $66
   shl  ax, 16
   mov  ax, bx
   mov  cx, 16000
   db   $66
   rep  stosw
end;

{******}

procedure VGA_PutPixel(wx, wy : word; lCol : longint); assembler;

asm
   mov     ax, VID_SEG
   mov     es, ax
   mov     ax, [wy]
   mov     di, ax
   shl     di, 8
   shl     ax, 6
   add     di, ax
   add     di, [wx]
   mov     al, [byte(lCol)]
   mov     es:[di], al
end;

{******}

procedure VGA_Put2Pixel(wx, wy : word; lCol : longint); assembler;

asm
   mov     ax, VID_SEG
   mov     es, ax
   mov     ax, [wy]
   mov     di, ax
   shl     di, 8
   shl     ax, 6
   add     di, ax
   add     di, [wx]
   mov     al, [byte(lCol)]
   mov     ah, al
   mov     es:[di], ax
end;

{******}

procedure VGA_Put4Pixel(wx, wy : word; lCol : longint); assembler;

asm
   mov     ax, VID_SEG
   mov     es, ax
   mov     ax, [wy]
   mov     di, ax
   shl     di, 8
   shl     ax, 6
   add     di, ax
   add     di, [wx]
   mov     al, [byte(lCol)]
   mov     ah, al
   mov     dx, ax
   db      $66
   shl     ax, 16
   mov     ax, dx
   db      $66
   mov     es:[di], ax
end;

{******}

function VGA_GetPixel(wx, wy : word) : longint; assembler;

asm
   mov     ax, VID_SEG
   mov     es, ax
   mov     ax, [wy]
   mov     di, ax
   shl     di, 8
   shl     ax, 6
   add     di, ax
   add     di, [wx]
   mov     al, es:[di]
end;

{******}

procedure VGA_HLine(wx1, wx2, wy : word; lCol : longint); assembler;

asm
   mov   ax, VID_SEG
   mov   es, ax
   mov   ax, [wy]
   mov   di, ax
   shl   ax, 8
   shl   di, 6
   add   di, ax
   mov   bx, [wx1]
   add   di, bx
   mov   al, [byte(lCol)]
   mov   ah, al
   mov   cx, [wx2]
   sub   cx, bx
   test  cx, 1
   jz    @EXIT
   stosb

@EXIT:

   shr cx, 1
   rep stosw

end;

{******}

procedure VGA_VLine(wx, wy1, wy2 : word; lCol : longint); assembler;

asm
   mov     ax, VID_SEG
   mov     es, ax
   mov     bx, [wy1]
   mov     ax, bx
   mov     di, ax
   shl     ax, 8
   shl     di, 6
   add     di, ax
   add     di, [wx]
   mov     al, [byte(lCol)]
   mov     cx, [wy2]
   sub     cx, bx

@@1:

   mov     es:[di], al
   add     di, 320
   dec     cx
   jnz     @@1

end;

{******}

procedure VGA_Line(wx1, wy1, wx2, wy2 : word; lCol : longint); assembler;

asm
   mov     ax, [wx1]
   mov     bx, [wx2]
   mov     cx, [wy1]
   mov     dx, [wy2]

   cmp     cx, dx
   jbe     @1
   xchg    cx, dx
   xchg    ax, bx

@1:

   mov     di, cx
   shl     di, 2
   add     di, cx
   mov     si, bx
   mov     bx, dx
   sub     bx, cx
   shl     di, 6
   add     di, ax
   mov     dx, si
   sub     dx, ax

   mov     ax, VID_SEG
   mov     es, ax
   mov     al, [byte(lCol)]
   or      dx, 0
   jge     @jmp1
   neg     dx
   cmp     dx, bx
   jbe     @jmp3

   mov     cx, dx
   inc     cx
   mov     si, dx
   shr     si, 1
   std

@1c:

   stosb

@1b:

   or      si,si
   jge     @1a
   add     di, 320
   add     si, dx
   jmp     @1b

@1a:

   sub     si, bx
   dec     cx
   jnz     @1c
   jmp     @EXIT

@jmp3:

   mov     cx, bx
   inc     cx
   mov     si, bx
   neg     si
   sar     si, 1
   cld

@2c:

   stosb

@2b:

   or      si, si
   jl      @2a
   sub     si, bx
   dec     di
   jmp     @2b

@2a:

   add     di, 319
   add     si, dx
   dec     cx
   jnz     @2c
   jmp     @EXIT

@jmp1:

   cmp     dx, bx
   jbe     @jmp4
   mov     cx, dx
   inc     cx
   mov     si, dx
   shr     si, 1
   cld

@3c:

   stosb

@3b:

   or      si, si
   jge     @3a
   add     di, 320
   add     si, dx
   jmp     @3b

@3a:

   sub     si, bx
   dec     cx
   jnz     @3c
   jmp     @EXIT

@jmp4:

   mov     cx, bx
   inc     cx
   mov     si, bx
   neg     si
   sar     si, 1
   std

@4c:

   stosb

@4b:

   or      si, si
   jl      @4a
   sub     si, bx
   inc     di
   jmp     @4b

@4a:

   add     di, 321
   add     si, dx
   dec     cx
   jnz     @4c

@EXIT:

   cld

end;

{******}

procedure VGA_Rectangle(wx, wy, ww, wh : word; lCol : longint);

var wx2, wy2 : word;

begin
     wx2:= wx + ww;
     wy2:= wy + wh;
     GFX_HLine(wx, wx2, wy, lCol);
     GFX_HLine(wx, wx2, wy2, lCol);
     GFX_VLine(wx, wy, wy2, lCol);
     GFX_VLine(wx2, wy, wy2, lCol);
end;

{******}

procedure VGA_FilledRectangle(wx, wy, ww, wh : word; lCol : longint); assembler;

asm
   mov   ax, VID_SEG
   mov   es, ax
   mov   ax, [wy]
   mov   di, ax
   shl   ax, 8
   shl   di, 6
   add   di, ax
   add   di, [wx]
   mov   al, [byte(lCol)]
   mov   ah, al

   mov   dx, [wh]
   mov   si, [ww]
   mov   bx, 319
   sub   bx, si

@DRAWLOOP:

   mov   cx, si
   inc   cx
   shr   cx, 1
   jnc   @P24
   stosb

@P24:

   rep   stosw

   add   di, bx
   dec   dx
   jnz   @DRAWLOOP

end;

{******}

procedure VGA_Circle(wx, wy, wr : word; lCol : longint);

{******}

        procedure CirclePoint(X, Y, Xc, Yc : integer; bCol : byte); assembler;

        var XXCp, XXCm, XYCp, XYCm, YXCp, YXCm, YYCp, YYCm : integer;

        asm
           mov  cx, X    { store in registers for faster access }
           mov  dx, Y    { instead of accessing memory each time }

           mov  bx, XC   { store XC in bx - cut down on mem access }

           mov  ax, bx   { XXCp := XC+X; }
           add  ax, cx
           mov  XXCp, ax

           mov  ax, bx   { XXCm := XC-X; }
           sub  ax, cx
           mov  XXCm, ax

           mov  ax, bx   { XYCp := XC+Y; }
           add  ax, dx
           mov  XYCp, ax

           mov  ax, bx   { XYCm := XC-Y; }
           sub  ax, dx
           mov  XYCm, ax

           mov  bx, YC   { store YC in bx - cut down on mem access }

           mov  ax, bx   { YXCp := YC+X; }
           add  ax, cx
           mov  YXCp, ax

           mov  ax, bx   { YXCm := YC-X; }
           sub  ax, cx
           mov  YXCm, ax

           mov  ax, bx   { YYCp := YC+Y; }
           add  ax, dx
           mov  YYCp, ax

           mov  ax, bx   { YYCm := YC-Y; }
           sub  ax, dx
           mov  YYCm, ax

           mov  bl, bCol
           xor  bh, bh
           mov  dx, XXCp

           mov  ax, VID_SEG
           mov  es, ax
           mov  di, dx
           mov  ax, YYCp
           xchg al, ah
           add  di, ax
           shr  ax, 2
           add  di, ax
           mov  ax, bx
           stosb

           sub  di, di
           add  di, dx
           mov  ax, YYCm
           xchg al, ah
           add  di, ax
           shr  ax, 2
           add  di, ax
           mov  ax, bx
           stosb

           mov  dx, XXCm

           sub  di, di
           add  di, dx
           mov  ax, YYCp
           xchg al, ah
           add  di, ax
           shr  ax, 2
           add  di, ax
           mov  ax, bx
           stosb              { Plot pixel }

           sub  di, di
           add  di, dx
           mov  ax, YYCm
           xchg al, ah
           add  di, ax
           shr  ax, 2
           add  di, ax
           mov  ax, bx
           stosb              { Plot pixel }

           mov  dx, XYCp

           sub  di, di
           add  di, dx
           mov  ax, YXCp
           xchg al, ah
           add  di, ax
           shr  ax, 2
           add  di, ax
           mov  ax, bx
           stosb              { Plot pixel }

           sub  di, di
           add  di, dx
           mov  ax, YXCm
           xchg al, ah
           add  di, ax
           shr  ax, 2
           add  di, ax
           mov  ax, bx
           stosb              { Plot pixel }

           mov  dx, XYCm
           sub  di, di
           add  di, dx
           mov  ax, YXCp
           xchg al, ah
           add  di, ax
           shr  ax, 2
           add  di, ax
           mov  ax, bx
           stosb              { Plot pixel }

           sub  di, di
           add  di, dx
           mov  ax, YXCm
           xchg al, ah
           add  di, ax
           shr  ax, 2
           add  di, ax
           mov  ax, bx
           stosb              { Plot pixel }
        end;

{******}

var wXt, wYt, wD : integer;

begin
     asm
        sub  ax, ax         { X := 0; }
        mov  wXt, ax
        mov  ax, wr         { Y := Radius }
        mov  wYt, ax

        shl  ax, 1          { (2 * Radius) }
        mov  bx, 03H
        sub  bx, ax         { D := 3 - (2 * Radius) }
        mov  wD, bx
     end;

     while (wXt < wYt) do
     begin
          CirclePoint(wXt, wYt, wx, wy, byte(lCol));

          if (wD < 0) then
          asm
             mov  ax, wXt  { 4 * X }
             shl  ax, 2
             add  ax, 6  { (4*X)+6 }
             mov  bx, wD
             add  bx, ax
             mov  wD, bx
          end {D := D + (4 * X) + 6}
          else
          asm
             mov  ax, wXt    { (X-Y) }
             mov  bx, wYt
             sub  ax, bx
             shl  ax, 2      { 4*(X-Y) }
             add  ax, 10
             mov  bx, wD
             add  bx, ax
             mov  wD, bx     { D := D + 4*(X-Y) + 10; }
             dec  wYt
          end;

          Inc(wXt);
     end;

     if (wXt = wYt) then CirclePoint(wXt, wYt, wx, wy, byte(lCol));
end;

{******}

procedure VGA_FilledCircle(wx, wy, wr : word; lCol : longint);

{******}

     procedure CirclePoint(X, Y, Xc, Yc : integer; lCol : longint);

     var XXCp, XXCm, XYCp, XYCm, YXCp, YXCm, YYCp, YYCm : integer;

     begin
        asm
           mov  cx, X    { store in registers for faster access }
           mov  dx, Y    { instead of accessing memory each time }

           mov  bx, XC   { store XC in bx - cut down on mem access }

           mov  ax, bx   { XXCp := XC+X; }
           add  ax, cx
           mov  XXCp, ax

           mov  ax, bx   { XXCm := XC-X; }
           sub  ax, cx
           mov  XXCm, ax

           mov  ax, bx   { XYCp := XC+Y; }
           add  ax, dx
           mov  XYCp, ax

           mov  ax, bx   { XYCm := XC-Y; }
           sub  ax, dx
           mov  XYCm, ax

           mov  bx, YC   { store YC in bx - cut down on mem access }

           mov  ax, bx   { YXCp := YC+X; }
           add  ax, cx
           mov  YXCp, ax

           mov  ax, bx   { YXCm := YC-X; }
           sub  ax, cx
           mov  YXCm, ax

           mov  ax, bx   { YYCp := YC+Y; }
           add  ax, dx
           mov  YYCp, ax

           mov  ax, bx   { YYCm := YC-Y; }
           sub  ax, dx
           mov  YYCm, ax
        end;

        GFX_HLine(XXCp, XXCm, YYCp, lCol);
        GFX_HLine(XXCp, XXCm, YYCm, lCol);
        GFX_HLine(XYCp, XYCm, YXCp, lCol);
        GFX_HLine(XYCp, XYCm, YXCm, lCol);
     end;

{******}

var wXt, wYt, wD : integer;

begin
     asm
        sub  ax, ax         { X := 0; }
        mov  wXt, ax
        mov  ax, wr         { Y := Radius }
        mov  wYt, ax

        shl  ax, 1          { (2 * Radius) }
        mov  bx, 03H
        sub  bx, ax         { D := 3 - (2 * Radius) }
        mov  wD, bx
     end;

     while (wXt < wYt) do
     begin
          CirclePoint(wXt, wYt, wx, wy, lCol);

          if (wD < 0) then
          asm
             mov  ax, wXt  { 4 * X }
             shl  ax, 2
             add  ax, 6  { (4*X)+6 }
             mov  bx, wD
             add  bx, ax
             mov  wD, bx
          end {D := D + (4 * X) + 6}
          else
          asm
             mov  ax, wXt    { (X-Y) }
             mov  bx, wYt
             sub  ax, bx
             shl  ax, 2      { 4*(X-Y) }
             add  ax, 10
             mov  bx, wD
             add  bx, ax
             mov  wD, bx     { D := D + 4*(X-Y) + 10; }
             dec  wYt
          end;

          Inc(wXt);
     end;

     if (wXt = wYt) then CirclePoint(wXt, wYt, wx, wy, lCol);
end;

{******}

procedure VGA_Triangle(wx1, wy1, wx2, wy2, wx3, wy3 : word; lCol : longint);

begin
     GFX_Line(wx1, wy1, wx2, wy2, lCol);
     GFX_Line(wx2, wy2, wx3, wy3, lCol);
     GFX_Line(wx1, wy1, wx3, wy3, lCol);
end;

{******}

procedure VGA_Init;

begin
     with GFX_Screen do
     begin
          with ModeInfo do
          begin
               wMode         := GFX_VGA_320x200x8;
               wChip         := 0;
               wMemSize      := 64;
               bMemModel     := MEM_PACKED8;
               bBitsPerPixel := 8;
               wPixelWidth   := 320;
               wByteWidth    := 320;
               wPixelHeight  := 200;
               wMinX         := 0;
               wMaxX         := 319;
               wMinY         := 0;
               wMaxY         := 199;
               wTotalPages   := 1;
          end;

          wActivePage          := 0;
          wVisualPage          := 0;
          wMaxPage             := 0;

          Func_GetVideoName    := VGA_GetVideoName;

          Proc_SetActivePage   := nil;
          Proc_SetVisualPage   := nil;

          Proc_Cls             := VGA_Cls;
          Proc_PutPixel        := VGA_PutPixel;
          Proc_Put2Pixel       := VGA_Put2Pixel;
          Proc_Put4Pixel       := VGA_Put4Pixel;
          Func_GetPixel        := VGA_GetPixel;
          Proc_HLine           := VGA_HLine;
          Proc_VLine           := VGA_VLine;
          Proc_Line            := VGA_Line;
          Proc_Rectangle       := VGA_Rectangle;
          Proc_FilledRectangle := VGA_FilledRectangle;
          Proc_Circle          := VGA_Circle;
          Proc_FilledCircle    := VGA_FilledCircle;
          Proc_Triangle        := VGA_Triangle;
          Proc_FilledTriangle  := nil;
          Proc_PutBitmap       := nil;                   {NOT YET IMPLEMENTED}
          Proc_PutMaskedBitmap := nil;                   {NOT YET IMPLEMENTED}
          Proc_GetBitmap       := nil;                   {NOT YET IMPLEMENTED}
     end;

     asm
        mov  ax, $0013
        int  VID_INT
     end;
end;

{******}

procedure VGA_Done;

begin
end;

{******}

end.