program TESTSGFX;

(* Information
   

   Program Title : SGFX32 Test program.
   External name : TESTSGFX.EXE
   Version       : 1.0
   Start date    : 29/12/96
   Last update   : 29/12/96
   Author        : Rob Anderton.
   Description   : A test program for use during development of SGFX32.

*)

uses SGFX32, SUTILS, CRT;

var ModeInfo : TModeRec;
    ChipName : string;
    lColours : longint;

begin
     Randomize;
     GFX_Init(GFX_S3_640x480x8);
     ModeInfo:= GFX_Screen.ModeInfo;
     ChipName:= GFX_GetVideoName(ModeInfo);
     if ModeInfo.bBitsPerPixel <> 32 then lColours:= U_Power(2, ModeInfo.bBitsPerPixel)
                                     else lColours:= U_Power(2, 24);
     GFX_Done;

     with ModeInfo do
     begin
          writeln('Graphics information for mode ', U_DecToHex(wMode), 'h');
          writeln;
          writeln('Chip name       : ', ChipName);
          writeln('Video memory    : ', wMemSize, 'Kb');
          writeln('Bits per pixel  : ', bBitsPerPixel);
          writeln('Maximum colours : ', lColours);

          writeln('Dimensions      : ', wPixelWidth, 'x', wPixelHeight);
          writeln('Video pages     : ', wTotalPages);
     end;
     readkey;
end.