uses Dos, Crt, SGFX386;

(* Information
   

   Program Title : SGFX386 benchmark program.
   External name : GFXBENCH.TPU
   Version       : 1.2
   Start date    : 5/7/96
   Last update   : 12/9/96
   Author        : Rob Anderton.
   Description   : A speed tester for SGFX386 v1.11.
*)


{*** Record to hold results ***}

type TGFXResult = record
                        RandomPutPixel  : longint;
                        RandomPut2Pixel : longint;
                        RandomPut4Pixel : longint;
                        RandomGetPixel  : longint;
                        Clrs            : longint;
                        RandomHLine     : longint;
                        RandomVLine     : longint;
                        RandomLine      : longint;
                        RandomPoly      : longint;
                        RandomCircle    : longint;
                        FCircle         : longint;
                        SetActPg        : longint;
                        SetVisPg        : longint;
                        Rect            : longint;
                        FRect           : longint;
                        PutBitmap       : longint;
                        PutMaskedBitmap : longint;
                        GetBitmap       : longint;
                  end;

{******}

type TSpeed = record
                    Num  : longint;
                    Time : longint;
              end;

{******}

var Result : TGFXResult;

{******}

function GetTimeInS : longint;

var h, m, s, ms : word;
    T           : longint;

begin
     GetTime(h, m, s, ms);

     T:= (h * 3600) + (m * 60) + s;
     if ms > 49 then inc(T);
     GetTimeInS:= T;
end;

{******}

procedure TestRandomPutPixel(Num : longint);

var X, Y   : word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);
     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X:= Random(GFXInfo.MaxX);
           Y:= Random(GFXInfo.MaxY);
           C:= Random(255);
           GFX_PutPixel(X, Y, C);
           Inc(N1);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomPutPixel:= 0
                    else Result.RandomPutPixel:= (S1.Num div S1.Time);
end;

{******}

procedure TestRandomPut2Pixel(Num : longint);

var X, Y   : word;
    C1, C2 : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X:= Random(GFXInfo.MaxX);
           Y:= Random(GFXInfo.MaxY);
           C1:= random(255);
           GFX_Put2Pixel(X, Y, C1);
           Inc(N1);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomPut2Pixel:= 0
                    else Result.RandomPut2Pixel:= (S1.Num div S1.Time) * 2;
end;

{******}

procedure TestRandomPut4Pixel(Num : longint);

var X, Y   : word;
    C1, C2,
    C3, C4 : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X:= Random(GFXInfo.MaxX);
           Y:= Random(GFXInfo.MaxY);
           C1:= Random(255);
           GFX_Put4Pixel(X, Y, C1);
           Inc(N1);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomPut4Pixel:= 0
                    else Result.RandomPut4Pixel:= (S1.Num div S1.Time) * 4;
end;

{******}

procedure TestRandomGetPixel(Num : longint);

var X, Y   : word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X:= Random(GFXInfo.MaxX);
           Y:= Random(GFXInfo.MaxY);
           C:= GFX_GetPixel(X, Y);
           Inc(N1);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomGetPixel:= 0
                    else Result.RandomGetPixel:= (S1.Num div S1.Time);
end;

{******}

procedure TestCls(Num : longint);

var C      : byte;
    T1, T2 : longint;
    N1, N2 : longint;
    S1, S2 : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           C:= random(255);
           GFX_Cls(C);
           Inc(N1);
     end;

     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.Clrs:= 0
                    else Result.Clrs:= (S1.Num div S1.Time);
end;

{******}

procedure TestRandomHLine(Num : longint);

var X1, X2,
    Y      : word;
    C      : byte;
    T1, T2 : longint;
    N1, N2 : longint;
    S1, S2 : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X1:= random(GFXInfo.MaxX - 4);
           X2:= random(GFXInfo.MaxX - 4);
           Y:= random(GFXInfo.MaxY);
           C:= random(255);
           GFX_HLine(X1, X2, Y, C);
           Inc(N1);
     end;

     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomHLine:= 0
                    else Result.RandomHLine:= (S1.Num div S1.Time);
end;

{******}

procedure TestRandomVLine(Num : longint);

var X,
    Y1, Y2 : word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X:= random(GFXInfo.MaxX);
           Y1:= random(GFXInfo.MaxY);
           Y2:= random(GFXInfo.MaxY);
           C:= random(255);
           GFX_VLine(X, Y1, Y2, C);
           Inc(N1);
     end;

     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomVLine:= 0
                    else Result.RandomVLine:= (S1.Num div S1.Time);

end;

{******}

procedure TestRandomLine(Num : longint);

var X1, X2,
    Y1, Y2 : word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X1:= random(GFXInfo.MaxX);
           X2:= random(GFXInfo.MaxX);
           Y1:= random(GFXInfo.MaxY);
           Y2:= random(GFXInfo.MaxY);
           C:= random(255);
           GFX_Line(X1, Y1, X2, Y2, C);
           Inc(N1);
     end;

     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomLine:= 0
                    else Result.RandomLine:= (S1.Num div S1.Time);

end;

{******}

procedure TestRandomPoly(Num : longint);

var X1, X2,
    X3, X4,
    Y1, Y2,
    Y3, Y4 : word;
    C      : byte;
    T1, T2 : longint;
    N1, N2 : longint;
    S1, S2 : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X1:= random(GFXInfo.MaxX);
           X2:= random(GFXInfo.MaxX);
           X3:= random(GFXInfo.MaxX);
           X4:= random(GFXInfo.MaxX);
           Y1:= random(GFXInfo.MaxY);
           Y2:= random(GFXInfo.MaxY);
           Y3:= random(GFXInfo.MaxY);
           Y4:= random(GFXInfo.MaxY);
           C:= random(255);
           GFX_DrawPoly(X1, Y1, X2, Y2, X3, Y3, X4, Y4, C);
           Inc(N1);
     end;

     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomPoly:= 0
                    else Result.RandomPoly:= (S1.Num div S1.Time);
end;

{******}

procedure TestRandomCircle(Num : longint);

var X, Y, R: word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X:= Random(GFXInfo.MaxX);
           Y:= Random(GFXInfo.MaxY);
           C:= Random(255);
           GFX_Circle(X, Y, 50, C);
           Inc(N1);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.RandomCircle:= 0
                    else Result.RandomCircle:= (S1.Num div S1.Time);
end;

{******}

procedure TestFilledCircle(Num : longint);

var X, Y, R: word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           X:= Random(GFXInfo.MaxX - 100) + 50;
           Y:= Random(GFXInfo.MaxY - 100) + 50;
           C:= Random(255);
           GFX_FilledCircle(X, Y, 50, C);
           Inc(N1);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.FCircle:= 0
                    else Result.FCircle:= (S1.Num div S1.Time);
end;

{******}

procedure TestSetActPg(Num : longint);

var T1, T2 : longint;
    N1, N2 : longint;
    S1, S2 : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);
     Num:= Num div 2;
     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           GFX_SetActivePage(1);
           Inc(N1);
           GFX_SetActivePage(0);
           Inc(N1);
     end;

     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.SetActPg:= 0
                    else Result.SetActPg:= (S1.Num div S1.Time);

end;

{******}

procedure TestSetVisPg(Num : longint);

var T1, T2 : longint;
    N1, N2 : longint;
    S1, S2 : TSpeed;
    Loop   : longint;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);
     Num:= Num div 2;
     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           GFX_SetVisualPage(1);
           Inc(N1);
           GFX_SetVisualPage(0);
           Inc(N1);
     end;

     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.SetVisPg:= 0
                    else Result.SetVisPg:= (S1.Num div S1.Time);
end;

{******}

procedure TestRect(Num : longint);

var T1, T2 : longint;
    N1, N2 : longint;
    S1, S2 : TSpeed;
    Loop   : longint;
    x, y   : word;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           x:= random(GFXInfo.MaxX - 70);
           y:= random(GFXInfo.MaxY - 50);
           GFX_Rectangle(x, y, random(70), random(50), Random(255));
           Inc(N1);
     end;

     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     GFX_Cls(4);

     N2:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           x:= random(GFXInfo.MaxX - 70);
           y:= random(GFXInfo.MaxY - 50);
           GFX_FilledRectangle(x, y, random(70), random(50), Random(255));
           Inc(N2);
     end;

     T2:= GetTimeInS;

     S2.Time:= T2 - T1;
     S2.Num:= N2;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.Rect:= 0
                    else Result.Rect:= (S1.Num div S1.Time);

     if S2.Time = 0 then Result.FRect:= 0
                    else Result.FRect:= (S2.Num div S2.Time);
end;

{******}

procedure TestPutBitmap(Num : longint);

var X, Y   : word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;
    Pic    : TBitmap;
    Pal    : TPalette;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     GFX_LoadBitmap('GFXBENCH.SPF', Pic, Pal);
     GFX_SetAllPal(Pal);
     GFX_Cls(25);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           GFX_PutBitmap(0, 0, Pic);
           Inc(N1);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     if Assigned(Pic.Data) then FreeMem(Pic.Data, Pic.Size);
     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.PutBitmap:= 0
                    else Result.PutBitmap:= (S1.Num div S1.Time);
end;

{******}

procedure TestPutMaskedBitmap(Num : longint);

var X, Y   : word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;
    Pic    : TBitmap;
    Pal    : TPalette;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     GFX_LoadBitmap('GFXBENCH.SPF', Pic, Pal);
     GFX_SetAllPal(Pal);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           GFX_PutMaskedBitmap(0, 0, Pic);
           Inc(N1);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     if Assigned(Pic.Data) then FreeMem(Pic.Data, Pic.Size);
     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.PutMaskedBitmap:= 0
                    else Result.PutMaskedBitmap:= (S1.Num div S1.Time);
end;

{******}

procedure TestGetBitmap(Num : longint);

var X, Y   : word;
    C      : byte;
    T1, T2 : longint;
    N1     : longint;
    S1     : TSpeed;
    Loop   : longint;
    Pic    : TBitmap;
    Pal    : TPalette;

begin
     GFX_SetActivePage(0);
     GFX_SetVisualPage(0);

     N1:= 0;
     T1:= GetTimeInS;

     for Loop:= 1 to Num do
     begin
           GFX_GetBitmap(0, 0, 319, 199, Pic);
           Inc(N1);
           if Assigned(Pic.Data) then FreeMem(Pic.Data, Pic.Size);
     end;
     T2:= GetTimeInS;

     S1.Num:= N1;
     S1.Time:= T2 - T1;

     Sound(220);
     Delay(10);
     NoSound;

     if S1.Time = 0 then Result.GetBitmap:= 0
                    else Result.GetBitmap:= (S1.Num div S1.Time);
end;

{******}


begin
     GFX_Init(GFXMODE_S3_320x200);

     Randomize;

     TestRandomPutPixel(900000);
     TestRandomPut2Pixel(900000);
     TestRandomPut4Pixel(900000);
     TestRandomGetPixel(900000);

     TestCls(2000);

     TestRandomHLine(500000);
     TestRandomVLine(500000);
     TestRandomLine(500000);

     TestRandomPoly(2000);

     TestRect(100000);

     TestRandomCircle(20000);
     TestFilledCircle(200);

     TestSetActPg(800000);
     if GFXInfo.Chip = GFXMODE_VGA_320x200 then TestSetVisPg(200)
                                           else TestSetVisPg(300000);

     TestPutBitmap(1000);
     TestPutMaskedBitmap(1000);
     TestGetBitmap(100);
     GFX_Done;
     writeln('System results.');
     writeln;

     writeln('Pixel functions.');
     writeln;
     with Result do
     begin
          writeln('Single pixel, random write : ', RandomPutPixel, ' pixels/sec.');
          writeln('Two pixels, random write   : ', RandomPut2Pixel, ' pixels/sec.');
          writeln('Four pixels, random write  : ', RandomPut4Pixel, ' pixels/sec.');
          writeln('Single pixel, random read  : ', RandomGetPixel, ' pixels/sec.');
          writeln;
          writeln('Clear screen command.');
          writeln;
          writeln('Clear screen               : ', Clrs, ' cls/sec.');
     end;
     writeln;
     writeln('Press any key to continue...');
     readkey;
     ClrScr;

     writeln('System results.');
     writeln;

     writeln('Line functions.');
     writeln;
     with Result do
     begin
          writeln('Horizontal line, random write : ', RandomHLine, ' lines/sec.');
          writeln('Vertical line, random write   : ', RandomVLine, ' lines/sec.');
          writeln('Random line, random write     : ', RandomLine, ' lines/sec.');
          writeln;
          writeln('Polygon routines.');
          writeln;
          writeln('Random polygon            : ', RandomPoly, ' polygons/sec.');
          writeln('Random rectangle          : ', Rect, ' rectangles/sec.');
          writeln('Random filled rectangle   : ', FRect, ' rectangles/sec.');
          writeln;
          writeln('Circle routines.');
          writeln;
          writeln('Random circle (radius 50) : ', RandomCircle, ' circles/sec.');
          writeln('Filled circle (radius 50) : ', FCircle, ' circles/sec.');
          writeln;
     end;
     writeln;
     writeln('Press any key to continue...');
     readkey;
     ClrScr;
     writeln('System results.');
     writeln;

     writeln('VRAM page functions.');
     writeln;
     with Result do
     begin
          writeln('SetActivePage : ', SetActPg, ' ops/sec.');
          writeln('SetVisualPage : ', SetVisPg, ' ops/sec.');
     end;

     writeln;
     writeln('Bitmap functions.');
     writeln;
     with Result do
     begin
          writeln('PutBitmap       : ', PutBitmap, ' ops/sec.');
          writeln('PutMaskedBitmap : ', PutMaskedBitmap, ' ops/sec.');
          writeln('GetBitmap       : ', GetBitmap, ' ops/sec (approx).');
     end;

     writeln;
     writeln('Press any key to continue...');
     readkey;

end.