program Plasma3;

(* Information
   

   Program Title : Plasma demo.
   External name : PLASMA2.EXE
   Version       : 2.0
   Start date    : 24/9/96
   Last update   : 24/9/96
   Author        : Rob Anderton.
   Description   : A plasma demo for the S-Library.
                   Based on Denthor's VGA Trainer number 15.
*)

uses SGFX386, Crt;

{******}

var Pal1, Pal2     : TRGBPalette;
    COSTable       : array[0..255] of byte;
    M1, M2, M3, M4 : byte;

{******}

procedure Plasma_Init;

var Loop : word;

begin
     GFX_Init(GFXMODE_X_320x400);

     asm
        mov     dx, CRTC_ADDR
        mov     al, 9
        out     dx, al
        inc     dx
        in      al, dx
        and     al, $E0
        add     al, 7
        out     dx, al
     end;

     FillChar(Pal2, SizeOf(Pal2), 0);
     GFX_SetAllPal(TPalette(Pal2));

     for Loop:= 0 to 128 do
     begin
          Pal1[Loop].r:= 63 - Loop div 4;
          Pal1[Loop].b:= 0;
          Pal1[Loop].g:= Loop div 4;
     end;

     for Loop:= 129 to 255 do
     begin
          Pal1[Loop].r:= Loop div 4;;
          Pal1[Loop].b:= 0;
          Pal1[Loop].g:= 63 - Loop div 4;
     end;

{     for Loop:= 0 to 128 do
     begin
          Pal1[Loop].r:= 63 - Loop div 4;
          Pal1[Loop].b:= 0;
          Pal1[Loop].g:= 0;
     end;

     for Loop:= 129 to 255 do
     begin
          Pal1[Loop].r:= Loop div 4;;
          Pal1[Loop].b:= 0;
          Pal1[Loop].g:= 0;
     end;}


{     GFX_LoadPal('plasma.rgb', TPalette(Pal1));}

     for Loop:= 0 to 255 do
         COSTable[Loop]:= Round(COS(GFX_RAD(Loop / 360 * 255 * 2)) * 31) + 32;

     randomize;
end;

{******}

procedure Plasma_Draw;

var Loop1, Loop2       : word;
    tm1, tm2, tm3, tm4 : byte;
    Col                : byte;
    Where              : word;

begin
     tm3:= M3;
     tm4:= M4;
     Where:= 0;

     asm
        mov    ax, VGA_SEG
        mov    es, ax
     end;

     for Loop1:= 1 to 50 do
     begin
          tm1:= M1;
          tm2:= M2;
          for Loop2:= 1 to 80 do
          begin
               case random(3) of
                    0 :
               Col:= CosTable[tm1] +{ CosTable[tm2] + }
                     {CosTable[tm3]   +} CosTable[tm4] +
                     CosTable[Loop1] + CosTable[Loop2];

               1:
                           Col:= {CosTable[tm1] +} CosTable[tm2] +
                     CosTable[tm3]   +{ CosTable[tm4] +}
                     CosTable[Loop1] + CosTable[Loop2];

               2:               Col:= {CosTable[tm1] + CosTable[tm2] + }
                     CosTable[tm3]   + CosTable[tm4] +
                     CosTable[Loop1] + CosTable[Loop2];



               3:               Col:= CosTable[tm1] +  CosTable[tm2] +
                     {CosTable[tm3]   + CosTable[tm4] +}
                     CosTable[Loop1] + CosTable[Loop2];


               end;


               asm
                  mov    di, [Where]
                  mov    al, [Col]
                  mov    es:[di], al
               end;

               Inc(Where);
               Inc(tm1, 4);
               Inc(tm2, 3);
          end;
          Inc(tm3, 4);
          Inc(tm4, 5);
     end;
end;

{******}

procedure Plasma_Move;

begin
     Dec(M1, 4);
     Inc(M3, 4);
     Inc(M1, Random(1));
     Dec(M2, Random(2));
     Inc(M3, Random(1));
     Dec(M4, Random(2));
end;

{******}

procedure Plasma_FadeUpOne(Stage : word);

var Loop : word;
    Temp : TRGBRec;

begin
     Move(Pal1[0], Temp, 3);
     Move(Pal1[1], Pal1[0], 765);
     Move(Temp, Pal1[255], 3);

     for Loop:= 0 to 255 do
     begin
          Pal2[Loop].r:= word(Pal1[Loop].r * Stage div 64);
          Pal2[Loop].g:= word(Pal1[Loop].g * Stage div 64);
          Pal2[Loop].b:= word(Pal1[Loop].b * Stage div 64);
     end;
     GFX_SetAllPal(TPalette(Pal2));
end;

{******}

procedure Plasma_ShiftPalette;

var Loop1 : word;
    Temp  : TRGBRec;

begin
     Move(Pal2[0], Temp, 3);
     Move(Pal2[1], Pal2[0], 765);
     Move(Temp, Pal2[255], 3);
     GFX_SetAllPal(TPalette(Pal2));
end;

{******}

procedure Plasma_Play;

var Loop1 : word;

begin
     for Loop1:= 1 to 64 do
     begin
          Plasma_FadeUpOne(Loop1);
          Plasma_Draw;
          Plasma_Move;
     end;

     while keypressed do readkey;

     repeat
           Plasma_ShiftPalette;
           Plasma_Draw;
           Plasma_Move;
     until Keypressed;

     Move(Pal2, Pal1, 768);

     for Loop1:= 1 to 64 do
     begin
          Plasma_FadeUpOne(64 - Loop1);
          Plasma_Draw;
          Plasma_Move;
     end;

     while Keypressed do readkey;
end;

{******}

begin
     Plasma_Init;
     Plasma_Play;
     GFX_Done;
end.