unit Stars;

(* Information
   

   Program Title : Space Invaders.
   External name : STARS.TPU
   Version       : 1.0
   Start date    : 05/05/96
   Author        : Rob Anderton
   Description   : Horizontal stars unit.

*)

interface

procedure WaitForRetrace;
procedure DrawStarsLR;
procedure DrawStarsRL;

{******}

implementation

uses XLib, Dos, Crt;

{$I STARS.DAT}

const {*** Star velocities ***}
      VLevel1      = 1;
      VLevel2      = 2;
      VLevel3      = 3;
      VLevel4      = 4;

      {*** Array indices ***}
      XPOS         = 1;
      YPOS         = 2;
      OLDPOS       = 3;
      OVERWRITE    = 4;

      {*** Star colours ***}
      StarV1       = 22;
      StarV2       = 24;
      StarV3       = 27;
      StarV4       = 30;

      {*** Colour used to 'erase' stars ***}
      {*** should be same as background ***}
      BackCol : byte = 0;


{*** Waits for a vertical retrace ***}

procedure WaitForRetrace;

begin
     while ((PortW[$03DA] and 8) = 0) do
     begin
     end;
end;

{*** Draws stars which move from left to right ***}

procedure DrawStarsLR;

var CurrentStar  : integer;
    TX, TY, TOld : word;

begin
     {*** VLevel 1 ***}
     for CurrentStar:= 0 to 39 do
     begin
          TX:= Star[CurrentStar, XPOS];
          TY:= Star[CurrentStar, YPOS];
          TOld:= Star[CurrentStar, OLDPOS];

          XPutPix(TOld, TY, VisiblePageOffs, BackCol);
          Inc(TX, VLevel1);
          if (TX > ScrnPhysicalPixelWidth) then Dec(TX, ScrnPhysicalPixelWidth);
          XPutPix(TX, TY, VisiblePageOffs, StarV1);
          TOld:= TX;

          Star[CurrentStar, XPOS]:= TX;
          Star[CurrentStar, OLDPOS]:= TOld;
     end;

     {*** VLevel 2 ***}
     for CurrentStar:= 40 to 69 do
     begin
          TX:= Star[CurrentStar, XPOS];
          TY:= Star[CurrentStar, YPOS];
          TOld:= Star[CurrentStar, OLDPOS];

          XPutPix(TOld, TY, VisiblePageOffs, BackCol);
          Inc(TX, VLevel2);
          if (TX > ScrnPhysicalPixelWidth) then Dec(TX, ScrnPhysicalPixelWidth);
          XPutPix(TX, TY, VisiblePageOffs, StarV2);
          TOld:= TX;

          Star[CurrentStar, XPOS]:= TX;
          Star[CurrentStar, OLDPOS]:= TOld;
     end;

     {*** VLevel 3 ***}
     for CurrentStar:= 70 to 89 do
     begin
          TX:= Star[CurrentStar, XPOS];
          TY:= Star[CurrentStar, YPOS];
          TOld:= Star[CurrentStar, OLDPOS];

          XPutPix(TOld, TY, VisiblePageOffs, BackCol);
          Inc(TX, VLevel3);
          if (TX > ScrnPhysicalPixelWidth) then Dec(TX, ScrnPhysicalPixelWidth);
          XPutPix(TX, TY, VisiblePageOffs, StarV3);
          TOld:= TX;

          Star[CurrentStar, XPOS]:= TX;
          Star[CurrentStar, OLDPOS]:= TOld;
     end;

     {*** VLevel 4 ***}
     for CurrentStar:= 90 to 101 do
     begin
          TX:= Star[CurrentStar, XPOS];
          TY:= Star[CurrentStar, YPOS];
          TOld:= Star[CurrentStar, OLDPOS];

          XPutPix(TOld, TY, VisiblePageOffs, BackCol);
          Inc(TX, VLevel4);
          if (TX > ScrnPhysicalPixelWidth) then Dec(TX, ScrnPhysicalPixelWidth);
          XPutPix(TX, TY, VisiblePageOffs, StarV4);
          TOld:= TX;

          Star[CurrentStar, XPOS]:= TX;
          Star[CurrentStar, OLDPOS]:= TOld;
     end;

end;

{*** Draws stars which move from right to left ***}

procedure DrawStarsRL;

var CurrentStar       : integer;
    TX, TY, TOld, TOW : word;

begin
     {*** VLevel 1 ***}
     for CurrentStar:= 0 to 39 do
     begin
          TX:= Star[CurrentStar, XPOS];
          TY:= Star[CurrentStar, YPOS];
          TOld:= Star[CurrentStar, OLDPOS];
          TOW:= Star[CurrentStar, OVERWRITE];

          if TOW = 1 then XPutPix(TOld, TY, VisiblePageOffs, BackCol);
          Dec(TX, VLevel1);
          if (TX < VLevel1) then TX:= ScrnPhysicalPixelWidth;
          if XGetPix(TX, TY, VisiblePageOffs) = BackCol then
          begin
               XPutPix(TX, TY, VisiblePageOffs, StarV1);
               TOW:= 1;
          end
          else TOW:= 0;
          TOld:= TX;

          Star[CurrentStar, XPOS]:= TX;
          Star[CurrentStar, OLDPOS]:= TOld;
          Star[CurrentStar, OVERWRITE]:= TOW;
     end;

     {*** VLevel 2 ***}
     for CurrentStar:= 40 to 69 do
     begin
          TX:= Star[CurrentStar, XPOS];
          TY:= Star[CurrentStar, YPOS];
          TOld:= Star[CurrentStar, OLDPOS];
          TOW:= Star[CurrentStar, OVERWRITE];

          if TOW = 1 then XPutPix(TOld, TY, VisiblePageOffs, BackCol);
          Dec(TX, VLevel2);
          if (TX < VLevel2) then TX:= ScrnPhysicalPixelWidth;
          if XGetPix(TX, TY, VisiblePageOffs) = BackCol then
          begin
               XPutPix(TX, TY, VisiblePageOffs, StarV2);
               TOW:= 1;
          end
          else TOW:= 0;
          TOld:= TX;

          Star[CurrentStar, XPOS]:= TX;
          Star[CurrentStar, OLDPOS]:= TOld;
          Star[CurrentStar, OVERWRITE]:= TOW;
     end;

     {*** VLevel 3 ***}
     for CurrentStar:= 70 to 89 do
     begin
          TX:= Star[CurrentStar, XPOS];
          TY:= Star[CurrentStar, YPOS];
          TOld:= Star[CurrentStar, OLDPOS];
          TOW:= Star[CurrentStar, OVERWRITE];

          if TOW = 1 then XPutPix(TOld, TY, VisiblePageOffs, BackCol);
          Dec(TX, VLevel3);
          if (TX < VLevel3) then TX:= ScrnPhysicalPixelWidth;
          if XGetPix(TX, TY, VisiblePageOffs) = BackCol then
          begin
               XPutPix(TX, TY, VisiblePageOffs, StarV3);
               TOW:= 1;
          end
          else TOW:= 0;
          TOld:= TX;

          Star[CurrentStar, XPOS]:= TX;
          Star[CurrentStar, OLDPOS]:= TOld;
          Star[CurrentStar, OVERWRITE]:= TOW;
     end;

     {*** VLevel 4 ***}
     for CurrentStar:= 90 to 101 do
     begin
          TX:= Star[CurrentStar, XPOS];
          TY:= Star[CurrentStar, YPOS];
          TOld:= Star[CurrentStar, OLDPOS];
          TOW:= Star[CurrentStar, OVERWRITE];

          if TOW = 1 then XPutPix(TOld, TY, VisiblePageOffs, BackCol);
          Dec(TX, VLevel4);
          if (TX < VLevel4) then TX:= ScrnPhysicalPixelWidth;
          if XGetPix(TX, TY, VisiblePageOffs) = BackCol then
          begin
               XPutPix(TX, TY, VisiblePageOffs, StarV4);
               TOW:= 1;
          end
          else TOW:= 0;
          TOld:= TX;

          Star[CurrentStar, XPOS]:= TX;
          Star[CurrentStar, OLDPOS]:= TOld;
          Star[CurrentStar, OVERWRITE]:= TOW;
     end;
end;

{******}

end.