program TestAdlib;

{ADLIB unit tester.}

uses Crt, SAdlib;

{******}

procedure BassNote(Freq, Del : word);

begin
     FM_KeyOn(4, Freq, 2);
     FM_KeyOn(5, Freq, 2);
     Delay(20);
     FM_KeyOn(6, C4, 4);
     Delay(Del);
     FM_KeyOff(6);
     FM_KeyOff(5);
     FM_KeyOff(4);
end;

{******}

procedure HarmonyNote(Freq, Del : word);

begin
    FM_KeyOn(0, Freq, 4);
    Delay(10);
    FM_KeyOn(1, Freq, 4);
    Delay(10);
    FM_KeyOn(2, Freq, 4);
    Delay(10);
    FM_KeyOn(3, Freq, 4);
    Delay(Del);
    FM_KeyOff(3);
    Delay(10);
    FM_KeyOff(2);
    Delay(10);
    FM_KeyOff(1);
    Delay(10);
    FM_KeyOff(0);
    Delay(10);
end;

{******}

var Inst1, Inst2, Inst3 : FMInstrument;
    i                   : word;

begin
     ClrScr;
     writeln;
     write('Checking for Adlib sound card...');
     if (not FM_Detect) then
     begin
    	  write('not found.');
          writeln;
          Halt(1);
     end;
     write('found.');
     writeln;
     writeln('Now playing tune...');

     FM_Init;

     LoadSBI('DOCGUTFZ.SBI', Inst1);
     LoadSBI('BASYKA01.SBI', Inst2);
     LoadSBI('BDRUM1.SBI', Inst3);

     FM_SetVoice(0, Inst1);
     FM_SetVoice(1, Inst1);
     FM_SetVoice(2, Inst1);
     FM_SetVoice(3, Inst1);

     FM_SetVoice(4, Inst2);
     FM_SetVoice(5, Inst2);

     FM_SetVoice(6, Inst3);

     for i:= 1 to 5 do
     begin
          BassNote(F4, 250);
          BassNote(F4, 250);
          BassNote(A4b, 250);
          BassNote(G4, 250);
     end;

     HarmonyNote(D4, 500);
     HarmonyNote(F4, 350);
     HarmonyNote(E4b, 600);

     FM_Init;
     writeln('Done...');
end.

