program TestSWIN;

{$X+}

(* Information
   

   Program Title : SWIN95 - Windows95 related functions.
   External name : TESTSWIN.EXE
   Version       : 1.0
   Start date    : 20/2/97
   Last update   : 22/2/97
   Author        : Rob Anderton.
   Description   : Windows95 support routines tester.

*)

uses DOS, CRT, STRINGS, OBJECTS, SWIN95;

{******}

function LeadingZero(w : Word) : String;

var s : String;

begin
     Str(w:0,s);
     if Length(s) = 1 then s := '0' + s;
     LeadingZero := s;
end;

{******}

var sRootDir   : string;
    VolumeInfo : TVolumeInfo95;
    sShortName : string;
    sLongName  : string;
    pLongName  : PChar;
    wAttr      : word;
    lTime      : longint;
    dt         : DateTime;
    wHandle    : word;

begin
     writeln;
     write('Input volume root directory (e.g. C:\): ');
     readln(sRootDir);
     Win95_GetVolumeInfo(sRootDir, VolumeInfo);

     writeln('DOS version ', Lo(DosVersion), '.', Hi(DosVersion));
     writeln('File system for drive ', sRootDir, ' is ', VolumeInfo.sFileSystem);
     writeln('Maximum file name length is ', VolumeInfo.wFileNameLength);
     writeln('Maximum directory name length is ', VolumeInfo.wDirectoryLength);

     if ((VolumeInfo.wFlags and 1) = 1) then writeln('Searches are case sensitive');
     if (((VolumeInfo.wFlags shr 1) and 1) = 1) then writeln('Preserves case in directory entries');
     if (((VolumeInfo.wFlags shr 2) and 1) = 1) then writeln('Uses UniCode characters');
     if (((VolumeInfo.wFlags shr 14) and 1) = 1) then writeln('Supports DOS long file name functions');
     if (((VolumeInfo.wFlags shr 15) and 1) = 1) then writeln('Volume is compressed');

     readkey;
     ClrScr;

     write('Enter a short file name : ');
     readln(sShortName);
     writeln(Win95_GetLongFileName(sShortName, true));

     readkey;
     ClrScr;

     write('Enter a long file name : ');

     readln(sLongName);
     pLongName:= '';
     StrPCopy(pLongName, sLongName);
     writeln(Win95_GetShortFileName(pLongName, true));

     readkey;

     ClrScr;
     pLongName:= '';
     pLongName:= 'TESTSWIN95.TXT';
     wHandle:= Win95_CreateFile(pLongName, 2);
     Win95_GetFileAttr(pLongName, wAttr);
     writeln(pLongName, ' attributes are ', wAttr);
     Win95_GetFileWriteTime(pLongName, lTime);
     UnpackTime(lTime,dt);
     with dt do
     begin
          writeln(pLongName, ' last write time is ',
                  LeadingZero(hour),':',
                  LeadingZero(min),':',
                  LeadingZero(sec));

          writeln(pLongName, ' last write date is ',
                  LeadingZero(Day),'/',
                  LeadingZero(Month),'/',
                  LeadingZero(Year));
     end;

     Win95_GetFileAccessTime(pLongName, lTime);
     UnpackTime(lTime,dt);
     with dt do
     begin
          writeln(pLongName, ' last access time is ',
                  LeadingZero(hour),':',
                  LeadingZero(min),':',
                  LeadingZero(sec));

          writeln(pLongName, ' last access date is ',
                  LeadingZero(Day),'/',
                  LeadingZero(Month),'/',
                  LeadingZero(Year));
     end;

     Win95_GetFileCreationTime(pLongName, lTime);
     UnpackTime(lTime,dt);
     with dt do
     begin
          writeln(pLongName, ' creation time is ',
                  LeadingZero(hour),':',
                  LeadingZero(min),':',
                  LeadingZero(sec));

          writeln(pLongName, ' creation date is ',
                  LeadingZero(Day),'/',
                  LeadingZero(Month),'/',
                  LeadingZero(Year));
     end;

     readkey;
     Win95_DeleteFile('TESTSWIN95.TXT');

end.