program PCX2SPF;

(* Information
   

   Program Title : PCX to SPF converter.
   External name : PCX2SPF.EXE
   Version       : 1.0
   Start date    : 13/10/96
   Last update   : 13/10/96
   Author        : Rob Anderton.
   Description   : A program to convert 256 colour ZSoft PCX 5.0 files to
                   S-Library Picture Files (SPFs).

*)

uses SPCX, SSPF, SUTILS, OBJECTS, CRT;

{******}

var PCXName : string;
    SPFName : string;

{******}

procedure PCXError(var S : TStream); far;

begin
     writeln;
     writeln('File error code : ', S.Status);
     writeln;
     halt(1);
end;

{******}

procedure Init;

begin
     writeln;
     writeln('-----------------------------------------');
     writeln('PCX2SPF version 1.0 (c)1996 Rob Anderton.');
     writeln('-----------------------------------------');
     writeln;

     if (ParamCount < 2) then
     begin
          writeln('Usage : PCX2SPF <PCXFILE>[.PCX] <SPFFILE>[.SPF]');
          writeln;
          halt(1);
     end;

     PCXName:= ParamStr(1);
     SPFName:= ParamStr(2);

     if Pos('.', PCXName) = 0 then PCXName:= PCXName + '.PCX';
     if Pos('.', SPFName) = 0 then SPFName:= SPFName + '.SPF';

     if not U_FileExists(PCXName) then
     begin
          writeln(PCXName, ' does not exist!');
          halt(1);
     end;

     if U_FileExists(SPFName) then
     begin
          writeln(SPFName, ' already exists!');
          halt(1);
     end;

     writeln;
     write('Converting ', PCXName, ' to ', SPFName, '....');
end;

{******}

begin
     Init;
     PCX_SPF(PCXName, SPFName, true);
     writeln('done.');
end.