program raw2wav;

uses Crt, Objects;

{*** Wave chunks ***}

const ckRIFF : array[1..4] of char = 'RIFF';
      ckWAVE : array[1..4] of char = 'WAVE';
      ckFMT  : array[1..4] of char = 'fmt ';
      ckDATA : array[1..4] of char = 'data';

{******}

type ChunkHeader = record
                         ChunkID   : array[1..4] of char;
                         ChunkSize : longint;
                   end;

     WaveFormat  = record
                         wFormat         : word;
                         nChannels       : word;
                         nSamplesPerSec  : longint;
                         nAvgBytesPerSec : longint;
                         nBlockAlign     : word;
                         wBitsPerSample  : word;
                     end;

{*** Error codes ***}

const ERR_WAVE_NOSBCARD    = $10;
      ERR_WAVE_INVALIDRIFF = $11;
      ERR_WAVE_NOTPCM      = $12;
      ERR_WAVE_NOT8BIT     = $13;

{*** Raw Header ***}

type RAWHeaderRec = record
                          Stereo : boolean;
                          Bits   : integer;
                          Freq   : word;
                    end;

{******}

procedure WaveStreamError(var S : TStream); far;

begin
     writeln('Stream error : ', S.Status);
     writeln;
     halt(1);
end;

{******}

var OldError    : pointer;
    WaveName    : string;
    WaveFile    : TBufStream;
    RAWName     : string;
    RAWFile     : TBufStream;
    ChunkHdr    : ChunkHeader;
    WaveFmt     : WaveFormat;

    Loop        : longint;
    Data        : byte;
    Del         : longint;

begin
     OldError:= StreamError;
     StreamError:= @WaveStreamError;

     ClrScr;
     writeln('Input RAW file name : ');
     readln(RAWName);
     writeln('Output WAV file name : ');
     readln(WaveName);
     writeln('RAW frequency : ');
     readln(WaveFmt.nSamplesPerSec);
     ClrScr;

     WaveFile.Init(WaveName, stCreate, 4096);
     RAWFile.Init(RAWName, stOpenRead, 4096);

     ChunkHdr.ChunkID:= 'RIFF';
     ChunkHdr.ChunkSize:= RAWFile.GetSize + sizeof(WaveFormat);
     WaveFile.Write(ChunkHdr, sizeof(ChunkHdr));
     WaveFile.Write(ckWAVE, 4);

     ChunkHdr.ChunkID:= 'fmt ';
     ChunkHdr.ChunkSize:= sizeof(WaveFormat);
     WaveFile.Write(ChunkHdr, sizeof(ChunkHdr));

     with Wavefmt do
     begin
          wFormat:= 1;
          nChannels:= 1;
          nAvgBytesPerSec:= nSamplesPerSec;
          nBlockAlign:= 1;
          wBitsPerSample:= 8;
     end;
     WaveFile.Write(Wavefmt, sizeof(WaveFormat));

     ChunkHdr.ChunkID:= 'data';
     ChunkHdr.ChunkSize:= RAWFile.GetSize;
     WaveFile.Write(ChunkHdr, sizeof(ChunkHdr));

     write('Converting ', RAWName, ' to ', WaveName, '...');

     for Loop:= 1 to ChunkHdr.ChunkSize do
     begin
          RAWFile.Read(Data, 1);
          WaveFile.Write(Data, 1);
     end;

     WaveFile.Done;
     RAWFile.Done;
     writeln('done.');
     StreamError:= OldError;
end.

