program SWF2WAV;

(* Information
   

   Program Title : S-Library wave file (SWF) to Windows wave (WAV) converter.
   External name : SWF2WAV.EXE
   Version       : 1.0
   Start date    : 23/10/96
   Last update   : 23/10/96
   Author        : Rob Anderton.
   Description   : Utility to convert from SWF to WAV.

*)


uses CRT, OBJECTS, SBDSP, SUTILS, SERROR;

{*** Wave chunks ***}

const ckRIFF : array[1..4] of char = 'RIFF';
      ckWAVE : array[1..4] of char = 'WAVE';
      ckFMT  : array[1..4] of char = 'fmt ';
      ckDATA : array[1..4] of char = 'data';

{******}

type ChunkHeader = record
                         ChunkID   : array[1..4] of char;
                         ChunkSize : longint;
                   end;

     WaveFormat  = record
                         wFormat         : word;
                         nChannels       : word;
                         nSamplesPerSec  : longint;
                         nAvgBytesPerSec : longint;
                         nBlockAlign     : word;
                         wBitsPerSample  : word;
                     end;

{******}

procedure WaveStreamError(var S : TStream); far;

begin
     writeln;
     writeln('File I/O error : ', S.Status);
     writeln;
     halt(1);
end;

{******}

var OldError    : pointer;
    WaveName    : string;
    WaveFile    : TBufStream;
    SWFName     : string;
    SWFFile     : TBufStream;
    SWFHdr      : TSoundHdr;
    ChunkHdr    : ChunkHeader;
    WaveFmt     : WaveFormat;

    Loop        : longint;
    Data        : byte;
    Del         : longint;
    Ch          : char;

begin
     OldError:= StreamError;
     StreamError:= @WaveStreamError;

     writeln;
     writeln('------------------------');
     writeln(' SWF2WAV wave converter ');
     writeln('       Version 1.0      ');
     writeln('  (c)1996 Rob Anderton  ');
     writeln('------------------------');
     writeln;

     if ParamCount < 2 then
     begin
          writeln('Usage : SWF2WAV <SWF_FILE> <WAVE_FILE> ');
          writeln;
          writeln('Please note that file extensions must be given.');
          writeln;
          halt(1);
     end;

     SWFName:= U_StrUpper(ParamStr(1));
     WaveName:= U_StrUpper(ParamStr(2));

     if not U_FileExists(SWFName) then
     begin
          writeln('Wave file not found!');
          writeln;
          halt(1);
     end;

     if U_FileExists(WaveName) then
     begin
          writeln('WAV file already exists, overwrite (Y/N)?');
          Ch:= Upcase(readkey);
          if Ch = 'N' then halt(0);
     end;

     WaveFile.Init(WaveName, stCreate, 4096);
     SWFFile.Init(SWFName, stOpenRead, 4096);

     ChunkHdr.ChunkID:= 'RIFF';
     ChunkHdr.ChunkSize:= SWFFile.GetSize + sizeof(WaveFormat);
     WaveFile.Write(ChunkHdr, sizeof(ChunkHdr));
     WaveFile.Write(ckWAVE, 4);

     ChunkHdr.ChunkID:= 'fmt ';
     ChunkHdr.ChunkSize:= sizeof(WaveFormat);
     WaveFile.Write(ChunkHdr, sizeof(ChunkHdr));
     SWFFile.Read(SWFHdr, sizeof(SWFHdr));

     with Wavefmt do
     begin
          wFormat:= 1;
          if SWFHdr.Stereo then nChannels:= 2 else nChannels:= 1;
          wBitsPerSample:= SWFHdr.Bits;
          nSamplesPerSec:= SWFHdr.Freq;
          nAvgBytesPerSec:= nSamplesPerSec * nChannels * (wBitsPerSample div 8);
          nBlockAlign:= nChannels * (wBitsPerSample div 8);
     end;
     WaveFile.Write(Wavefmt, sizeof(WaveFormat));

     ChunkHdr.ChunkID:= 'data';
     ChunkHdr.ChunkSize:= SWFHdr.Size;
     WaveFile.Write(ChunkHdr, sizeof(ChunkHdr));

     writeln('Converting ', SWFName, ' to ', WaveName, ':');

     for Loop:= 1 to ChunkHdr.ChunkSize do
     begin
          SWFFile.Read(Data, 1);
          if ((Data >= 0) and (Data <= 127)) then Inc(Data, 127)
                                             else Dec(Data, 127);
          WaveFile.Write(Data, 1);
          if (ChunkHdr.ChunkSize mod Loop) = 0 then write('');
     end;

     WaveFile.Done;
     SWFFile.Done;
     writeln;
     writeln('All done!');
     StreamError:= OldError;
end.

