program wav2raw;

uses Crt, Objects;

{*** Wave chunks ***}

const ckRIFF : array[1..4] of char = 'RIFF';
      ckWAVE : array[1..4] of char = 'WAVE';
      ckFMT  : array[1..4] of char = 'fmt ';
      ckDATA : array[1..4] of char = 'data';

{******}

type ChunkHeader = record
                         ChunkID   : array[1..4] of char;
                         ChunkSize : longint;
                   end;

     WaveFormat  = record
                         wFormat         : word;
                         nChannels       : word;
                         nSamplesPerSec  : longint;
                         nAvgBytesPerSec : longint;
                         nBlockAlign     : word;
                         wBitsPerSample  : word;
                     end;

{*** Error codes ***}

const ERR_WAVE_NOSBCARD    = $10;
      ERR_WAVE_INVALIDRIFF = $11;
      ERR_WAVE_NOTPCM      = $12;
      ERR_WAVE_NOT8BIT     = $13;

{*** Raw Header ***}

type RAWHeaderRec = record
                          Stereo : boolean;
                          Bits   : integer;
                          Freq   : word;
                    end;

{******}

procedure WaveStreamError(var S : TStream); far;

begin
     writeln('Stream error : ', S.Status);
     writeln;
     halt(1);
end;

{******}

var OldError    : pointer;
    WaveName    : string;
    WaveFile    : TBufStream;
    RAWName     : string;
    RAWFile     : TBufStream;
    ChunkHdr    : ChunkHeader;
    WaveFmt     : pointer;
    WaveFmtSize : word;
    RAWHeader   : RAWHeaderRec;

    Loop        : longint;
    Data        : byte;
    Del         : longint;

begin
     OldError:= StreamError;
     StreamError:= @WaveStreamError;

     ClrScr;
     writeln('Input WAVE file name : ');
     readln(WaveName);
     writeln('Output RAW file name : ');
     readln(RAWName);
     ClrScr;

     WaveFile.Init(WaveName, stOpenRead, 4096);
     RAWFile.Init(RAWName, stCreate, 4096);

     WaveFile.Read(ChunkHdr, sizeof(ChunkHeader));

     if ChunkHdr.ChunkID <> ckRIFF then
     begin
          writeln('Invalid wave file.');
          RAWFile.Done;
          WaveFile.Done;
          halt(1);
     end;

     WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     while (ChunkHdr.ChunkID <> ckWAVE) do
     begin
          WaveFile.Seek(WaveFile.GetPos + ChunkHdr.ChunkSize);
          WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     end;

     WaveFile.Seek(WaveFile.GetPos - 4);
     WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     while (ChunkHdr.ChunkID <> ckFMT) do
     begin
          WaveFile.Seek(WaveFile.GetPos + ChunkHdr.ChunkSize);
          WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     end;

     WavefmtSize:= ChunkHdr.ChunkSize;
     GetMem(Wavefmt, WavefmtSize);
     if Wavefmt = nil then exit;

     WaveFile.Read(Wavefmt^, WavefmtSize);

     with WaveFormat(Wavefmt^) do
     begin
          if wFormat <> 1 then
          begin
               writeln('Invalid wave file.');
               RAWFile.Done;
               WaveFile.Done;
               FreeMem(Wavefmt, WavefmtSize);
               halt(1);
          end;

          if wBitsPerSample > 8 then
          begin
               writeln('Invalid wave file.');
               RAWFile.Done;
               WaveFile.Done;
               FreeMem(Wavefmt, WavefmtSize);
               halt(1);
          end
          else RAWHeader.Bits:= wBitsPerSample;

          RAWHeader.Stereo:= (nChannels = 2);
          RAWHeader.Freq:= nSamplesPerSec;
     end;

     WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     while (ChunkHdr.ChunkID <> ckDATA) do
     begin
          WaveFile.Seek(WaveFile.GetPos + ChunkHdr.ChunkSize);
          WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     end;

     write('Converting ', WaveName, ' to ', RAWName, '...');

{     RAWFile.Write(RAWHeader, sizeof(RAWHeader));}

     for Loop:= 1 to ChunkHdr.ChunkSize do
     begin
          WaveFile.Read(Data, 1);
          RAWFile.Write(Data, 1);
     end;

     WaveFile.Done;
     RAWFile.Done;
     writeln('done.');
     StreamError:= OldError;
     FreeMem(Wavefmt, WavefmtSize);
end.

