program WAV2SWF;

(* Information
   

   Program Title : Windows wave (WAV) to S-Library wave file (SWF) converter.
   External name : WAV2SWF.EXE
   Version       : 1.0
   Start date    : 23/10/96
   Last update   : 23/10/96
   Author        : Rob Anderton.
   Description   : Utility to convert from WAV to SWF.

*)


uses CRT, OBJECTS, SBDSP, SUTILS, SERROR;

{*** Wave chunks ***}

const ckRIFF : array[1..4] of char = 'RIFF';
      ckWAVE : array[1..4] of char = 'WAVE';
      ckFMT  : array[1..4] of char = 'fmt ';
      ckDATA : array[1..4] of char = 'data';

{******}

type ChunkHeader = record
                         ChunkID   : array[1..4] of char;
                         ChunkSize : longint;
                   end;

     WaveFormat  = record
                         wFormat         : word;
                         nChannels       : word;
                         nSamplesPerSec  : longint;
                         nAvgBytesPerSec : longint;
                         nBlockAlign     : word;
                         wBitsPerSample  : word;
                     end;

{******}

procedure WaveStreamError(var S : TStream); far;

begin
     writeln;
     writeln('File I/O error : ', S.Status);
     writeln;
     halt(1);
end;

{******}

var OldError    : pointer;
    WaveName    : string;
    WaveFile    : TBufStream;
    SWFName     : string;
    SWFFile     : TBufStream;
    SWFHdr      : TSoundHdr;
    ChunkHdr    : ChunkHeader;
    WaveFmt     : pointer;
    WaveFmtSize : word;

    Loop        : longint;
    Data        : byte;
    Del         : longint;
    Ch          : char;

begin
     OldError:= StreamError;
     StreamError:= @WaveStreamError;

     writeln;
     writeln('------------------------');
     writeln(' WAV2SWF wave converter ');
     writeln('       Version 1.0      ');
     writeln('  (c)1996 Rob Anderton  ');
     writeln('------------------------');
     writeln;

     if ParamCount < 2 then
     begin
          writeln('Usage : WAV2SWF <WAVE_FILE> <SWF_FILE> ');
          writeln;
          writeln('Please note that file extensions must be given.');
          writeln;
          halt(1);
     end;

     WaveName:= U_StrUpper(ParamStr(1));
     SWFName:= U_StrUpper(ParamStr(2));

     if not U_FileExists(WaveName) then
     begin
          writeln('Wave file not found!');
          writeln;
          halt(1);
     end;

     if U_FileExists(SWFName) then
     begin
          writeln('SWF file already exists, overwrite (Y/N)?');
          Ch:= Upcase(readkey);
          if Ch = 'N' then halt(0);
     end;

     WaveFile.Init(WaveName, stOpenRead, 4096);
     SWFFile.Init(SWFName, stCreate, 4096);

     WaveFile.Read(ChunkHdr, sizeof(ChunkHeader));

     if ChunkHdr.ChunkID <> ckRIFF then
     begin
          writeln('Invalid wave file.');
          SWFFile.Done;
          WaveFile.Done;
          halt(1);
     end;

     WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     while (ChunkHdr.ChunkID <> ckWAVE) do
     begin
          WaveFile.Seek(WaveFile.GetPos + ChunkHdr.ChunkSize);
          WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     end;

     WaveFile.Seek(WaveFile.GetPos - 4);
     WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     while (ChunkHdr.ChunkID <> ckFMT) do
     begin
          WaveFile.Seek(WaveFile.GetPos + ChunkHdr.ChunkSize);
          WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     end;

     WavefmtSize:= ChunkHdr.ChunkSize;
     GetMem(Wavefmt, WavefmtSize);
     if Wavefmt = nil then exit;

     WaveFile.Read(Wavefmt^, WavefmtSize);

     with WaveFormat(Wavefmt^) do
     begin
          if wFormat <> 1 then
          begin
               writeln('Invalid wave file.');
               SWFFile.Done;
               WaveFile.Done;
               FreeMem(Wavefmt, WavefmtSize);
               halt(1);
          end;

          if wBitsPerSample > 8 then
          begin
               writeln('Invalid wave file.');
               SWFFile.Done;
               WaveFile.Done;
               FreeMem(Wavefmt, WavefmtSize);
               halt(1);
          end
          else SWFHdr.Bits:= wBitsPerSample;

          SWFHdr.Stereo:= (nChannels = 2);
          SWFHdr.Freq:= nSamplesPerSec;
     end;

     WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     while (ChunkHdr.ChunkID <> ckDATA) do
     begin
          WaveFile.Seek(WaveFile.GetPos + ChunkHdr.ChunkSize);
          WaveFile.Read(ChunkHdr, sizeof(ChunkHdr));
     end;

     writeln('Converting ', WaveName, ' to ', SWFName, ':');

     SWFHdr.SoundID:= 'SWF';
     SWFHdr.Size:= ChunkHdr.ChunkSize;
     SWFFile.Write(SWFHdr, sizeof(SWFHdr));

     for Loop:= 1 to ChunkHdr.ChunkSize do
     begin
          WaveFile.Read(Data, 1);
          if ((Data >= 0) and (Data <= 127)) then Inc(Data, 127)
                                             else Dec(Data, 127);
          SWFFile.Write(Data, 1);
          if (ChunkHdr.ChunkSize mod Loop) = 0 then write('');
     end;

     WaveFile.Done;
     SWFFile.Done;
     writeln;
     writeln('All done!');
     StreamError:= OldError;
     FreeMem(Wavefmt, WavefmtSize);
end.

