unit SEMS;

(* Information
   

   Program Title : LIM-EMS 4.0 library.
   External name : SEMS.PAS
   Version       : 1.0.
   Start date    : 12/8/96.
   Last update   : 1/10/96.
   Author        : Rob Anderton.
   Description   : EMS code for S-Library.

*)

interface

{*** EMS multiple map structure ***}

type MapInfoRec = record
                        LogicalPage  : word;
                        PhysicalPage : word;
                  end;

{******}

function  EMS_Detect : boolean;
procedure EMS_Init;

function  EMS_GetStatus : byte;
function  EMS_GetPageFrame : word;
function  EMS_GetTotalPages : word;
function  EMS_GetFreePages : word;

function  EMS_GetMem(Pages : word) : word;
procedure EMS_MapPages(Handle, LogicalPage : word; PhysicalPage : byte);
procedure EMS_FreeMem(Handle : word);

function  EMS_GetVersion : word;

procedure EMS_SaveMapping(Handle : word);
procedure EMS_RestoreMapping(Handle : word);

function  EMS_GetHandles : word;
function  EMS_GetHandlePages(Handle : word) : word;
procedure EMS_MapMultiplePages(var MapInfo : array of MapInfoRec; Handle : word);

function  EMS_Resize(Handle, Pages : word) : word;
procedure EMS_MoveTo(var Source; Handle, Page : word; BlockLength : longint);
procedure EMS_MoveFrom(Handle, Page : word; var Dest; BlockLength : longint);

{******}

implementation

uses DOS, SERROR;

{******}

const EMS_INT = $67;

{******}

type EMSMoveRec = record
                        Length    : longint;
                        SrcType   : byte;
                        SrcHandle : word;
                        SrcOfs    : word;
                        SrcPage   : word;
                        DstType   : byte;
                        DstHandle : word;
                        DstOfs    : word;
                        DstPage   : word;
                  end;

{******}

var EMMPresent : boolean;
    EMSError   : byte;

{******}

function EMS_Detect : boolean;

type TEMMStr = array[1..8] of char;
     PEMMStr = ^TEMMStr;

const EMM_NAME : TEMMStr = 'EMMXXXX0';

var Regs : registers;

begin
     Regs.ax:= $35 shl 8 + EMS_INT;
     MSDOS(Regs);

     EMS_Detect:= (PEMMStr(Ptr(Regs.es, 10))^ = EMM_NAME);
end;

{******}

procedure EMS_Init;

begin
     if not EMS_Detect then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          EMMPresent:= false;
          exit;
     end;

     SErrorCode:= 0;
     EMSError:= 0;
     EMMPresent:= true;
end;

{******}

function EMS_GetPointer(Page : word) : pointer;

var PageFrame : word;

begin
     PageFrame:= EMS_GetPageFrame;
     EMS_GetPointer:= Ptr(PageFrame, Page shl 14);
end;

{******}

function EMS_GetStatus : byte;

var Temp : byte;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $40
        int  EMS_INT
        mov  [Temp], ah
     end;

     EMS_GetStatus:= Temp;
end;

{******}

function EMS_GetPageFrame : word;

var Temp : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $41
        int  EMS_INT
        cmp  ah, 0
        je   @NO_ERROR
        mov  [EMSError], ah
        mov  [Temp], 0
        jmp  @EXIT

     @NO_ERROR:

        mov  [Temp], bx

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
     EMS_GetPageFrame:= Temp;
end;

{******}

function EMS_GetTotalPages : word;

var Temp : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $42
        int  EMS_INT
        cmp  ah, 0
        je   @NO_ERROR
        mov  [EMSError], ah
        mov  [Temp], 0
        jmp  @EXIT

     @NO_ERROR:

        mov  [Temp], dx

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
     EMS_GetTotalPages:= Temp;
end;

{******}

function EMS_GetFreePages : word;

var Temp : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $42
        int  EMS_INT
        cmp  ah, 0
        je   @NO_ERROR
        mov  [EMSError], ah
        mov  [Temp], 0
        jmp  @EXIT

     @NO_ERROR:

        mov  [Temp], bx

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
     EMS_GetFreePages:= Temp;
end;

{******}

function EMS_GetMem(Pages : word) : word;

var Temp : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $43
        mov  bx, [Pages]
        int  EMS_INT
        cmp  ah, 0
        je   @NO_ERROR
        mov  [EMSError], ah
        jmp  @EXIT

     @NO_ERROR:

        mov  [Temp], dx

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
     EMS_GetMem:= Temp;
end;

{******}

procedure EMS_MapPages(Handle, LogicalPage : word; PhysicalPage : byte);

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $44
        mov  al, [PhysicalPage]
        mov  bx, [LogicalPage]
        mov  dx, [Handle]
        int  EMS_INT
        cmp  ah, 0
        je   @EXIT
        mov  [EMSError], ah

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
end;

{******}

procedure EMS_FreeMem(Handle : word);

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $45
        mov  dx, [Handle]
        int  EMS_INT
        cmp  ah, 0
        je   @EXIT
        mov  [EMSError], ah

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
end;

{******}

function EMS_GetVersion : word;

var Ver  : byte;
    Temp : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $46
        int  EMS_INT
        cmp  ah, 0
        je   @NO_ERROR
        mov  [EMSError], ah
        mov  [Ver], 0
        jmp  @EXIT

     @NO_ERROR:

        mov  [Ver], al

     @EXIT:

     end;

     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
     Temp:= Ver and $F0;
     EMS_GetVersion:= (Temp shl 4) + (Ver and $0F);
end;

{******}

procedure EMS_SaveMapping(Handle : word);

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $47
        mov  dx, [Handle]
        int  EMS_INT
        cmp  ah, 0
        je   @EXIT
        mov  [EMSError], ah

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
end;

{******}

procedure EMS_RestoreMapping(Handle : word);

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $48
        mov  dx, [Handle]
        int  EMS_INT
        cmp  ah, 0
        je   @EXIT
        mov  [EMSError], ah

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
end;

{******}

function EMS_GetHandles : word;

var Temp : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $4B
        int  EMS_INT
        cmp  ah, 0
        je   @NO_ERROR
        mov  [EMSError], ah
        mov  [Temp], 0
        jmp  @EXIT

     @NO_ERROR:

        mov  [Temp], bx

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
     EMS_GetHandles:= Temp;
end;

{******}

function EMS_GetHandlePages(Handle : word) : word;

var Temp : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $4C
        mov  dx, [Handle]
        int  EMS_INT
        cmp  ah, 0
        je   @NO_ERROR
        mov  [EMSError], ah
        mov  [Temp], 0
        jmp  @EXIT

     @NO_ERROR:

        mov  [Temp], bx

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
     EMS_GetHandlePages:= Temp;
end;

{******}

procedure EMS_MapMultiplePages(var MapInfo : array of MapInfoRec; Handle : word);

var NumPages : word;
    ArrSeg   : word;
    ArrOfs   : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     NumPages:= High(MapInfo) + 1;
     ArrSeg:= Seg(MapInfo);
     ArrOfs:= Ofs(MapInfo);

     asm
        push ds
        mov  ax, $5000
        mov  dx, [Handle]
        mov  cx, [NumPages]
        mov  bx, [ArrSeg]
        mov  ds, bx
        mov  si, [ArrOfs]
        int  EMS_INT
        cmp  ah, 0
        je   @EXIT
        mov  [EMSError], ah

     @EXIT:
        pop  ds
     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
end;

{******}

function EMS_Resize(Handle, Pages : word) : word;

var Temp : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     asm
        mov  ah, $51
        mov  dx, [Handle]
        mov  bx, [Pages]
        int  EMS_INT
        cmp  ah, 0
        je   @NO_ERROR
        mov  [EMSError], ah
        mov  [Temp], 0
        jmp  @EXIT

     @NO_ERROR:

        mov  [Temp], bx

     @EXIT:

     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
     EMS_Resize:= Temp;
end;

{******}

procedure EMS_MoveTo(var Source; Handle, Page : word; BlockLength : longint);

var MoveInfo : EMSMoveRec;
    MoveSeg  : word;
    MoveOfs  : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     with MoveInfo do
     begin
          Length:= BlockLength;
          SrcType:= 0;
          SrcHandle:= 0;
          SrcOfs:= Ofs(Source);
          SrcPage:= Seg(Source);
          DstType:= 1;
          DstHandle:= Handle;
          DstOfs:= 0;
          DstPage:= Page;
     end;

     MoveSeg:= Seg(MoveInfo);
     MoveOfs:= Ofs(MoveInfo);

     asm
        push ds
        mov  ax, $5700
        mov  bx, [MoveSeg]
        mov  ds, bx
        mov  si, [MoveOfs]
        int  EMS_INT
        cmp  ah, 0
        je   @EXIT
        mov  [EMSError], ah

     @EXIT:

        pop  ds
     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
end;

{******}

procedure EMS_MoveFrom(Handle, Page : word; var Dest; BlockLength : longint);

var MoveInfo : EMSMoveRec;
    MoveSeg  : word;
    MoveOfs  : word;

begin
     if not EMMPresent then
     begin
          SErrorCode:= (word(ERR_EMS) shl 8) + ERR_EMS_NOEMMPRESENT;
          exit;
     end;
     SErrorCode:= 0;
     EMSError:= 0;

     with MoveInfo do
     begin
          Length:= BlockLength;
          SrcType:= 1;
          SrcHandle:= Handle;
          SrcOfs:= 0;
          SrcPage:= Page;
          DstType:= 0;
          DstHandle:= 0;
          DstOfs:= Ofs(Dest);
          DstPage:= Seg(Dest);
     end;

     MoveSeg:= Seg(MoveInfo);
     MoveOfs:= Ofs(MoveInfo);

     asm
        push ds
        mov  ax, $5700
        mov  bx, [MoveSeg]
        mov  ds, bx
        mov  si, [MoveOfs]
        int  EMS_INT
        cmp  ah, 0
        je   @EXIT
        mov  [EMSError], ah

     @EXIT:

        pop  ds
     end;
     if EMSError <> 0 then SErrorCode:= (word(ERR_EMS) shl 8) + EMSError;
end;

{******}

end.