unit SError;

(* Information
   

   Program Title : S-Library error handling unit.
   External name : SERROR.TPU
   Version       : 1.0
   Start date    : 5/9/96
   Last update   : 1/10/96
   Author        : Rob Anderton.
   Description   : Centralised error handling for the S-Library.

                   Error code : High byte = unit code  (e.g. 09h = SJOY)
                                Low  byte = error code (e.g. 90h = Invalid
                                                                   joystick)
*)

interface

{******}

const SErrorCode : word = 0;

{*** Error codes ***}

{*** XMS error codes ***}

const ERR_XMS                   = $20;  {MEMORY 20h - 2Fh}
      ERR_XMS_NOXMMPRESENT      = $7F;
      ERR_XMS_NOTIMPLEMENTED    = $80;
      ERR_XMS_DETECTEDVDISK     = $81;
      ERR_XMS_A20ERROR          = $82;
      ERR_XMS_GENERALERROR      = $8E;
      ERR_XMS_UNRECOVERABLE     = $8F;

      ERR_XMS_HMANOTEXIST       = $90;
      ERR_XMS_HMAINUSE          = $91;
      ERR_XMS_HMAREQTOOSMALL    = $92;
      ERR_XMS_HMANOTALLOCATED   = $93;
      ERR_XMS_A20STILLENABLED   = $94;

      ERR_XMS_ALLXMSALLOCATED   = $A0;
      ERR_XMS_ALLHANDLESUSED    = $A1;
      ERR_XMS_INVALIDHANDLE     = $A2;
      ERR_XMS_INVALIDSRCHANDLE  = $A3;
      ERR_XMS_INVALIDSRCOFFSET  = $A4;
      ERR_XMS_INVALIDDSTHANDLE  = $A5;
      ERR_XMS_INVALIDDSTOFFSET  = $A6;
      ERR_XMS_INVALIDLENGTH     = $A7;
      ERR_XMS_INVALIDOVERLAP    = $A8;
      ERR_XMS_PARITYERROR       = $A9;
      ERR_XMS_BLOCKNOTLOCKED    = $AA;
      ERR_XMS_BLOCKISLOCKED     = $AB;
      ERR_XMS_LOCKCOUNTOVERFLOW = $AC;
      ERR_XMS_LOCKFAILED        = $AD;

      ERR_XMS_SMALLUMBAVAILABLE = $B0;
      ERR_XMS_NOUMBSAVAILABLE   = $B1;
      ERR_XMS_INVALIDUMBSEGMENT = $B2;

{*** EMS error codes ***}

const ERR_EMS                        = $21;
      ERR_EMS_NOEMMPRESENT           = $7F;
      ERR_EMS_EMMSOFTWARE            = $80;
      ERR_EMS_EMMHARDWARE            = $81;

      ERR_EMS_INVALIDHANDLE          = $83;
      ERR_EMS_INVALIDFUNCTION        = $84;
      ERR_EMS_ALLHANDLESUSED         = $85;
      ERR_EMS_MAPPINGERROR           = $86;

      ERR_EMS_NOPHYSICALPAGES        = $87;
      ERR_EMS_NOFREEPAGES            = $88;
      ERR_EMS_NULLPAGEERROR          = $89;
      ERR_EMS_INVALIDLOGICALPAGE     = $8A;
      ERR_EMS_INVALIDPHYSICALPAGE    = $8B;

      ERR_EMS_MAPFULL                = $8C;
      ERR_EMS_MAPPINGSAVED           = $8D;
      ERR_EMS_MAPPINGNOTSAVED        = $8E;

      ERR_EMS_INVALIDSUBFUNCTION     = $8F;

      ERR_EMS_INVALIDATTRIBUTE       = $90;
      ERR_EMS_NONONVOLATILESUPPORT   = $91;
      ERR_EMS_SOURCEOVERWRITTEN      = $92;
      ERR_EMS_LENGTHEXCEEDED         = $93;
      ERR_EMS_CONVENTIONALOVERLAP    = $94;
      ERR_EMS_INVALIDPAGEOFFSET      = $95;
      ERR_EMS_EXCEEDEDONEMEGLIMIT    = $96;
      ERR_EMS_INVALIDSRCANDDEST      = $97;
      ERR_EMS_UNDEFINEDSRCANDDEST    = $98;

      ERR_EMS_ALTMAPSETNOTSUPPORTED  = $9A;
      ERR_EMS_ALTMAPSETALLOCATED     = $9B;
      ERR_EMS_ALTMAPSETNOTZERO       = $9C;
      ERR_EMS_ALTMAPSETCURRENT       = $9D;

      ERR_EMS_DMANOTSUPPORTED        = $9E;
      ERR_EMS_DMACHANNELNOTSUPPORTED = $9F;

      ERR_EMS_NONAMEMATCHEDHANDLE    = $A0;
      ERR_EMS_HANDLENAMEEXISTS       = $A1;
      ERR_EMS_MEMORYWRAP             = $A2;
      ERR_EMS_DATASTRUCTUREERROR     = $A3;
      ERR_EMS_OSACCESSDENIED         = $A4;

{*** DMA error codes ***}

const ERR_DMA                = $22;
      ERR_DMA_INVALIDCHANNEL = $80;

{*** Adlib error codes ***}

const ERR_ADL             = $40;        {SOUND DEVICES = 40h - 4Fh}
      ERR_ADL_NOADLIB     = $B0;
      ERR_ADL_INVALIDSBI  = $B1;

{*** Sound blaster error codes ***}

const ERR_SB              = $41;
      ERR_SB_NOBLASTERENV = $C0;
      ERR_SB_RESETERROR   = $C1;
      ERR_SB_VERSIONERROR = $C2;
      ERR_SB_FREQUENCY    = $C3;
      ERR_SB_DACFREQUENCY = $C4;
      ERR_SB_ADCFREQUENCY = $C5;
      ERR_SB_SPEAKER      = $C6;
      ERR_SB_TRANSSIZE    = $C7;
      ERR_SB_INVALIDSIZE  = $C8;
      ERR_SB_DAC8         = $C9;
      ERR_SB_ADC8         = $CA;
      ERR_SB_PLAYERROR    = $CB;
      ERR_SB_RECORDERROR  = $CC;
      ERR_SB_TIMEOUT      = $CD;
      ERR_SB_NOINIT       = $CE;
      ERR_SB_OLDDSP       = $CF;

{*** WAVE audio error codes ***}

const ERR_WAVE              = $42;
      ERR_WAVE_NOSBCARD     = $10;
      ERR_WAVE_INVALIDRIFF  = $11;
      ERR_WAVE_INVALIDWAVE  = $12;
      ERR_WAVE_NOFORMATINFO = $13;
      ERR_WAVE_NOTPCM       = $14;
      ERR_WAVE_NOWAVEDATA   = $15;
      ERR_WAVE_NODMABUFFER  = $16;
      ERR_WAVE_NOT8BIT      = $17;


{*** SVOICE error codes ***}

const ERR_VOICE                 = $43;
      ERR_VOICE_NOSBCARD        = $10;
      ERR_VOICE_NOXMS           = $11;
      ERR_VOICE_INVALIDRESOURCE = $12;
      ERR_VOICE_FILEIOERROR     = $13;
      ERR_VOICE_KEYNOTFOUND     = $14;

{*** SRES sound related error codes ***}

const ERR_RES                   = $44;
      ERR_RES_KEYNOTFOUND       = $10;
      ERR_RES_TYPEERROR         = $11;

{*** Joystick error codes ***}

const ERR_JOY                 = $50;    {INPUT DEVICES = 50h - 5Fh}
      ERR_JOY_INVALIDJOYSTICK = $90;
      ERR_JOY_NOJOYSTICKS     = $91;

{*** CDROM error codes ***}

const ERR_CDROM                 = $60;  {STORAGE DEVICES = 60h - 6Fh}
      ERR_CDROM_INVALIDFUNCTION = $01;
      ERR_CDROM_ACCESSDENIED    = $05;
      ERR_CDROM_INVALIDHANDLE   = $06;
      ERR_CDROM_INVALIDDATA     = $0D;

      ERR_CDROM_GENERALMSCDEX   = $FD;
      ERR_CDROM_NOTINITIALISED  = $FE;
      ERR_CDROM_OLDMSCDEX       = $FF;

{*** SGFX Error codes ***}

const ERR_GFX                   = $70;  {GRAPHICS OUTPUT = 70h - 7Fh}
      ERR_GFX_386REQUIRED       = $A0;
      ERR_GFX_INVALIDMODE       = $A1;
      ERR_GFX_INVALIDPAGE       = $A2;
      ERR_GFX_INVALIDXVAL       = $A3;
      ERR_GFX_INVALIDYVAL       = $A4;
      ERR_GFX_INVALIDHVAL       = $A5;
      ERR_GFX_INVALIDWVAL       = $A6;
      ERR_GFX_NOSINTABLE        = $A7;
      ERR_GFX_NOCOSTABLE        = $A8;
      ERR_GFX_NOVRAMOFFSET      = $A9;

      ERR_GFX_BMPFILENOTFOUND   = $B0;
      ERR_GFX_BMPINVALIDSIZE    = $B1;
      ERR_GFX_BMPMEMERROR       = $B2;
      ERR_GFX_BMPFILEERROR      = $B3;
      ERR_GFX_BMPXCNVERROR      = $B4;
      ERR_GFX_BMPNODATA         = $B5;
      ERR_GFX_BMPFILEEXISTS     = $B6;

      ERR_VGA                   = $71;  {VGA specific = 71h}
      ERR_VGA_INITERROR         = $10;

{******}

implementation

uses CRT;

{******}

var OldExit : pointer;

{******}

procedure ERR_Exit; far;

begin
     ExitProc:= OldExit;

     if (ExitCode <> 0) or (SErrorCode <> 0) then
     begin
          Sound(220);
          Delay(100);
          NoSound;
     end;
end;

{******}

begin
     OldExit:= ExitProc;
     ExitProc:= @ERR_Exit;
end.