unit SGFX_S3;

(* Information
   

   Program Title : SGFX386 S3 support.
   External name : SGFX_S3.TPU
   Version       : 1.1
   Start date    : 2/7/96
   Last update   : 11/11/96
   Author        : Rob Anderton.
   Description   : 320x200x256 multipage VGA mode, using S3 hardware.

*)

interface

{*** S3 CHIPS ***}

const S3_911        = 1000;
      S3_924        = 1001;
      S3_801AB      = 1002;
      S3_805AB      = 1003;
      S3_801C       = 1004;
      S3_805C       = 1005;
      S3_801D       = 1006;
      S3_805D       = 1007;
      S3_801I       = 1008;
      S3_805I       = 1009;
      S3_801P       = 1010;
      S3_805P       = 1011;
      S3_928        = 1012;
      S3_928C       = 1013;
      S3_928D       = 1014;
      S3_928E       = 1015;
      S3_928PCI     = 1016;
      S3_864        = 1017;
      S3_864P       = 1018;
      S3_964        = 1019;
      S3_964P       = 1020;
      S3_732        = 1021;
      S3_764        = 1022;
      S3_765        = 1023;
      S3_866        = 1024;
      S3_868        = 1025;
      S3_968        = 1026;
      S3_325        = 1027;
      S3_Unknown    = 1028;

      S3ChipName : array[1000..1028] of string =
                 (  'S3 911',   'S3 911A / 924',     'S3 801A / 801B',
            'S3 805A / 805B',         'S3 801C',            'S3 805C',
                   'S3 801D',         'S3 805D',            'S3 801I',
                   'S3 805I',         'S3 801P',            'S3 805P',
                    'S3 928',         'S3 928C',            'S3 928D',
                   'S3 928E',       'S3 928PCI',             'S3 864',
                   'S3 864P',          'S3 964',            'S3 964P',
           'S3 732 (Trio32)', 'S3 764 (Trio64)', 'S3 765 (Trio64 V+)',
                    'S3 866',  'S3 868 (video)',     'S3 968 (video)',
            'S3 325 (ViRGE)',      'Unknown S3');

{******}

function  S3_Detect3x2(var ChipID, VidMemSize : word) : boolean;
procedure S3_Init3x2;

procedure S3_SetWriteBank(Bank : byte);

procedure S3_SetActivePage3x2(Page : word);
procedure S3_SetVisualPage3x2(Page : word);

procedure S3_SetVisualStart(SX, SY : word);

{******}

implementation

uses SGFX386;

{******}

function S3_Detect3x2(var ChipID, VidMemSize : word) : boolean;

var CID     : byte;
    CID2    : byte;
    CID3    : byte;
    VMS     : byte;

begin
     asm
        xor  ax, ax
        mov  bx, CRTC_ADDR
        mov  dx, bx
        mov  al, $38
        out  dx, al
        inc  dx
        mov  al, $48
        out  dx, al
        mov  dx, bx
        mov  al, $30
        out  dx, al
        inc  dx
        in   al, dx
        mov  [CID], al

        mov  dx, bx
        mov  al, $36
        out  dx, al
        inc  dx
        in   al, dx
        and  al, $E0
        shr  al, 5
        mov  [VMS], al
     end;


     case CID of

          $81 : ChipID:= S3_911;
          $82 : ChipID:= S3_924;
          $90 : ChipID:= S3_928;
          $91 : ChipID:= S3_928C;
          $94 : ChipID:= S3_928D;
          $95 : ChipID:= S3_928E;

          $A0 : begin
                     asm
                        mov  dx, CRTC_ADDR
                        mov  al, $36
                        out  dx, al
                        inc  dx
                        in   al, dx
                        and  al, 3
                        mov  [CID2], al
                     end;
                     if CID2 = 0 then ChipID:= S3_805AB
                                 else ChipID:= S3_801AB;
                end;

          $A2 : begin
                     asm
                        mov  dx, CRTC_ADDR
                        mov  al, $36
                        out  dx, al
                        inc  dx
                        in   al, dx
                        and  al, 3
                        mov  [CID2], al
                     end;
                     if CID2 = 0 then ChipID:= S3_805C
                                 else ChipID:= S3_801C;
                end;

          $A5 : begin
                     asm
                        mov  dx, CRTC_ADDR
                        mov  al, $36
                        out  dx, al
                        inc  dx
                        in   al, dx
                        and  al, 3
                        mov  [CID2], al
                     end;
                     if CID2 = 0 then ChipID:= S3_805D
                                 else ChipID:= S3_801D;
                end;

          $A6 : begin
                     asm
                        mov  dx, CRTC_ADDR
                        mov  al, $36
                        out  dx, al
                        inc  dx
                        in   al, dx
                        and  al, 3
                        mov  [CID2], al
                     end;
                     if CID2 = 0 then ChipID:= S3_805P
                                 else ChipID:= S3_801P;
                end;

          $A8 : begin
                     asm
                        mov  dx, CRTC_ADDR
                        mov  al, $36
                        out  dx, al
                        inc  dx
                        in   al, dx
                        and  al, 3
                        mov  [CID2], al
                     end;
                     if CID2 = 0 then ChipID:= S3_805I
                                 else ChipID:= S3_801I;
                end;


          $B0 : ChipID:= S3_928PCI;
          $C0 : ChipID:= S3_864;
          $C1 : ChipID:= S3_864P;
          $D0 : ChipID:= S3_964;
          $D1 : ChipID:= S3_964P;

     $E0..$E1 : begin
                     asm
                        mov  dx, CRTC_ADDR
                        mov  al, $2E
                        out  dx, al
                        inc  dx
                        in   al, dx
                        mov  [CID2], al
                     end;

                     case CID2 of
                          $10 : ChipID:= S3_732;
                          $11 : begin
                                     asm
                                        mov  dx, CRTC_ADDR
                                        mov  al, $2F
                                        out  dx, al
                                        inc  dx
                                        in   al, dx
                                        and  al, $F0
                                        shr  al, 7
                                        mov  [CID3], al
                                     end;
                                     if CID3 = 1 then ChipID:= S3_765
                                                 else ChipID:= S3_764;
                                end;
                          $31 : ChipID:= S3_325;
                          $80 : ChipID:= S3_866;
                          $90 : ChipID:= S3_868;
                          $B0 : ChipID:= S3_968;
                     end;
                end;

                else ChipID:= S3_Unknown;
     end;

     if (ChipID <> S3_911) and (ChipID <> S3_924) then
     case VMS of
          0 : VidMemSize:= 4096;
          2 : VidMemSize:= 3072;
          3 : VidMemSize:= 8192;
          4 : VidMemSize:= 2048;
          5 : VidMemSize:= 6144;
          6 : VidMemSize:= 1024;
          7 : VidMemSize:= 512;
     end
     else
     begin
          VMS:= VMS and 1;
          if VMS = 0 then VidMemSize:= 1024
                     else VidMemSize:= 512;
     end;

     asm
        mov  dx, CRTC_ADDR
        mov  al, $38
        out  dx, al
        inc  dx
        mov  al, 0
        out  dx, al
     end;

     S3_Detect3x2:= true;
end;

{******}

procedure S3_Init3x2;

begin
     asm
        mov  ax, $13
        int  VID_INT

        mov  bx, CRTC_ADDR
        mov  dx, bx
        mov  al, $38
        out  dx, al
        inc  dx
        mov  al, $48
        out  dx, al

        mov  dx, bx
        mov  al, $39
        out  dx, al
        inc  dx
        mov  al, $A5
        out  dx, al

        mov  dx, SEQU_ADDR
        mov  al, $01
        out  dx, al
        inc  dx
        in   al, dx
        or   al, $20
        out  dx, al

        mov  dx, bx
        mov  al, $31
        out  dx, al
        inc  dx
        in   al, dx
        and  al, $C6
        mov  cl, 9
        and  cl, $39
        add  al, cl
        out  dx, al

        mov  dx, bx
        mov  al, $4E
        out  dx, al
        inc  dx
        mov  al, 0
        out  dx, al

        mov  dx, bx
        mov  al, $4F
        out  dx, al
        inc  dx
        mov  al, 0
        out  dx, al

        mov  dx, bx
        mov  al, $34
        out  dx, al
        inc  dx
        in   al, dx
        and  al, $7F
        out  dx, al

        mov  dx, bx
        mov  al, $40
        out  dx, al
        inc  dx
        in   al, dx
        or   al, 1
        out  dx, al

        mov  dx, SEQU_ADDR
        mov  al, 4
        out  dx, al
        inc  dx
        in   al, dx
        or   al, 2
        out  dx, al

        mov  ax, VGA_SEG
        mov  es, ax
        xor  di, di
        db   $67
        mov  ax, 0
        mov  cx, 16000
        db   $66
        rep  stosw

        mov  dx, SEQU_ADDR
        mov  al, $01
        out  dx, al
        inc  dx
        in   al, dx
        and  al, $DF
        out  dx, al


        mov  dx, CRTC_ADDR
        mov  al, $39
        out  dx, al
        inc  dx
        mov  al, $5A
        out  dx, al

        mov  dx, bx
        mov  al, $38
        out  dx, al
        inc  dx
        mov  al, 0
        out  dx, al
     end;

     S3_SetActivePage3x2(0);
     S3_SetVisualPage3x2(0);
end;

{******}

procedure S3_SetWriteBank(Bank : byte);

begin
     asm
        mov  bx, CRTC_ADDR
        mov  dx, bx
        mov  al, $39
        out  dx, al
        inc  dx
        mov  al, $A5
        out  dx, al

        mov  dx, bx
        mov  al, $38
        out  dx, al
        inc  dx
        mov  al, $48
        out  dx, al
     end;

     if (GFXInfo.ChipID >= S3_864) then
     begin
          asm
             mov  dx, CRTC_ADDR
             mov  al, $6A
             out  dx, al
             inc  dx
             mov  al, [Bank]
             out  dx, al
          end;
     end
     else
     begin
          asm
             mov  bx, CRTC_ADDR
             mov  dx, bx
             mov  al, $31
             out  dx, al
             inc  dx
             in   al, dx
             or   al, 9
             out  dx, al

             mov  dx, bx
             mov  al, $35
             out  dx, al
             inc  dx
             in   al, dx
             and  al, $F0
             mov  cl, [Bank]
             and  cl, $0F
             add  al, cl
             out  dx, al
          end;
          if GFXInfo.ChipID > S3_924 then
          begin
               asm
                  mov  dx, CRTC_ADDR
                  mov  al, $51
                  out  dx, al
                  inc  dx
                  in   al, dx
                  and  al, $3F
                  mov  cl, [Bank]
                  shr  cl, 2
                  and  cl, $0C
                  add  al, cl
                  out  dx, al
               end;
          end;
     end;

     asm
        mov  bx, CRTC_ADDR
        mov  dx, bx
        mov  al, $38
        out  dx, al
        inc  dx
        mov  al, 0
        out  dx, al

        mov  dx, bx
        mov  al, $39
        out  dx, al
        inc  dx
        mov  al, $5A
        out  dx, al
     end;
end;

{******}

procedure S3_SetActivePage3x2(Page : word);

begin
     S3_SetWriteBank(Page);
end;

{******}

procedure S3_SetVisualPage3x2(Page : word);

var X, Y : word;

begin
     X:= ((Page shl 8) mod 320);
     Y:= (204 * Page) + ((Page shl 8) div 320);

     S3_SetVisualStart(X, Y);
end;

{******}

procedure S3_SetVisualStart(SX, SY : word);

var L          : longint;
    L1, L2, L3 : word;

begin
     L:= ((320 * longint(SY)) + longint(SX)) shl 6;
     L1:= (L shr 20);
     L2:= (L shr 26);

     asm
        mov  bx, CRTC_ADDR
        mov  dx, bx
        mov  al, $38
        out  dx, al
        inc  dx
        mov  al, $48
        out  dx, al

        mov  dx, bx
        mov  al, $39
        out  dx, al
        inc  dx
        mov  al, $A5
        out  dx, al

        {*** turn off screen ***}

{        mov  dx, SEQU_ADDR
        mov  al, $01
        out  dx, al
        inc  dx
        in   al, dx
        or   al, $20
        out  dx, al}

        mov  dx, bx
        mov  al, $31
        out  dx, al
        inc  dx
        in   al, dx
        and  al, $CF
        mov  cx, [L1]
        and  cx, $30
        add  ax, cx
        out  dx, al
     end;

     if GFXInfo.ChipID > S3_924 then
     begin
          asm
             mov  dx, CRTC_ADDR
             mov  al, $51
             out  dx, al
             inc  dx
             in   al, dx
             and  al, $FC
             mov  cx, [L2]
             and  cx, 3
             add  al, cl
             out  dx, al
          end;
     end;

     L1:= (L and $FF) shr 5;
     L2:= (L shr 8) and $FF;
     L3:= (L shr 16) and $FF;

     asm
        mov  bx, CRTC_ADDR
        mov  dx, bx
        mov  al, $11
        out  dx, al
        inc  dx
        in   al, dx
        and  al, $7F
        out  dx, al

        mov  dx, bx
        add  dx, 6
        in   al, dx
        mov  dx, $03C0
        mov  al, $13
        out  dx, al
        mov  ax, [L1]
        out  dx, al

        mov  dx, $03C0
        mov  al, $33
        out  dx, al

        mov  dx, bx
        mov  al, $0D
        out  dx, al
        inc  dx
        mov  ax, [L2]
        out  dx, al

        mov  dx, bx
        mov  al, $0C
        out  dx, al
        inc  dx
        mov  ax, [L3]
        out  dx, al

        {*** turn on screen ***}

{        mov  dx, SEQU_ADDR
        mov  al, $01
        out  dx, al
        inc  dx
        in   al, dx
        and  al, $DF
        out  dx, al}

        mov  dx, bx
        mov  al, $38
        out  dx, al
        inc  dx
        mov  al, 0
        out  dx, al

        mov  dx, bx
        mov  al, $39
        out  dx, al
        inc  dx
        mov  al, $5A
        out  dx, al
     end;
end;

{******}

end.