unit SGFX_VGA;

(* Information
   

   Program Title : SGFX386 VGA support.
   External name : SGFX_VGA.TPU
   Version       : 1.1
   Start date    : 23/8/96
   Last update   : 12/9/96
   Author        : Rob Anderton.
   Description   : 320x200x256 multipage VGA mode, using VGA hardware and
                   memory buffers (the number of pages = VGA_PAGES).
                   320x200x256 planar mode, providing 4 VRAM pages.

*)

interface

{******}

const VGA_STANDARD           = 2000;
      VGA_PAGES              = 3;

{*** 320x200 all VGA compatibles mode ***}

function  VGA_Detect3x2(var ChipID, VidMemSize : word) : boolean;
procedure VGA_Init3x2;
procedure VGA_Done3x2;
procedure VGA_SetActivePage3x2(Page : word);
procedure VGA_SetVisualPage3x2(Page : word);

{******}

implementation

uses SGFX386, SERROR, Memory;

{******}

var PageData : array[0..VGA_PAGES - 1] of PScreen;
    PageSeg  : array[0..VGA_PAGES - 1] of word;

{******}

function VGA_Detect3x2(var ChipID, VidMemSize : word) : boolean;

begin
     ChipID:= 0;
     VidMemSize:= 0;

     VidMemSize:= MaxAvail;
     if (VidMemSize < VGA_PAGES * 64000) then
     begin
          VGA_Detect3x2:= false;
          exit;
     end;

     VidMemSize:= (VGA_PAGES * 64000) div 1024;
     ChipID:= VGA_STANDARD;

     VGA_Detect3x2:= true;
end;

{******}

procedure VGA_Init3x2;

var Loop : word;

begin
     with GFXInfo do
     begin
          Chip:= GFXMODE_VGA_320x200;
          MemModel:= GFXMEM_PACKED8;
          MinX:= 0;
          MaxX:= 319;
          MinY:= 0;
          MaxY:= 199;
          CurPage:= 0;
          VisPage:= 0;
          MaxPage:= VGA_PAGES - 1;
     end;

     for Loop:= 0 to VGA_PAGES - 1 do
     begin
          PageData[Loop]:= MemAllocSeg(64000);
          if PageData[Loop] = nil then
          begin
               SErrorCode:= (word(ERR_VGA) shl 8) + ERR_VGA_INITERROR;
               exit;
          end;
          PageSeg[Loop]:= Seg(PageData[Loop]^);
     end;

     asm
        mov  ax, $0013
        int  VID_INT
     end;

     VGA_SetActivePage3x2(0);
     VGA_SetVisualPage3x2(0);

end;

{******}

procedure VGA_Done3x2;

var Loop : word;

begin
     for Loop:= 0 to VGA_PAGES - 1 do FreeMem(PageData[Loop], 64000);
end;

{******}

procedure VGA_SetActivePage3x2(Page : word);

begin
     if Page <> GFXInfo.VisPage then VGA_SEG:= PageSeg[Page]
                                else VGA_SEG:= $A000;
end;

{******}

procedure VGA_SetVisualPage3x2(Page : word);

var v : word;

begin
     GFX_CopyFromVRAM(PageSeg[GFXInfo.VisPage]);
     GFX_CopyToVRAM(PageSeg[Page]);
     GFXInfo.VisPage:= Page;
     VGA_SetActivePage3x2(GFXInfo.CurPage);
end;

{******}

end.