unit SGFX_X;

(* Information
   

   Program Title : SGFX386 X mode support.
   External name : SGFX_X.TPU
   Version       : 1.0
   Start date    : 20/9/96
   Last update   : 11/11/96
   Author        : Rob Anderton.
   Description   : Planar (X) mode support using VGA hardware for multiple
                   pages, the following modes are supported:

                   320x200x256 - 4 pages
                   320x240x256 - 3 pages (the original mode X)
                   320x400x256 - 2 pages
                   360x200x256 - 3 pages
                   360x240x256 - 2 pages

*)

interface

{******}

const VGA_XMODE = 2001;

{******}

const  XPelPanMask         : array[0..3] of byte = (  0,   2,   4,   6);
       XLeftClipPlaneMask  : array[0..3] of byte = ($0F, $0E, $0C, $08);
       XRightClipPlaneMask : array[0..3] of byte = ($0F, $01, $03, $07);
       XColumnMask         : array[0..3] of byte = ($11, $22, $44, $88);
       XLeftMaskTable      : array[0..8] of byte = (  0, $FF, $EE,   0,
                                                    $CC,   0,   0,   0, $88);
       XRightMaskTable     : array[0..8] of byte = (  0, $11, $33,   0,
                                                    $77,   0,   0,   0, $FF );

{******}

var XByteWidth : word;

{******}

function  X_Detect(var ChipID, VidMemSize : word) : boolean;
procedure X_Init(Mode : word; Width : word);
procedure X_SetActivePage(Page : word);
procedure X_SetVisualPage(Page : word);

{******}

implementation

uses SGFX386, SERROR, Memory;

{******}

const X320Y200 : array[1..5] of word  = ($0200, $0014, $E317,   320,   200);
      X320Y240 : array[1..13] of word = ($0AE3, $0D06, $3E07, $4109, $EA10,
                                         $AC11, $DF12, $0014, $E715, $0616,
                                         $E317,   320,   240);
      X320Y400 : array[1..6] of word  = ($03E3, $4009, $0014, $E317,   320,
                                           400);
      X360Y200 : array[1..11] of word = ($08E7, $6B00, $5901, $5A02, $8E03,
                                         $5E04, $8A05, $0014, $E317,   360,
                                           200);
      X360Y240 : array[1..19] of word = ($10E7, $6B00, $5901, $5A02, $8E03,
                                         $5E04, $8A05, $0D06, $3E07, $4109,
                                         $EA10, $AC11, $DF12, $0014, $E715,
                                         $0616, $E317,   360,   240);

      XModeTable : array[0..4] of word = (Ofs(X320Y200[1]), Ofs(X320Y240[1]),
                                          Ofs(X320Y400[1]), Ofs(X360Y200[1]),
                                          Ofs(X360Y240[1]));

{******}

function  X_Detect(var ChipID, VidMemSize : word) : boolean;

begin
end;

{******}

procedure X_Init(Mode : word; Width : word);

var XWidth, XHeight, XScanLines : word;

begin
     asm
        cld
        mov   ax, $0013
        int   VID_INT

        mov   dx, SEQU_ADDR
        mov   ax, $0604
        out   dx, ax
        mov   ax, $0100
        out   dx, ax

        mov   bx, OFFSET XModeTable
        mov   cx, [Mode]
        sub   cx, $2001
        shl   cx, 1
        add   bx, cx
        mov   si, word ptr [bx]
        lodsb

        or    al, al
        jz    @NOSETDOT
        mov   dx, MISC_ADDR
        out   dx, al

     @NOSETDOT:

        mov   dx, SEQU_ADDR
        mov   ax, $0300
        out   dx, ax

        mov   dx, CRTC_ADDR
        mov   al, $11
        out   dx, al
        inc   dx
        in    al, dx
        and   al, $7F
        out   dx, al
        dec   dx

        cld
        xor   cx, cx
        lodsb
        mov   cl, al

     @SETCRTLOOP:

        lodsw
        out   dx, ax
        dec   cx
        jne   @SETCRTLOOP

        lodsw
        mov   [XWidth], ax
        lodsw
        mov   [XHeight], ax
        cmp   ax, 240
        jg    @NODOUBLE
        add   ax, ax

     @NODOUBLE:

        mov   [XScanLines], ax

        mov   dx, SEQU_ADDR
        mov   ax, $0F02
        out   dx, ax

        mov   ax, VGA_SEG
        mov   es, ax
        xor   di, di
        xor   ax, ax

        mov   cx, $8000
        rep   stosw

        mov   cx, [Width]
        shr   cx, 3
        mov   dx, CRTC_ADDR
        mov   al, $13
        mov   ah, cl
        out   dx, ax
     end;

     with GFXInfo do
     begin
          Chip:= Mode;
          MemModel:= GFXMEM_PLANAR8;
          MinX:= 0;
          MaxX:= XWidth - 1;
          MinY:= 0;
          MaxY:= XHeight - 1;
          CurPage:= 0;
          VisPage:= 0;
          VRAM:= 256;
          MaxPage:= (256000 div (longint(XHeight) * longint(XWidth))) - 1;
     end;
     XByteWidth:= XWidth div 4;

     X_SetActivePage(0);
     X_SetVisualPage(0);
end;

{******}

procedure X_SetStartOffset(StartOffset : word);

begin
     asm
        mov    bx, [StartOffset]
        mov    dx, CRTC_ADDR
        mov    al, $0C
        mov    ah, bh
        out    dx, ax
        inc    al
        mov    ah, bl
        out    dx, ax
     end;
end;

{******}

procedure X_SetActivePage(Page : word);

begin
     VGA_OFS:=(Page * (((longint(GFXInfo.MaxX) + 1) *
                        (longint(GFXInfo.MaxY) + 1)) div 4));
end;

{******}

procedure X_SetVisualPage(Page : word);

begin
     X_SetStartOffset(Page * (((longint(GFXInfo.MaxX) + 1) *
                               (longint(GFXInfo.MaxY) + 1)) div 4));
end;

{******}

{******}

end.