unit SKEYB;

(* Information
   

   Program Title : Keyboard unit.
   External name : SKEYB.TPU
   Version       : 1.0.
   Start date    : 27/8/96.
   Last update   : 16/12/96.
   Author        : Rob Anderton.
   Description   : Keyboard handler and MFII control.

*)

interface

{******}

type PUserKey = procedure(KeyCode : byte);

const UserHandler : PUserKey = nil;

{*** Key scan codes ***}

const KEY_ESC          = 1;
      KEY_1            = 2;
      KEY_2            = 3;
      KEY_3            = 4;
      KEY_4            = 5;
      KEY_5            = 6;
      KEY_6            = 7;
      KEY_7            = 8;
      KEY_8            = 9;
      KEY_9            = 10;
      KEY_0            = 11;
      KEY_MINUS        = 12;
      KEY_EQUAL        = 13;
      KEY_BACKSPACE    = 14;
      KEY_TAB          = 15;
      KEY_Q            = 16;
      KEY_W            = 17;
      KEY_E            = 18;
      KEY_R            = 19;
      KEY_T            = 20;
      KEY_Y            = 21;
      KEY_U            = 22;
      KEY_I            = 23;
      KEY_O            = 24;
      KEY_P            = 25;
      KEY_LEFTBRACKET  = 26;
      KEY_RIGHTBRACKET = 27;
      KEY_ENTER        = 28;
      KEY_LEFTCTRL     = 29;
      KEY_A            = 30;
      KEY_S            = 31;
      KEY_D            = 32;
      KEY_F            = 33;
      KEY_G            = 34;
      KEY_H            = 35;
      KEY_J            = 36;
      KEY_K            = 37;
      KEY_L            = 38;
      KEY_SEMICOLON    = 39;
      KEY_SINGLEQUOTE  = 40;
      KEY_HASH         = 41;
      KEY_LEFTSHIFT    = 42;
      KEY_Z            = 44;
      KEY_X            = 45;
      KEY_C            = 46;
      KEY_V            = 47;
      KEY_B            = 48;
      KEY_N            = 49;
      KEY_M            = 50;
      KEY_COMMA        = 51;
      KEY_PERIOD       = 52;
      KEY_FWDSLASH     = 53;
      KEY_RIGHTSHIFT   = 54;
      KEY_PADSTAR      = 55;
      KEY_LEFTALT      = 56;
      KEY_SPACE        = 57;
      KEY_CAPSLOCK     = 58;
      KEY_F1           = 59;
      KEY_F2           = 60;
      KEY_F3           = 61;
      KEY_F4           = 62;
      KEY_F5           = 63;
      KEY_F6           = 64;
      KEY_F7           = 65;
      KEY_F8           = 66;
      KEY_F9           = 67;
      KEY_F10          = 68;
      KEY_PADNUMLOCK   = 69;
      KEY_SCROLLLOCK   = 70;
      KEY_PAD7         = 71;
      KEY_PAD8         = 72;
      KEY_PAD9         = 73;
      KEY_PADMINUS     = 74;
      KEY_PAD4         = 75;
      KEY_PAD5         = 76;
      KEY_PAD6         = 77;
      KEY_PADPLUS      = 78;
      KEY_PAD1         = 79;
      KEY_PAD2         = 80;
      KEY_PAD3         = 81;
      KEY_PAD0         = 82;
      KEY_PADDEL       = 83;
      KEY_F11          = 87;
      KEY_F12          = 88;

      KEY_PADENTER     = 28;
      KEY_RIGHTCONTROL = 29;
      KEY_PRINTSCREEN1 = 42;
      KEY_PADFWDSLASH  = 53;
      KEY_PRINTSCREEN2 = 55;
      KEY_RIGHTALT     = 56;
      KEY_HOME         = 71;
      KEY_UP           = 72;
      KEY_PAGEUP       = 73;
      KEY_LEFT         = 75;
      KEY_RIGHT        = 77;
      KEY_END          = 79;
      KEY_DOWN         = 80;
      KEY_PAGEDOWN     = 81;
      KEY_INSERT       = 82;
      KEY_DELETE       = 83;

      KEY_EXTENDED1    = 224;
      KEY_EXTENDED2    = 225;

{******}

procedure Key_Init;
procedure Key_SetHandler(PUser : PUserKey);
procedure Key_BIOSHandler(On : boolean);
procedure Key_Handler; interrupt;
procedure Key_Done;

{******}

implementation

{******}

uses Dos;

{******}

const KEY_IRQ  = 9;
      KEY_PORT = $60;

var BIOSHandler    : procedure;
    UseBIOSHandler : boolean;

{******}

procedure Key_Init;

begin
     UseBIOSHandler:= false;
     GetIntVec(KEY_IRQ, @BIOSHandler);
     SetIntVec(KEY_IRQ, Addr(Key_Handler));
end;

{******}

procedure Key_SetHandler(PUser : PUserKey);

begin
     if @PUser <> nil then UserHandler:= PUser;
end;

{******}

procedure Key_BIOSHandler(On : boolean);

begin
     UseBIOSHandler:= On;
end;

{******}

{$F+}
procedure Key_Handler;

var KeyCode : byte;

begin
     KeyCode:= Port[KEY_PORT];

     if @UserHandler <> nil then UserHandler(KeyCode);

     if UseBIOSHandler then
     begin
          asm
             pushf
          end;

          BIOSHandler;
     end
     else Port[$20]:= $20;
end;
{$F-}

{******}

procedure Key_Done;

begin
     SetIntVec(KEY_IRQ, @BIOSHandler);
end;

{******}

end.