unit SPCX;

(* Information
   

   Program Title : PCX file decoder.
   External name : SPCX.TPU
   Version       : 1.1.
   Start date    : 11/10/96 (based on original, unfinished unit dated 12/05/96).
   Last update   : 11/10/96.
   Author        : Rob Anderton.
   Description   : Routines to load PCX files.

*)

interface

{******}

uses CRT, OBJECTS, SGFX386;

{******}

type TPCXHeader = record
                        Manufacturer : byte;
                        Version      : byte;
                        Encoding     : byte;
                        BPP          : byte;
                        XMin         : word;
                        YMin         : word;
                        XMax         : word;
                        YMax         : word;
                        HDPI         : word;
                        VDPI         : word;
                        ColourMap    : array[1..48] of byte;
                        Reserved     : byte;
                        NPlanes      : byte;
                        BytesPerLine : word;
                        PaletteInfo  : word;
                        HScreenSize  : word;
                        VScreenSize  : word;
                        Filler       : array[1..54] of byte;
                 end;

{******}

procedure PCX_ReadHeader(var S : TStream; var Hdr : TPCXHeader);
procedure PCX_SPF(PCXFile, SPFFile : string; SPFDelete : boolean);

{******}

implementation

{******}

uses SSPF, SUTILS;

{******}

procedure PCX_ReadHeader(var S : TStream; var Hdr : TPCXHeader);

begin
     S.Seek(0);
     S.Read(Hdr, Sizeof(Hdr));
end;

{******}

function PCX_CheckType(Hdr : TPCXHeader) : boolean;

var OK : boolean;

begin
     OK:= true;

     with Hdr do
     begin
          if Manufacturer <> 10 then OK:= false; {not a ZSoft PCX}
          if Version <> 5 then OK:= false;       {not a version 5 PCX}
          if Encoding <> 1 then OK:= false;      {not RLE compressed}
          if BPP <> 8 then OK:= false;           {only support 8 BPP}
          if NPlanes <> 1 then OK:= false;       {only support 1 plane}
     end;

     PCX_CheckType:= OK;
end;

{******}

procedure PCX_GetPalette(var S : TStream; var Pal : TPalette);

var Check : byte;
    Loop  : word;

begin
     S.Seek(S.GetSize - 769);
     S.Read(Check, 1);
     if (Check = 12) then S.Read(Pal, 768)
                     else FillChar(Pal, 768, 0);
     for Loop:= 0 to 767 do Pal[Loop]:= Pal[Loop] div 4;
end;

{******}

function PCX_GetData(var S : TStream; var Data, Count : byte) : byte;

var i : byte;

begin
     Count:= 1;
     S.Read(i, 1);

     if ((i and $C0) = $C0) then
     begin
          Count:= i and $3F;
          S.Read(i, 1);
     end;
     Data:= i;
end;

{******}

procedure PCX_SPF(PCXFile, SPFFile : string; SPFDelete : boolean);

var PCXS   : TBufStream;
    SPFS   : TBufStream;
    PCXHdr : TPCXHeader;
    SPFHdr : TSPFHeader;
    Size   : longint;
    Loop   : longint;
    Data   : byte;
    Count  : byte;
    CLoop  : byte;

begin
     if not U_FileExists(PCXFile) then exit;
     if (U_FileExists(SPFFile) and not SPFDelete) then exit;

     PCXS.Init(PCXFile, stOpen, 1024);
     SPFS.Init(SPFFile, stCreate, 1024);

     PCX_ReadHeader(PCXS, PCXHdr);

     if PCX_CheckType(PCXHdr) then
     begin
          with SPFHdr do
          begin
               SPFID:= 'SPF';
               Version:= $0100; {1.00}
               Width:= PCXHdr.XMax - PCXHdr.XMin + 1;
               Height:= PCXHdr.YMax - PCXHdr.YMin + 1;
               PCX_GetPalette(PCXS, Palette);
          end;

          SPFS.Seek(0);
          SPFS.Write(SPFHdr, sizeof(TSPFHeader));

          Size:= longint(PCXHdr.BytesPerLine) * longint(SPFHdr.Height);
          PCXS.Seek(Sizeof(TPCXHeader));

          Loop:= 0;

          while (Loop < Size) do
          begin
               PCX_GetData(PCXS, Data, Count);

               for CLoop:= 1 to Count do SPFS.Write(Data, sizeof(Data));
               Inc(Loop, Count);
          end;
     end;

     PCXS.Done;
     SPFS.Done;
end;

{******}

end.