unit SRES;

(* Information
   

   Program Title : S-Library resource file support.
   External name : SRES.TPU
   Version       : 1.1
   Start date    : 23/10/96
   Last update   : 10/11/96
   Author        : Rob Anderton.
   Description   : S-Library resource file routines. Resource files are
                   basically object based TResourceFile type streams.

*)

interface

{******}

uses Objects, SBDSP, SSPF;

{******}

type PSoundRes = ^TSoundRes;
     TSoundRes = object(TObject)

                       SoundInfo : TSoundHdr;

                       constructor Load(var S : TStream);
                       procedure   Store(var S : TStream); virtual;
                 end;

     PPicRes     = ^TPicRes;
     TPicRes     = object(TObject)

                       PicInfo : TSPFHeader;

                       constructor Load(var S : TStream);
                       procedure   Store(var S : TStream); virtual;
                 end;

{******}

procedure Res_GetSoundInfo(var ResFile : PStream; ResName : string; var ResHdr : TSoundHdr);

{******}

implementation

uses SERROR;

{******}

const RSoundRes : TStreamRec = (ObjType : 1000;
                                VMTLink : Ofs(TypeOf(TSoundRes)^);
                                Load    : @TSoundRes.Load;
                                Store   : @TSoundRes.Store
                               );

      RPicRes   : TStreamRec = (ObjType : 1001;
                                VMTLink : Ofs(TypeOf(TPicRes)^);
                                Load    : @TPicRes.Load;
                                Store   : @TPicRes.Store
                               );

{******}

constructor TSoundRes.Load(var S : TStream);

begin
     inherited Init;
     S.Read(SoundInfo, sizeof(SoundInfo));
     S.Seek(S.GetPos + SoundInfo.Size);
end;

{******}

procedure TSoundRes.Store(var S : TStream);

begin
     S.Write(SoundInfo, sizeof(SoundInfo));
     S.Seek(S.GetPos + SoundInfo.Size);
end;

{******}

constructor TPicRes.Load(var S : TStream);

begin
     inherited Init;
     S.Read(PicInfo, sizeof(PicInfo));
     S.Seek(S.GetPos + (PicInfo.Width * PicInfo.Height));
end;

{******}

procedure TPicRes.Store(var S : TStream);

begin
     S.Write(PicInfo, sizeof(PicInfo));
     S.Seek(S.GetPos + (PicInfo.Width * PicInfo.Height));
end;

{******}

procedure Res_GetSoundInfo(var ResFile : PStream; ResName : string; var ResHdr : TSoundHdr);

var Sound : PSoundRes;
    Res   : TResourceFile;

begin
     Res.Init(ResFile);
     Sound:= PSoundRes(Res.Get(ResName));
     Res.Done;

     if Sound = nil then
     begin
          SErrorCode:= (word(ERR_RES) shl 8) + ERR_RES_KEYNOTFOUND;
          exit;
     end;

     if Sound^.SoundInfo.SoundID <> DSP_SOUNDID then
     begin
          SErrorCode:= (word(ERR_RES) shl 8) + ERR_RES_TYPEERROR;
          exit;
     end;

     ResHdr:= Sound^.SoundInfo;
     SErrorCode:= 0;
end;

{******}

begin
     RegisterType(RSoundRes);
     RegisterType(RPicRes);
end.
