unit SSPF;

(* Information
   

   Program Title : SPF (S-Library Picture File) routines.
   External name : SSPF.TPU
   Version       : 1.0.
   Start date    : 13/10/96.
   Last update   : 13/10/96.
   Author        : Rob Anderton.
   Description   : Routines to load/save SPF format files.

*)

interface

{******}

uses CRT, OBJECTS, SGFX386;

{******}

type TSPFHeader = record
                        SPFID        : string[3]; {'SPF'}
                        Version      : word;
                        Width        : word;
                        Height       : word;
                        Palette      : TPalette;
                  end;

{******}

procedure SPF_Display(SPFName : string; X, Y : word; SetPalette : boolean);

{******}

implementation

{******}

procedure SPF_Display(SPFName : string; X, Y : word; SetPalette : boolean);

var SPFS   : TBufStream;
    SPFHdr : TSPFHeader;
    LX, LY : word;
    MX, MY : word;
    Data   : byte;

begin
     SPFS.Init(SPFName, stOpen, 1024);
     SPFS.Read(SPFHdr, sizeof(TSPFHeader));

     if X + SPFHdr.Width - 1> GFXInfo.MaxX then MX:= GFXInfo.MaxX - X
                                           else MX:= SPFHdr.Width - 1;

     if Y + SPFHdr.Height - 1 > GFXInfo.MaxY then MY:= GFXInfo.MaxY - Y
                                             else MY:= SPFHdr.Height - 1;

     for LY:= Y to MY do
     begin
         for LX:= X to MX do
         begin
              SPFS.Read(Data, 1);
              GFX_PutPixel(LX, LY, Data);
         end;
         SPFS.Seek(SPFS.GetPos + (SPFHdr.Width - MX - 1));
     end;

     SPFS.Done;
     if SetPalette then GFX_SetAllPal(SPFHdr.Palette);
end;

{******}

end.