unit SUTILS;

(* Information
   

   Program Title : S-Library general routines.
   External name : SUTILS.TPU
   Version       : 1.0
   Start date    : 27/8/96
   Last update   : 11/10/96
   Author        : Rob Anderton.
   Description   : Miscellaneous routines used by various S components.

*)

interface

{*** Useful(?) types ***}

type PByteArray = ^TByteArray;
     TByteArray = array[0..65534] of byte;
     PWordArray = ^TWordArray;
     TWordArray = array[0..32766] of word;


{******}

function  U_HexToDec(HexStr : string) : integer;
function  U_DecToHex(w : word) : string;
function  U_IntToStr(i: Longint): string;

function  U_StrUpper(S : string) : string;

function  U_GetLinearAddr(Ptr : pointer) : longint;
function  U_NormalisePtr(p : pointer) : pointer;

function  U_FileExists(Filename: string) : boolean;

function  U_Min(a, b : longint) : longint;
function  U_Max(a, b : longint) : longint;
procedure U_Swap(var a, b : longint);

function  U_dos_open(Filename : string) : integer;
procedure U_dos_close(Handle : integer);
function  U_dos_read(Handle : integer; Buf : pointer; Count : integer) : word;
function  U_dos_write(Handle : integer; Buf : pointer; Count : integer) : word;
function  U_dos_filesize(Handle : integer) : longint;

function  U_Power(n, p : longint) : longint;

{******}

implementation

uses Dos;

{******}

function U_HexToDec(HexStr : string) : integer;

var NumChars : integer;
    Value, i : integer;

begin
     NumChars:= 0;
     Value:= 0;

     if HexStr <> '' then
     begin
          i:= 1;
          while (HexStr[i] = ' ') and (i <= length(HexStr)) do inc(i);

          while i <= Length(HexStr) do
          begin
               case HexStr[i] of
                    '0'..'9' : begin
                                    Value:= Value * $10;
                                    Value:= Value + integer(HexStr[i]) - integer('0');
                                    NumChars:= Succ(NumChars);
                               end;

                    'a'..'f' : begin
                                    Value:= Value * $10;
                                    Value:= Value + integer(HexStr[i]) - integer('a') + 10;
                                    NumChars:= Succ(NumChars);
                               end;

                    'A'..'F' : begin
                                    Value:= Value * $10;
                                    Value:= Value + integer(HexStr[i]) - integer('A') + 10;
                                    NumChars:= Succ(NumChars);
                               end;

                          else begin
                                    if NumChars <> 0 then U_HexToDec:= Value
                                                     else U_HexToDec:= 0;
                                    exit;
                               end;
               end;
               Inc(i);
          end;
          U_HexToDec:= Value;
     end
     else U_HexToDec:= 0;
end;

{******}

function U_DecToHex(w : word) : string;

const HexChars : array [0..$F] of char = '0123456789ABCDEF';

var HexStr : string;

begin
     HexStr:= (HexChars[Hi(w) shr 4] + HexChars[Hi(w) and $F] +
               HexChars[Lo(w) shr 4] + HexChars[Lo(w) and $F]);
     U_DecToHex:= HexStr;
end;

{******}

function U_IntToStr(i : longint): string;

var s : string[11];

begin
     Str(i, s);
     U_IntToStr:= s;
end;

{******}

function U_StrUpper(S : string) : string;

var Loop : byte;
    Temp : string;

begin
     Temp[0]:= S[0];
     for Loop:= 1 to Length(S) do Temp[Loop]:= Upcase(S[Loop]);
     U_StrUpper:= Temp;
end;

{******}

function U_GetLinearAddr(Ptr : pointer) : longint;

begin
     U_GetLinearAddr:= longint(Seg(Ptr^)) * 16 + longint(Ofs(Ptr^));
end;

{******}

function U_NormalisePtr(p : pointer) : pointer;

var LinearAddr : longint;

begin
     LinearAddr:= U_GetLinearAddr(p);
     U_NormalisePtr:= Ptr(LinearAddr div 16, LinearAddr mod 16);
end;

{******}

function U_Min(a, b : longint) : longint;

begin
     if a < b then U_Min:= a
              else U_Min:= b;
end;

{******}

function U_Max(a, b : longint) : longint;

begin
     if a > b then U_Max:= a
              else U_Max:= b;
end;

{******}

procedure U_Swap(var a, b : longint);

var t : longint;

begin
     t:= a;
     a:= b;
     b:= t;
end;

{******}

function U_FileExists(Filename: string) : boolean;

var f : file;

begin
     {$I-}
     Assign(f, Filename);
     FileMode:= 0;
     Reset(f);
     Close(f);
     {$I+}
     U_FileExists:= (IOResult = 0) and (Filename <> '');
end;

{******}

function U_dos_open(Filename : string) : integer;

var Regs : Registers;

begin
     Regs.ah:= $3D;
     Regs.al:= $2;
     FileName:= FileName + #0;
     Regs.ds:= longint(@Filename[1]) shr 16;
     Regs.dx:= longint(@FileName[1]) and $FFFF;

     MSDOS(Regs);
     if (Regs.Flags and 1) <> 0 then U_dos_open:= -1
                                else U_dos_open:= Regs.ax;
end;

{******}

procedure U_dos_close(Handle : integer);

var Regs : Registers;

begin
     if Handle >= 0 then
     begin
          Regs.ah:= $3E;
          Regs.bx:= Handle;
          MSDOS(Regs);
     end;
end;

{******}

function U_dos_read(Handle : integer; Buf : pointer; Count : integer) : word;

var Regs : Registers;

begin
     if Handle >= 0 then
     begin
          Regs.ah:= $3F;
          Regs.bx:= Handle;
          Regs.cx:= Count;
          Regs.ds:= longint(Buf) shr 16;
          Regs.dx:= longint(Buf) and $FFFF; { Offset }
          MSDOS(Regs);
          if (Regs.Flags and 1) <> 0 then U_dos_read:= 0
                                     else U_dos_read:= Regs.ax;
     end;
end;

{******}

function U_dos_write(Handle : integer; Buf : pointer; Count : integer) : word;

var Regs : Registers;

begin
     if Handle >= 0 then
     begin
          Regs.ah:= $40;
          Regs.bx:= Handle;
          Regs.cx:= Count;
          Regs.ds:= longint(Buf) shr 16;
          Regs.dx:= longint(Buf) and $FFFF;
          MSDOS(Regs);
          if (Regs.Flags and 1) <> 0 then U_dos_write:= 0
                                     else U_dos_write:= Regs.ax;
     end;
end;

{******}

function U_dos_filesize(Handle : integer) : longint;

var Regs             : Registers;
    actposl, actposh : word;

begin
     U_dos_filesize:= 0;
     if Handle >= 0 then
     begin
          Regs.ah:= $42;
          Regs.al:= 1;
          Regs.bx:= Handle;
          Regs.cx:= 0;
          Regs.dx:= 0;
          MSDOS(Regs);
          if Regs.Flags and 1 = 0 then
          begin
               actposl:= Regs.ax;
               actposh:= Regs.dx;
          end
          else exit;

          Regs.ah:= $42;
          Regs.al:= 2;
          Regs.bx:= Handle;
          Regs.cx:= 0;
          Regs.dx:= 0;
          MSDOS(Regs);
          if Regs.Flags and 1 = 0 then
          begin
               U_dos_filesize:= longint(Regs.dx) shl 16 + longint (Regs.ax);
          end
          else exit;

          Regs.ah:= $42;
          Regs.al:= 0;    { relative to beginning of file }
          Regs.bx:= Handle;
          Regs.cx:= actposh;     { no offset }
          Regs.dx:= actposl;
          MSDOS(Regs);
          if Regs.Flags and 1 <> 0 then
          begin
               U_dos_filesize:= 0;
               exit;
          end;
     end;
end;

{******}

function U_Power(n, p : longint) : longint;

begin
     if p = 0 then U_Power:= 1
              else if n = 0 then U_Power:= 0
                            else U_Power:= n * U_Power(n, (p - 1))
end;

{******}

end.