program INI2DB;

(* Information
   

   Program Title : Plug and Play device database creator.
   External name : INI2DB.TPU
   Version       : 1.0.
   Start date    : 18/9/97.
   Last update   : 18/9/97.
   Author        : Rob Anderton.
   Description   : Converts the SPNP.INI file into an indexed data file.

*)

uses SINI, SPNP, SPNPOBJ, SUTILS, OBJECTS, CRT;

{******}

var OutFile : TResourceFile;

{******}

procedure WritePCIDevices;

var VendorID   : word;
    DeviceID   : word;

    VendorStr  : string;
    DeviceStr  : string;

    VendorNum  : word;
    DeviceNum  : word;

    MfgName    : string;
    DeviceName : string;
    DeviceDesc : string;

    PCIDevice  : TPCIDevice;

begin
     VendorNum:= 0;
     repeat
        INI_GetProfileString(PNP_DEVICELIST_FILENAME, 'PCI Vendors',
                             'PCI_VENDOR_' + U_IntToStr(VendorNum),
                             VendorStr, '');

        write('Processing vendor ', VendorStr);
        if VendorStr <> '' then
        begin
           INI_GetProfileString(PNP_DEVICELIST_FILENAME,
                                'PCI_VENDOR_' + VendorStr,
                                'MFG_NAME', MfgName, '');

           PCIDevice.Init(MfgName, 'Unknown PCI device', ' ');
           OutFile.Put(@PCIDevice, 'PCI_' + VendorStr + '_XXXX');
           PCIDevice.Done;

           DeviceNum:= 0;
           while true do
           begin
              write('.');
              INI_GetProfileString(PNP_DEVICELIST_FILENAME,
                                   'PCI_VENDOR_' + VendorStr,
                                   'PCI_DEVICE_ID_' + U_IntToStr(DeviceNum),
                                   DeviceStr, '');

              if DeviceStr = '' then Break
              else
              begin
                   INI_GetProfileString(PNP_DEVICELIST_FILENAME,
                                        'PCI_VENDOR_' + VendorStr,
                                        'PCI_DEVICE_NAME_' + U_IntToStr(DeviceNum),
                                        DeviceName, ' ');

                   INI_GetProfileString(PNP_DEVICELIST_FILENAME,
                                        'PCI_VENDOR_' + VendorStr,
                                        'PCI_DEVICE_DESC_' + U_IntToStr(DeviceNum),
                                        DeviceDesc, ' ');


                   VendorStr:= U_StrUpper(VendorStr);
                   DeviceStr:= U_StrUpper(DeviceStr);
                   PCIDevice.Init(MfgName, DeviceName, DeviceDesc);
                   OutFile.Put(@PCIDevice, 'PCI_' + VendorStr + '_' + DeviceStr);
                   PCIDevice.Done;
              end;
              Inc(DeviceNum);
           end;
        end;
        writeln;
        Inc(VendorNum);
     until VendorStr = '';
end;

{******}

procedure WritePNPDevices;

var DevIDFile  : text;

    DeviceStr  : string;
    DeviceDesc : string;

    ISADevice  : TISADevice;

begin
     Assign(DevIDFile, 'PNPDEVID.TXT');
     Reset(DevIDFile);

     while not EOF(DevIDFile) do
     begin
          Readln(DevIDFile, DeviceStr);
          DeviceStr:= U_StrUpper(DeviceStr);
          Readln(DevIDFile, DeviceDesc);
          writeln('Processing PnP device ', DeviceStr);

          ISADevice.Init(DeviceDesc);
          OutFile.Put(@ISADevice, DeviceStr);
          ISADevice.Done;
     end;
     Close(DevIDFile);
end;

{******}

begin
     ClrScr;
     INI_LoadComments:= false;
     OutFile.Init(New(PDosStream, Init('SPNP.DAT', stCreate)));
     WritePCIDevices;
     WritePNPDevices;
     writeln;
     writeln('Database contains ', OutFile.Count, ' device entries.');
     OutFile.Flush;
     writeln('Database size ', OutFile.Stream^.GetSize, ' bytes.');
     writeln;
     OutFile.Done;
end.