unit SPNPCM;

(* Information
   

   Program Title : Plug and Play support objects.
   External name : SPNPCM.TPU
   Version       : 1.0
   Start date    : 19/9/97
   Last update   : 19/9/97
   Author        : Rob Anderton.
   Description   : Plug and Play configuration manager object - the access
                   point to all PnP functions.

*)

interface

{******}

uses OBJECTS, SPNPBIOS, SPNPISA, SPNPPCI, SPNPTYPE;

{******}

type

    {*** Configuration Manager object ***}
    PConfigurationManager = ^TConfigurationManager;
    TConfigurationManager = object(TObject)

                                   ConfigFilename : PString;
                                   DeviceFilename : PString;

                                   DeviceCount    : word;

                                   constructor Init(sConfigFilename : string;
                                                    sDeviceFilename : string);

                                   destructor  Done; virtual;

                            private

                                   PnPBIOSEntry  : pointer;
                                   PnPBIOSHeader : TPnPHeader;
                                   PnPISAConfig  : TISAConfig;
{                                   PnPPCIHeader  : TPCIHeader;}

                                   procedure WriteConfigFile;
                            end;

{******}

implementation

{******}

{*** Configuration Manager object ***}

constructor TConfigurationManager.Init(sConfigFilename : string;
                                       sDeviceFilename : string);

begin
     inherited Init;
     ConfigFilename:= NewStr(sConfigFilename);
     DeviceFilename:= NewStr(sDeviceFilename);
end;

{******}

destructor TConfigurationManager.Done;

begin
     if Assigned(ConfigFilename) then DisposeStr(ConfigFilename);
     if Assigned(DeviceFilename) then DisposeStr(DeviceFilename);
     inherited Done;
end;

{******}

procedure TConfigurationManager.WriteConfigFile;

begin
end;


{******}

end.