unit SPNPExit;

(* Information
   

   Program Title : PnP demo exit procedure.
   External name : SPNPEXIT.TPU
   Version       : 1.0
   Start date    : 31/03/97
   Author        : Rob Anderton.
   Description   : Exit procedure (in case of runtime error).

*)

interface

var OldExit : pointer;

{******}

procedure ExitDemo; far;

{******}

implementation

uses Crt, App;

{******}

procedure ExitDemo;

begin
     ExitProc:= OldExit;

     if (ExitCode <> 0) and (ErrorAddr <> nil) then
     begin
          if Application <> nil then Application^.Done;
          GotoXY(1,1);
          TextColor(WHITE);
          writeln('SPNPTEST version 1.1.');

          GotoXY(1,3);
          Sound(220);
          Delay(200);
          NoSound;
          TextColor(YELLOW);
          write('Critical error code : ');
          TextColor(WHITE);
          write(ExitCode);
          GotoXY(1, 5);
          write(#4' If the error occurs frequently please contact Rob Anderton.');
          GotoXY(1, 6);
          TextColor(CYAN);
          write('  email : robanderton@geocities.com');
          TextColor(WHITE);
          GotoXY(1,7);
          write(#4' Please quote the critical error code.');
          GotoXY(1,12);
          ExitCode:= 0;
          ErrorAddr:= nil;
     end;
end;

{******}

begin
     OldExit:= ExitProc;
     ExitProc:= @ExitDemo;
end.