unit SPNPOBJ;

{******}

interface

{******}

uses OBJECTS;

{******}

type
     {*** SPNP database objects ***}
     PISADevice = ^TISADevice;
     TISADevice = object(TObject)
                         DeviceDesc : PString;

                         constructor Init(Desc : string);
                         constructor Load(var S : TStream);
                         procedure   Store(var S : TStream);
                         destructor  Done; virtual;
                  end;

     PPCIDevice = ^TPCIDevice;
     TPCIDevice = object(TObject)
                         MfgName    : PString;
                         DeviceName : PString;
                         DeviceDesc : PString;

                         constructor Init(Mfg, Name, Desc : string);
                         constructor Load(var S : TStream);
                         procedure   Store(var S : TStream);
                         destructor  Done; virtual;
                  end;

{*** Registration records ***}

const RISADevice: TStreamRec = (ObjType : 3000;
                                VMTLink : Ofs(TypeOf(TISADevice)^);
                                Load    : @TISADevice.Load;
                                Store   : @TISADevice.Store);

      RPCIDevice: TStreamRec = (ObjType : 3001;
                                VMTLink : Ofs(TypeOf(TPCIDevice)^);
                                Load    : @TPCIDevice.Load;
                                Store   : @TPCIDevice.Store);

{******}

implementation

{*** ISA Device object ***}

constructor TISADevice.Init(Desc : string);

begin
     inherited Init;
     DeviceDesc:= NewStr(Desc);
end;

{******}

constructor TISADevice.Load(var S : TStream);

begin
     DeviceDesc:= S.ReadStr;
end;

{******}

procedure TISADevice.Store(var S : TStream);

begin
     S.WriteStr(DeviceDesc);
end;

{******}

destructor TISADevice.Done;

begin
     DisposeStr(DeviceDesc);
     inherited Done;
end;

{*** PCI Device object ***}

constructor TPCIDevice.Init(Mfg, Name, Desc : string);

begin
     inherited Init;
     MfgName:= NewStr(Mfg);
     DeviceName:= NewStr(Name);
     DeviceDesc:= NewStr(Desc);
end;

{******}

constructor TPCIDevice.Load(var S : TStream);

begin
     MfgName:= S.ReadStr;
     DeviceName:= S.ReadStr;
     DeviceDesc:= S.ReadStr;
end;

{******}

procedure TPCIDevice.Store(var S : TStream);

begin
     S.WriteStr(MfgName);
     S.WriteStr(DeviceName);
     S.WriteStr(DeviceDesc);
end;

{******}

destructor TPCIDevice.Done;

begin
     DisposeStr(MfgName);
     DisposeStr(DeviceName);
     DisposeStr(DeviceDesc);
     inherited Done;
end;

{******}

procedure PnP_StreamError(var S : TStream); far;

begin
     writeln;
     writeln('I/O error - ', S.Status);
     writeln;
     halt(1);
end;

{******}

begin
     StreamError:= @PnP_StreamError;
     RegisterType(RISADevice);
     RegisterType(RPCIDevice);
end.