;  Information
;  
;
;  Program Title : PCI support (32 bit calls).
;  External name : SPNPPCI.OBJ
;  Version       : 1.0.
;  Start date    : 11/9/97.
;  Last update   : 13/9/97.
;  Author        : Rob Anderton.
;  Description   : Assembly module allowing the SPNP package to detect the
;                  presence of a PCI BIOS, and to access certain PCI BIOS
;                  functions. NASM is used to provide easy access to 32 bit
;                  registers.


; Set code generation to 16 bits
[BITS 16]

; Functions to be called externally by Pascal
[GLOBAL PnP_PCI_DetectBIOS]
[GLOBAL PnP_PCI_ReadConfigLongint]

; Define code segment to hold function
[SEGMENT CODE]

;(* PnP_PCI_DetectBIOS - calls interrupt 1Ah, function B101h to detect
;                        a PCI version 2.0 or higher BIOS.
;
;                        Return values :
;                             DX : half of PCI signature string " I"
;                             DI : half of PCI signature string "CP"
;                             AL : hardware characteristics
;                             AH : equals 00h if PCI BIOS installed
;                             BL : PCI interface minor version number
;                             BH : PCI interface major version number
;                             CL : number of last bus in the system
;
;*)

PnP_PCI_DetectBIOS:

              mov  ax, 0xB101     ; set function number
              xor  edi, edi       ; blank EDI (required by some BIOS's)
              int  0x1A           ; call interrupt 1Ah
              xor  edi, edi       ; blank EDI (to be on safe side)
              mov  di, dx         ; move half of signature to DI
              shr  edx, 16        ; shift remaining half into DX
              ret                 ; return to TP7
                                     			

;(* PnP_PCI_ReadConfigLongint - calls interrupt 1Ah, function B10Ah to
;                               read a DWORD of PCI configuration data.
;
;                        Calling values:
;
;                             BX : combined device, function and bus number
;                             DI : the configuration register to access

;                        Return values :
;                             DX : low word of configuration data
;                             CX : high word of configuration data
;                             AH : status code
;                             CF : carry set on error
;
;*)

PnP_PCI_ReadConfigLongint:

              mov  ax, 0xB10A     ; set function number
              int  0x1A           ; call interrupt 1Ah
              xor  edx, edx       ; blank EDX (to be on safe side)
              mov  dx, cx         ; move half of data to DX
              shr  ecx, 16        ; shift remaining half into CX
              ret                 ; return to TP7

;*** End of module ***              			
