unit SPNPTYPE;

(* Information
   

   Program Title : Plug and Play support.
   External name : SPNPTYPE.TPU
   Version       : 1.0
   Start date    : 16/7/97
   Last update   : 3/9/97
   Author        : Rob Anderton.
   Description   : Plug and Play global constants and data types.

*)

interface

{*** PnP data types ***}

type
     {*** Used to store BIOS Plug and Play header ***}
     TPNPHeader = record
                        Signature    : longint;   {'$PnP'}
                        Version      : byte;      {10h}
                        Length       : byte;      {21h}
                        Control      : word;      {variable}
                        CheckSum     : byte;      {variable}
                        EventAddr    : longint;   {variable}
                        RealEntryOfs : word;      {variable}
                        RealEntrySeg : word;      {variable}
                        ProtEntryOfs : word;      {variable}
                        ProtCodeSeg  : longint;   {variable}
                        OEMDeviceID  : longint;   {variable}
                        RealDataSeg  : word;      {variable}
                        ProtDataSeg  : longint;   {variable}
                  end;

     {*** System device node header ***}
     TSystemDeviceNode = record
                               Size       : word;
                               Handle     : byte;
                               ProductID  : longint;
                               DeviceType : array[1..3] of byte;
                               Attributes : word;
                               {Allocated resource descriptor block}
                               {Possible resource descriptor block}
                               {Compatible device identifiers}
                         end;

     {*** Plug and Play ISA configuration structure ***}
     TISAConfig = record
                        Revision    : byte;   {01h}
                        TotalCSN    : byte;   {Variable}
                        ReadPort    : word;   {Variable}
                        Reserved    : word;   {0}
                  end;

     {*** Small resource data types - PnP Version Number ***}
     PPnPVersionNumber = ^TPnPVersionNumber;
     TPnPVersionNumber = record
                               Version       : byte;
                               VendorVersion : byte;
                               Next          : PPnPVersionNumber;
                         end;

     {*** Small resource data types - Logical Device ID ***}
     PLogicalDeviceID = ^TLogicalDeviceID;
     TLogicalDeviceID = record
                              LogicalID      : longint;
                              Flags          : array[1..2] of byte;
                              Next           : PLogicalDeviceID;
                        end;

     {*** Small resource data types - Compatible Device ID ***}
     PCompatibleDeviceID = ^TCompatibleDeviceID;
     TCompatibleDeviceID = record
                                 CompatibleID : longint;
                                 Next         : PCompatibleDeviceID;
                           end;

     {*** Small resource data types - IRQ Format ***}
     PIRQFormat = ^TIRQFormat;
     TIRQFormat = record
                        IRQMaskBits : word;
                        IRQInfo     : byte;
                        Next        : PIRQFormat;
                  end;

     {*** Small resource data types - DMA Format ***}
     PDMAFormat = ^TDMAFormat;
     TDMAFormat = record
                        DMAMaskBits : byte;
                        DMAInfo     : byte;
                        Next        : PDMAFormat;
                  end;

     {*** Small resource data types - IO Port Descriptor ***}
     PIOPortDescriptor = ^TIOPortDescriptor;
     TIOPortDescriptor = record
                               Information     : byte;
                               MinimumBaseAddr : word;
                               MaximumBaseAddr : word;
                               BaseAlignment   : byte;
                               RangeLength     : byte;
                               Next            : PIOPortDescriptor;
                         end;

     {*** Small resource data types - Fixed Location IO Port Descriptor ***}
     PFixedIOPortDescriptor = ^TFixedIOPortDescriptor;
     TFixedIOPortDescriptor = record
                                    BaseAddr    : word;
                                    RangeLength : byte;
                                    Next        : PFixedIOPortDescriptor;
                              end;

     {*** Small resource data types - Vendor Defined ***}
     PVendorDefined = ^TVendorDefined;
     TVendorDefined = byte;

     {*** Small resource data types - End Tag ***}
     PEndTag = ^TEndTag;
     TEndTag = byte;

     {*** Large resource data types - Memory Range Descriptor ***}
     PMemoryRangeDescriptor = ^TMemoryRangeDescriptor;
     TMemoryRangeDescriptor = record
                                    Length           : word;
                                    Information      : byte;
                                    MinimumBaseAddr  : word;
                                    MaximumBaseAddr  : word;
                                    BaseAlignment    : word;
                                    RangeLength      : word;
                                    Next             : PMemoryRangeDescriptor;
                              end;

     {*** Large resource data types - ANSI Identifier String ***}
     PANSIIdentifier = ^TANSIIdentifier;
     TANSIIdentifier = record
                             Length     : word;
                             Identifier : pointer;
                             Next       : PANSIIdentifier;
                       end;

     {*** Large resource data types - Unicode Identifier String ***}
     PUnicodeIdentifier = ^TUnicodeIdentifier;
     TUnicodeIdentifier = record
                                Length     : word;
                                CountryID  : word;
                                Identifier : pointer;
                          end;

     {*** Large resource data types - Vendor Defined ***}
     PVendorDefinedLarge = ^TVendorDefinedLarge;
     TVendorDefinedLarge = pointer;

     {*** Large resource data types - 32 Bit Memory Range Descriptor ***}
     PMemoryDescriptor32 = ^TMemoryDescriptor32;
     TMemoryDescriptor32 = record
                                 Information     : byte;
                                 MinimumBaseAddr : longint;
                                 MaximumBaseAddr : longint;
                                 BaseAlignment   : longint;
                                 RangeLength     : longint;
                                 Next            : PMemoryDescriptor32;
                           end;

     {*** Large resource data types - 32 Bit Fixed Memory Range Descriptor ***}
     PFixedMemoryDescriptor32 = ^TFixedMemoryDescriptor32;
     TFixedMemoryDescriptor32 = record
                                      Information       : byte;
                                      BaseAddr          : longint;
                                      RangeLength       : longint;
                                end;

     {*** Record type used to describe attributes of each PnP device ***}
     PPnPDeviceHeader = ^TPnPDeviceHeader;
     TPnPDeviceHeader = record
                              HandleCSN         : byte;      {Handle or CSN
                                                              for device}
                              LogicalDevNum     : byte;      {Logical device
                                                              number}
                              ProductID         : longint;   {EISA packed ID}
                              DeviceType        : array[1..3] of byte;
                              NumLogicalDevices : byte;      {Number of
                                                              logical devices
                                                              attached}
                        end;

     {*** Record type used to describe a PnP device ***}
     PPnPDeviceInfo = ^TPnPDeviceInfo;
     TPnPDeviceInfo = record
                            DeviceHeader       : TPnPDeviceHeader;
                            VersionInfo        : PPnPVersionNumber;
                            LogicalDevInfo     : PPnPDeviceInfo;
                            CompatibleDevInfo  : PCompatibleDeviceID;
                            ANSIIdentifier     : PANSIIdentifier;
                            IRQ                : PIRQFormat;
                            DMA                : PDMAFormat;
                            IOPort             : PIOPortDescriptor;
                            MemoryRange        : PMemoryRangeDescriptor;
                            MemoryRange32      : PMemoryDescriptor32;
                            Next               : PPnPDeviceInfo;
                        end;

     {*** PnP ISA data types ***}
     TSerialKey = array[0..8] of byte; {72 bit Serial Identification Key
                                        used by ISA PnP devices}

{*** PnP return codes ***}

const (* Function completed successfully *)
      PNP_SUCCESS = $00;

      {*** Warning codes ***}

      (* Warning that indicates a device could not be configured
         statically, but was successfully configured dynamically.
         Only returned by function 02h.                          *)
      PNP_NOT_SET_STATICALLY                     = $7F;

      {*** Error codes ***}

      (* Generic error code *)
      PNP_GENERIC_ERROR                          = $80;

      (* Unknown, or invalid, function number passed *)
      PNP_UNKNOWN_FUNCTION                       = $81;

      (* The function is not supported on this system *)
      PNP_FUNCTION_NOT_SUPPORTED                 = $82;

      (* Device node number/handle passed is invalid or out of range *)
      PNP_INVALID_HANDLE                         = $83;

      (* Function detected invalid resource descriptors or resource
         descriptors were specified out of order                    *)
      PNP_BAD_PARAMETER                          = $84;

      (* Set Device Node function failed *)
      PNP_SET_FAILED                             = $85;

      (* There are no events pending *)
      PNP_EVENTS_NOT_PENDING                     = $86;

      (* The system is currently not docked *)
      PNP_SYSTEM_NOT_DOCKED                      = $87;

      (* Indicated that no ISA Plug and Play cards are installed
         in the system                                           *)
      PNP_NO_ISA_PNP_CARDS                       = $88;

      (* Indicates that the system was not able to determine the
         capabilities of the docking station                     *)
      PNP_UNABLE_TO_DETERMINE_DOCK_CAPABILITIES  = $89;

      (* The system failed the undocking sequence because it
         detected that the system unit did not have a battery *)
      PNP_CONFIG_CHANGE_FAILED_NO_BATTERY        = $8A;

      (* The system failed to successfully dock because it
         detected a resource conflict with one of the primary
         boot devices; such as input, output or the IPL device *)
      PNP_CONFIG_CHANGE_FAILED_RESOURCE_CONFLICT = $8B;

      (* The memory buffer passed by the caller was not large
         enough to hold the data to be returned by the system BIOS *)
      PNP_BUFFER_TOO_SMALL                       = $8C;

      (* This return code is used by functions 09h and 0Ah to
         instruct the caller that reporting resources explicitly
         assigned to devices in the system to the system BIOS
         must be handled through the interfaces defined by the
         ESCD specification                                     *)
      PNP_USE_ESCD_SUPPORT                       = $8D;

      (* This return code indicates the message passed to the
         system BIOS through function 04h, Send Message, is not
         supported on the system                                *)
      PNP_MESSAGE_NOT_SUPPORTED                  = $8E;

      (* This return code indicates that the system BIOS detected
         a hardware failure                                       *)
      PNP_HARDWARE_ERROR                         = $8F;

      (* Error returned by PNP_BuildSysDevList if no system devices exist *)
      PNP_NO_SYSTEM_DEVICES_EXIST                = $90;

      (* Error returned by all functions if a PnP BIOS has not been detected *)
      PNP_BIOS_NOT_PRESENT                       = $91;

      (* Error returned by PnP ISA functions when an invalid serial ID is
         returned by the PnP ISA card                                    *)
      PNP_INVALID_SERIAL_ID                      = $92;

      (* Indicates insufficient memory to complete operation *)
      PNP_NO_BUFFER_MEMORY                       = $93;

      (* PCI error - invalid configuration mechanism *)
      PNP_INVALID_PCI_CONFIG                     = $94;

      (* PCI error - no PCI BIOS *)
      PNP_PCI_BIOS_NOT_PRESENT                   = $95;

      (* PCI error - bad vendor ID *)
      PNP_PCI_BAD_VENDOR_ID                      = $96;

      (* PCI error - device not found *)
      PNP_PCI_DEVICE_NOT_FOUND                   = $97;

      (* PCI error - bad register number *)
      PNP_PCI_INVALID_REGISTER                   = $98;


     {*** Small resource data type tags ***}

     PnP_Version_Num          = $01;
     Logical_Device_ID        = $02;
     Compatible_Device_ID     = $03;
     IRQ_Format               = $04;
     DMA_Format               = $05;
     Start_Dependent_Function = $06;
     End_Dependent_Function   = $07;
     IO_Port_Descriptor       = $08;
     Fixed_IO_Port_Descriptor = $09;
     Vendor_Defined           = $0E;
     End_Tag                  = $0F;

     {*** Large resource data type tags ***}

     Memory_Range_Descriptor   = $01;
     Identifier_String_ANSI    = $02;
     Identifier_String_Unicode = $03;
     Vendor_Defined_Large      = $04;
     Memory_Range_32Bit        = $05;
     Fixed_Memory_Range_32Bit  = $06;

     {*** PnP ISA constants ***}

const ISA_MIN_READ_PORT         = $0203; {The read data port is relocatable}
      ISA_MAX_READ_PORT         = $03FF; {within the address range 0203h-03FFh}

      ISA_READ_DATA_PORT : word = 0;      {ISA read port (variable)}
      ISA_ADDRESS_PORT          = $0279;  {ISA register address port}
      ISA_WRITE_DATA_PORT       = $0A79;  {ISA write data port}

      ISA_LAST_CSN : byte       = 0;      {Last card select number assigned}

      ISA_INITKEY_LENGTH        = 32;     {Length of initiation key in bytes}

      {*** Initiation key for PnP ISA cards ***}
      ISA_INITKEY_DATA : array[1..32] of byte = ($6A, $B5, $DA, $ED,
                                                 $F6, $FB, $7D, $BE,
                                                 $DF, $6F, $37, $1B,
                                                 $0D, $86, $C3, $61,
                                                 $B0, $58, $2C, $16,
                                                 $8B, $45, $A2, $D1,
                                                 $E8, $74, $3A, $9D,
                                                 $CE, $E7, $73, $39);

{*** Global variable used to call PnP BIOS functions ***}

var PnP_BIOS_Present : boolean;    {True if PnP BIOS exists}
    PnP_BIOS_Header  : TPnPHeader; {Holds PnP BIOS header structure}
    PnP_BIOS_Entry   : pointer;    {Holds PnP BIOS entry point}
    PnP_ISA_Present  : boolean;    {True if PnP ISA cards exist}
    PnP_ISA_Config   : TISAConfig; {Holds ISA read data port}
    PnP_PCI_Present  : boolean;    {True if PCI BIOS exists}
    PnP_PCI_Config   : byte;       {Stores configuration mechanism used by
                                    PCI system}


{******}

implementation

end.