unit SPNPUI;

(* Information
   

   Program Title : Plug and Play demo TurboVision user interface unit.
   External name : SPNPUI.TPU
   Version       : 1.1.
   Start date    : 15/09/1997.
   Last update   : 22/07/1999.
   Author        : Rob Anderton.
   Description   : A unit providing the user interface for the PnP demo.

*)

interface

{******}

uses App, Drivers, Objects, Views, Dialogs, ColorTxt, MsgBox, Menus,
     SPNP, SPNPTYPE, SUTILS, SPNPEXIT, SINI, SPNPOBJ;

{******}

type
     {*** Main dialogue ***}
     PMainDialog = ^TMainDialog;
     TMainDialog = object(TDialog)
                          PnPBIOSText : PColoredText;
                          PCIBIOSText : PColoredText;
                          PNPISAText  : PColoredText;

                          constructor Init;
                   end;

     {*** Application object ***}
     PApp = ^TApp;
     TApp = object(TApplication)

                   MainDlg : PMainDialog;

                   constructor Init;
                   procedure   InitDesktop; virtual;
                   procedure   HandleEvent(var Event : TEvent); virtual;
                   procedure   Run; virtual;
            end;


     {*** Desktop object ***}
     PDesk = ^TDesk;
     TDesk = object(TDesktop)
                    procedure InitBackground; virtual;
             end;

     {*** Background object ***}
     PBack = ^TBack;
     TBack = object(TBackground)
                    procedure   Draw; virtual;
             end;

     {*** 'No PnP BIOS' message dialogue ***}

     PBIOSMsgDialog = ^TBIOSMsgDialog;
     TBIOSMsgDialog = object(TDialog)
                             constructor Init;
                      end;

     {*** ISA Configuration Dialogue ***}

     PISAConfigDialog = ^TISAConfigDialog;
     TISAConfigDialog = object(TDialog)
                               NumCardsText : PColoredText;
                               ReadPortText : PColoredText;
                               PNPISAText   : PColoredText;

                               constructor Init;
                        end;

     {*** About Dialogue ***}
     PAboutDialog = ^TAboutDialog;
     TAboutDialog = object(TDialog)
                           constructor Init;
                    end;

     {*** Custom device object for listing ***}
     PDeviceObj = ^TDeviceObj;
     TDeviceObj = object(TObject)

                         DeviceNum  : word;
                         DeviceType : string;
                         DeviceID   : string;
                         VendorID   : string;
                         DeviceDesc : string;

                         constructor Init(wDeviceNum  : word;
                                          sDeviceType : string;
                                          sDeviceID   : string;
                                          sVendorID   : string;
                                          sDeviceDesc : string);

                         constructor Load(var S : TStream);

                         function    GetDeviceNum  : word;
                         function    GetDeviceType : string;
                         function    GetDeviceID   : string;
                         function    GetVendorID   : string;
                         function    GetDeviceDesc : string;

                         procedure   Store(var S : TStream);
                         destructor  Done; virtual;
                  end;

     {*** Custom device collection ***}

     PDeviceCollection = ^TDeviceCollection;
     TDeviceCollection = object(TCollection)

                                function DeviceNumAt(I : integer) : word;
                                function DeviceTypeAt(I : integer) : string;
                                function DeviceIDAt(I : integer) : string;
                                function VendorIDAt(I : integer) : string;
                                function DeviceDescAt(I : integer) : string;

                         end;

     {*** Custom device listbox scroller object ***}

     PDeviceListbox = ^TDeviceListbox;
     TDeviceListbox = object(TScroller)

                             DevList   : PDeviceCollection;
                             Highlight : longint;

                             constructor Init(var Bounds      : TRect;
                                                  AHScrollBar : PScrollBar;
                                                  AVScrollBar : PScrollBar);

                             procedure   Draw; virtual;

                             function    GetAttributes(L : longint) : word; virtual;

                             procedure   GetBuffer(    L : longint;
                                                   var T : TDrawBuffer); virtual;

                             function    GetText(L : longint) : string; virtual;

                             procedure   HandleEvent(var Event : TEvent); virtual;

                             procedure   NewList(AList : PDeviceCollection); virtual;
                      end;

     {*** Device list dialogue ***}

     PDeviceDialog = ^TDeviceDialog;
     TDeviceDialog = object(TDialog)

                            DeviceListBox : PDeviceListBox;

                            constructor Init;
                            procedure   BuildDeviceList;
                     end;

     {*** 'Please Wait' Dialog ***}

     PWaitDialog = ^TWaitDialog;
     TWaitDialog = object(TDialog)

                          ProgressText : PColoredText;
                          ProgressVal  : byte;

                          constructor Init;
                          procedure   Update;
                   end;

     {*** Device Information Dialog ***}
     PDeviceInfoDialog = ^TDeviceInfoDialog;
     TDeviceInfoDialog = object(TDialog)

                                DeviceNum      : word;

                                VendorNameText : PColoredText;
                                DeviceNameText : PColoredText;
                                DeviceTypeText : PColoredText;
                                BaseTypeText   : PColoredText;
                                SubTypeText    : PColoredText;
                                IFTypeText     : PColoredText;

                                constructor Init(wDeviceNum : word);
                                procedure   HandleEvent(var Event: TEvent); virtual;
                         end;

{*** Command constants ***}

const cmISAConfig    = 2000;
      cmDeviceList   = 2001;
      cmAbout        = 2002;

      cmIRQ          = 2003;
      cmDMA          = 2004;
      cmIOPort       = 2005;
      cmMem          = 2006;
      cmOther        = 2007;

{*** Device list ***}

const DeviceList : PDeviceCollection = nil;

{******}

implementation

{*** Application object ***}

constructor TApp.Init;

begin
     inherited Init;
     StatusLine^.Hide;
     MenuBar^.Hide;
end;

{******}

procedure TApp.InitDesktop;

var R : TRect;

begin
     GetExtent(R);
     Desktop:= New(PDesk, Init(R));
end;

{******}

procedure TApp.HandleEvent(var Event: TEvent);

begin
    inherited HandleEvent(Event);

    if Event.What and evMessage <> 0 then
       case Event.Command of

            cmISAConfig : begin
                               MainDlg^.Done;
                               ExecView(New(PISAConfigDialog, Init));
                               MainDlg:= New(PMainDialog, Init);
                               Insert(MainDlg);
                          end;

           cmDeviceList : begin
                               MainDlg^.Done;
                               ExecView(New(PDeviceDialog, Init));
                               MainDlg:= New(PMainDialog, Init);
                               Insert(MainDlg);
                          end;

                cmAbout : begin
                               MainDlg^.Done;
                               ExecView(New(PAboutDialog, Init));
                               MainDlg:= New(PMainDialog, Init);
                               Insert(MainDlg);
                          end;

       end;
end;

{******}

procedure TApp.Run;

begin
    if PnP_BIOS_Present = false then ExecView(New(PBIOSMsgDialog, Init))
                                else
                                begin
                                     MainDlg:= New(PMainDialog, Init);
                                     Insert(MainDlg);
                                     inherited Run;
                                end;
end;

{*** Desktop object ***}

procedure TDesk.InitBackground;

var R : TRect;

begin
     GetExtent(R);
     Options:= Options and not ofSelectable;
     Background:= New(PBack, Init(R, ' '));
end;

{*** Background object ***}

procedure TBack.Draw;

var I    : integer;
    Buf  : TDrawBuffer;

begin
     for I:= 0 to Size.Y - 1 do
     begin
          MoveChar(Buf, '', 1, Size.X);
          WriteBuf(0, I, Size.X, 1, Buf);
     end;
end;

{*** 'No PnP BIOS' message dialogue ***}

constructor TBIOSMsgDialog.Init;

var R       : TRect;
    Control : PView;

begin
     R.Assign(17, 6, 62, 17);
     inherited Init(R, 'Plug and Play Demo');
     Options:= Options or ofCenterX or ofCenterY;
     Palette:= dpBlueDialog;
     Flags:= Flags and not wfClose;

     R.Assign(3, 2, 42, 7);
     Control:= New(PColoredText, Init(R, 'A Plug and Play BIOS was not found.'^M+
                                         ''^M+
                                         'The Plug and Play Demo cannot continue.'^M+
                                         ''^M+
                                         'Click OK to exit.', $1B));
     Insert(Control);

     R.Assign(17, 8, 27, 10);
     Control:= New(PButton, Init(R, 'O~K~', cmOK, bfDefault));
     Insert(Control);

     SelectNext(False);
end;

{*** Main dialogue ***}

constructor TMainDialog.Init;

const BoolArr : array[FALSE..TRUE] of string = ('not present', 'present');

var R       : TRect;
    Control : PView;

begin
     R.Assign(11, 0, 69, 22);
     inherited Init(R, 'Plug and Play Demo');
     Options:= Options or ofCenterX or ofCenterY;
     Palette:= dpBlueDialog;
     Flags:= Flags and not wfClose;

     R.Assign(45, 19, 55, 21);
     Control:= New(PButton, Init(R, 'E~x~it', cmQuit, bfDefault));
     Insert(Control);

     R.Assign(3, 2, 55, 8);
     Control:= New(PColoredText, Init(R, ' System information', $1A));
     Control^.Options:= Control^.Options or ofFramed;
     Insert(Control);

     R.Assign(6, 4, 28, 5);
     Control:= New(PStaticText, Init(R, 'Plug and Play support'));
     Insert(Control);

     R.Assign(6, 5, 27, 6);
     Control:= New(PStaticText, Init(R, 'PCI BIOS support'));
     Insert(Control);

     R.Assign(6, 6, 32, 7);
     Control:= New(PStaticText, Init(R, 'Plug and Play ISA support'));
     Insert(Control);

     R.Assign(34, 4, 45, 5);
     PnPBIOSText:= New(PColoredText, Init(R, BoolArr[PnP_BIOS_Present], $1B));
     Insert(PnPBIOSText);

     R.Assign(34, 5, 45, 6);
     PCIBIOSText:= New(PColoredText, Init(R, BoolArr[PnP_PCI_Present], $1B));
     Insert(PCIBIOSText);

     R.Assign(34, 6, 45, 7);
     PNPISAText:= New(PColoredText, Init(R, BoolArr[PnP_ISA_Present], $1B));
     Insert(PNPISAText);

     R.Assign(3, 10, 55, 17);
     Control:= New(PStaticText, Init(R, ''));
     Control^.Options:= Control^.Options or ofFramed;
     Insert(Control);

     R.Assign(4, 11, 25, 13);
     Control:= New(PButton, Init(R, '~I~SA configuration', cmISAConfig, bfNormal));
     Insert(Control);

     R.Assign(27, 11, 53, 13);
     Control:= New(PColoredText, Init(R, 'View Plug and Play ISA'^M+
                                         'configuration information.', $1C));
     Insert(Control);

     R.Assign(4, 14, 25, 16);
     Control:= New(PButton, Init(R, '~D~evice list', cmDeviceList, bfNormal));
     Insert(Control);

     R.Assign(27, 14, 54, 16);
     Control:= New(PColoredText, Init(R, 'View configuration details'^M+
                                         'for all detected devices.', $1C));
     Insert(Control);

     R.Assign(32, 19, 43, 21);
     Control:= New(PButton, Init(R, '~A~bout', cmAbout, bfNormal));
     Insert(Control);

     SelectNext(False);
end;

{*** ISA Configuration Dialogue }

constructor TISAConfigDialog.Init;

const BoolArr : array[FALSE..TRUE] of string = ('not present', 'present');

var R       : TRect;
    Control : PView;
    Msg     : string;

begin
     R.Assign(14, 4, 65, 18);
     inherited Init(R, 'Plug and Play Demo');
     Options:= Options or ofCenterX or ofCenterY;
     Palette:= dpBlueDialog;
     Flags:= Flags and not wfClose;

     R.Assign(21, 11, 31, 13);
     Control:= New(PButton, Init(R, '~D~one', cmOK, bfDefault));
     Insert(Control);

     R.Assign(3, 3, 48, 9);
     Control:= New(PColoredText, Init(R, ' ISA configuration information', $1A));
     Control^.Options:= Control^.Options or ofFramed;
     Insert(Control);

     R.Assign(6, 6, 28, 7);
     Control:= New(PStaticText, Init(R, 'ISA read data port'));
     Insert(Control);

     R.Assign(6, 7, 30, 8);
     Control:= New(PStaticText, Init(R, 'Number of PnP ISA cards'));
     Insert(Control);

     R.Assign(6, 5, 32, 6);
     Control:= New(PStaticText, Init(R, 'Plug and Play ISA support'));
     Insert(Control);

     R.Assign(34, 7, 45, 8);
     NumCardsText:= New(PColoredText, Init(R, U_IntToStr(ISA_LAST_CSN), $1B));
     Insert(NumCardsText);

     Msg:= U_WordToHex(PnP_ISA_Config.ReadPort, true);
     Msg:= Msg + 'h';
     R.Assign(34, 6, 45, 7);
     ReadPortText:= New(PColoredText, Init(R, Msg, $1B));
     Insert(ReadPortText);

     R.Assign(34, 5, 45, 6);
     PNPISAText:= New(PColoredText, Init(R, BoolArr[PnP_ISA_Present], $1B));
     Insert(PNPISAText);

     SelectNext(False);
end;

{*** About Dialogue ***}

constructor TAboutDialog.Init;

var R       : TRect;
    Control : PView;

begin
     R.Assign(20, 5, 59, 17);
     inherited Init(R, '');
     Options:= Options or ofCenterX or ofCenterY;
     Palette:= dpBlueDialog;
     Flags:= Flags and not wfClose;

     R.Assign(15, 9, 25, 11);
     Control:= New(PButton, Init(R, '~D~one', cmOK, bfDefault));
     Insert(Control);

     R.Assign(3, 2, 36, 3);
     Control:= New(PColoredText, Init(R, 'The S Library', $1B));
     Insert(Control);

     R.Assign(3, 3, 36, 4);
     Control:= New(PColoredText, Init(R, 'Plug and Play Package', $1A));
     Insert(Control);

     R.Assign(3, 4, 36, 5);
     Control:= New(PColoredText, Init(R, 'Version 1.0', $1C));
     Insert(Control);

     R.Assign(3, 6, 36, 7);
     Control:= New(PColoredText, Init(R, '(c) Copyright 1997 Rob Anderton', $1F));
     Insert(Control);

     SelectNext(False);
end;

{*** Device list dialogue ***}

constructor TDeviceDialog.Init;

var R          : TRect;
    Control    : PView;
    DevList    : PDeviceListbox;
    VScroll    : PScrollBar;
    HScroll    : PScrollBar;

begin
     R.Assign(12, 1, 67, 21);
     inherited Init(R, 'Plug and Play Demo');
     Options:= Options or ofCenterX or ofCenterY;
     Palette:= dpBlueDialog;
     Flags:= Flags and not wfClose;

     R.Assign(22, 17, 32, 19);
     Control:= New(PButton, Init(R, '~D~one', cmOK, bfnORMAL));
     Insert(Control);

     R.Assign(3, 3, 52, 15);
     Control:= New(PColoredText, Init(R, ' Device information', $1A));
     Control^.Options:= Control^.Options or ofFramed;
     Insert(Control);

     R.Assign(48, 5, 49, 13);
     VScroll:= New(PScrollBar, Init(R));
     Insert(VScroll);

     R.Assign(6, 13, 48, 14);
     HScroll:= New(PScrollBar, Init(R));
     Insert(HScroll);

     R.Assign(6, 5, 48, 13);
     DeviceListbox:= New(PDeviceListBox, Init(R, HScroll, VScroll));
     Insert(DeviceListBox);

     if DeviceList = nil then BuildDeviceList
                         else DeviceListBox^.NewList(DeviceList);

     SelectNext(False);
end;

{******}

procedure TDeviceDialog.BuildDeviceList;

var DeviceNum  : word;

    DeviceID   : string;
    VendorID   : string;
    DeviceType : string;
    PCIIndex   : string;
    PCIDesc    : string;

    WaitDlg    : PWaitDialog;

    InfoFile   : TResourceFile;

    ISADevice  : PISADevice;
    PCIDevice  : PPCIDevice;

begin
     InfoFile.Init(New(PDosStream, Init(PNP_DEVICELIST_FILENAME + '.DAT',
                                        stOpenRead)));

     WaitDlg:= New(PWaitDialog, Init);
     Desktop^.Insert(WaitDlg);

     DeviceList:= New(PDeviceCollection, Init(1, 1));
     INI_LoadComments:= false;

     DeviceNum:= 0;
     repeat
        WaitDlg^.Update;
        INI_GetProfileString(PNP_CONFIG_FILENAME,
                             'DEVICE_' + U_IntToStr(DeviceNum),
                             'DEVICE_TYPE', DeviceType, 'NONE');
        WaitDlg^.Update;
        if DeviceType <> 'NONE' then
           if DeviceType = 'SYSTEM' then
           begin
              WaitDlg^.Update;

              INI_GetProfileString(PNP_CONFIG_FILENAME,
                                   'DEVICE_' + U_IntToStr(DeviceNum),
                                   'DEVICE_ID', DeviceID, 'NONE');

              WaitDlg^.Update;

              if DeviceID <> 'NONE' then
              begin
                 WaitDlg^.Update;

                 ISADevice:= nil;
                 ISADevice:= PISADevice(InfoFile.Get(DeviceID));
                 WaitDlg^.Update;

                 if (ISADevice = nil) then
                    DeviceList^.Insert(New(PDeviceObj, Init(DeviceNum,
                                                            DeviceType,
                                                            DeviceID,
                                                            'FFFF',
                                                            'Unknown device')))
                 else
                 begin
                    DeviceList^.Insert(New(PDeviceObj, Init(DeviceNum,
                                                            DeviceType,
                                                            DeviceID,
                                                            'FFFF',
                                                            ISADevice^.DeviceDesc^)));
                    Dispose(ISADevice, Done);
                 end;
              end;
           end
           else
            if (DeviceType = 'ISAPNP') or (DeviceType = 'ISAPNPLOGICAL') then
            begin
               WaitDlg^.Update;

               INI_GetProfileString(PNP_CONFIG_FILENAME,
                                    'DEVICE_' + U_IntToStr(DeviceNum),
                                    'DEVICE_ID', DeviceID, 'NONE');

               WaitDlg^.Update;

               if DeviceID <> 'NONE' then
               begin
                  WaitDlg^.Update;

                  ISADevice:= nil;
                  ISADevice:= PISADevice(InfoFile.Get(DeviceID));
                  WaitDlg^.Update;

                  if (ISADevice = nil) then
                     DeviceList^.Insert(New(PDeviceObj, Init(DeviceNum,
                                                             DeviceType,
                                                             DeviceID,
                                                             'FFFF',
                                                             'Unknown device')))
                  else
                  begin
                     DeviceList^.Insert(New(PDeviceObj, Init(DeviceNum,
                                                             DeviceType,
                                                             DeviceID,
                                                             'FFFF',
                                                             ISADevice^.DeviceDesc^)));
                     Dispose(ISADevice, Done);
                  end;
               end;
            end
            else
              if (DeviceType = 'PCI') then
              begin
                WaitDlg^.Update;

                INI_GetProfileString(PNP_CONFIG_FILENAME,
                                     'DEVICE_' + U_IntToStr(DeviceNum),
                                     'DEVICE_ID', DeviceID, 'NONE');

                INI_GetProfileString(PNP_CONFIG_FILENAME,
                                     'DEVICE_' + U_IntToStr(DeviceNum),
                                     'VENDOR_ID', VendorID, 'NONE');

                WaitDlg^.Update;

                if (VendorID <> 'NONE') then
                begin
                   WaitDlg^.Update;

                   PCIIndex:= 'PCI_' + VendorID + '_';

                   if DeviceID = 'NONE' then PCIIndex:= PCIIndex + 'XXXX'
                                        else PCIIndex:= PCIIndex + DeviceID;

                   PCIDevice:= nil;
                   PCIDevice:= PPCIDevice(InfoFile.Get(PCIIndex));
                   WaitDlg^.Update;

                   if (PCIDevice = nil) then
                      DeviceList^.Insert(New(PDeviceObj, Init(DeviceNum,
                                                              DeviceType,
                                                              DeviceID,
                                                              VendorID,
                                                              'Unknown device')))
                   else
                   begin
                      PCIDesc:= PCIDevice^.MfgName^ + ' ' +
                                PCIDevice^.DeviceName^ + ' ' +
                                PCIDevice^.DeviceDesc^;

                      DeviceList^.Insert(New(PDeviceObj, Init(DeviceNum,
                                                              DeviceType,
                                                              DeviceID,
                                                              VendorID,
                                                              PCIDesc)));
                      Dispose(PCIDevice, Done);
                   end;
                end;
              end;


           Inc(DeviceNum);
           WaitDlg^.Update;
     until DeviceType = 'NONE';

     WaitDlg^.Done;
     DeviceListBox^.NewList(DeviceList);
     InfoFile.Done;
end;

{*** 'Please Wait' Dialog ***}

constructor TWaitDialog.Init;

var R       : TRect;
    Control : PView;

begin
     R.Assign(24, 7, 55, 15);
     inherited Init(R, '');
     Options:= Options or ofCenterX or ofCenterY;
     Palette:= dpBlueDialog;
     Flags:= Flags and not wfClose;

     R.Assign(3, 2, 28, 3);
     Control:= New(PColoredText, Init(R, 'Building device list...', $1B));
     Insert(Control);

     R.Assign(4, 3, 27, 4);
     Control:= New(PColoredText, Init(R, 'Please wait.', $9F));
     Insert(Control);

     R.Assign(3, 5, 28, 6);
     ProgressText:= New(PColoredText, Init(R, '', $1A));
     Insert(ProgressText);
     ProgressVal:= 0;

     SelectNext(False);
end;

{******}

procedure TWaitDialog.Update;

var ProgressStr : string;
    Loop        : word;

begin
     Inc(ProgressVal);
     if ProgressVal > 25 then ProgressVal:= 1;
     ProgressStr:= '';

     for Loop:= 1 to ProgressVal do
         ProgressStr:= ProgressStr + '';

     DisposeStr(ProgressText^.Text);
     ProgressText^.Text:= NewStr(ProgressStr);
     ProgressText^.Draw;
end;

{*** Device object ***}

constructor TDeviceObj.Init(wDeviceNum  : word;
                            sDeviceType : string;
                            sDeviceID   : string;
                            sVendorID   : string;
                            sDeviceDesc : string);

begin
     inherited Init;

     DeviceNum:= wDeviceNum;
     DeviceType:= sDeviceType;
     DeviceID:= sDeviceID;
     VendorID:= sVendorID;
     DeviceDesc:= sDeviceDesc;
end;

{******}

constructor TDeviceObj.Load(var S : TStream);

begin
     Abstract;
end;

{******}

function TDeviceObj.GetDeviceNum : word;

begin
     GetDeviceNum:= DeviceNum;
end;

{******}

function TDeviceObj.GetDeviceType : string;

begin
     GetDeviceType:= DeviceType;
end;

{******}

function TDeviceObj.GetDeviceID : string;

begin
     GetDeviceID:= DeviceID;
end;

{******}

function TDeviceObj.GetVendorID : string;

begin
     GetVendorID:= VendorID;
end;

{******}

function TDeviceObj.GetDeviceDesc : string;

begin
     GetDeviceDesc:= DeviceDesc;
end;

{******}

procedure TDeviceObj.Store(var S : TStream);

begin
     Abstract;
end;

{******}

destructor TDeviceObj.Done;

begin
     inherited Done;
end;

{*** Device collection object ***}

function TDeviceCollection.DeviceNumAt(I : integer) : word;

begin
     DeviceNumAt:= PDeviceObj(At(I))^.GetDeviceNum;
end;

{******}

function TDeviceCollection.DeviceTypeAt(I : integer) : string;

begin
     DeviceTypeAt:= PDeviceObj(At(I))^.GetDeviceType;
end;

{******}

function TDeviceCollection.DeviceIDAt(I : integer) : string;

begin
     DeviceIDAt:= PDeviceObj(At(I))^.GetDeviceID;
end;

{******}

function TDeviceCollection.VendorIDAt(I : integer) : string;

begin
     VendorIDAt:= PDeviceObj(At(I))^.GetVendorID;
end;

{******}

function TDeviceCollection.DeviceDescAt(I : integer) : string;

begin
     DeviceDescAt:= PDeviceObj(At(I))^.GetDeviceDesc;
end;

{*** Device Listbox ***}

constructor TDeviceListbox.Init(var Bounds      : TRect;
                                    AHScrollBar : PScrollBar;
                                    AVScrollBar : PScrollBar);

begin
     inherited Init(Bounds, AHScrollBar, AVScrollBar);

     if AHScrollBar <> nil then with AHScrollBar^ do
     begin
          Options:= Options and not ofPreProcess;
          Options:= Options or ofPostProcess;
     end;

     if AVScrollBar <> nil then with AVScrollBar^ do
     begin
          Options:= Options and not ofPreProcess;
          Options:= Options or ofPostProcess;
     end;

     Highlight:= -1;
     DevList:= nil;
end;

{******}

procedure TDeviceListBox.Draw;

var Buffer : TDrawBuffer;
    Y      : integer;

begin
     for Y:= 0 to Size.Y - 1 do
     begin
          GetBuffer(Y + Delta.Y, Buffer);
          WriteBuf(0, Y, Size.X, 1, Buffer);
     end;
end;

{******}

function TDeviceListbox.GetAttributes(L : longint) : word;

begin
     if (L <> Highlight) then GetAttributes:= $30
                         else GetAttributes:= $5F;
end;

{******}

procedure TDeviceListbox.GetBuffer(    L : longint;
                                   var T : TDrawBuffer);

var S : string;

begin
     S:= GetText(L);
     System.Delete(S, 1, Delta.X);

     while Length(S) < Size.X do S:= S + ' ';
     while Length(S) > Size.X do Delete(S, Length(S), 1);

     MoveCStr(T, S, GetAttributes(L));
end;

{******}

function TDeviceListbox.GetText(L : longint) : string;

begin
     if DevList = nil then GetText:= ''
                      else GetText:= DevList^.DeviceDescAt(L);
end;

{******}

procedure TDeviceListbox.HandleEvent(var Event : TEvent);

var OH       : longint;
    MouseLoc : TPoint;
    DevSel   : boolean;

begin
     OH:= Highlight;
     DevSel:= false;

     if (Event.What and evKeyDown) <> 0 then
     begin
          case Event.KeyCode of

               kbUp       : Dec(Highlight);
               kbDown     : Inc(Highlight);
               kbPgUp     : Dec(Highlight, Size.Y - 1);
               kbPgDn     : Inc(Highlight, Size.Y - 1);
               kbCtrlPgUp : Highlight:= 0;
               kbCtrlPgDn : Highlight:= Limit.Y - 1;
               kbEnter    : DevSel:= true;
          end;

          if Highlight < 0 then Highlight:= 0;
          if Highlight > Limit.Y then Highlight:= Limit.Y - 1;

          if OH <> Highlight then
          begin
               if (Highlight >= Delta.Y) and (Highlight < Delta.Y + Size.Y) then
                   ClearEvent(Event)
               else
               begin
                    if Highlight < Delta.Y then ScrollTo(Delta.X, Highlight)
                                           else ScrollTo(Delta.X, (Highlight - Size.Y) + 1);
                    ClearEvent(Event);
               end;
          end;
     end
     else
       if (Event.What and evMouseDown) <> 0 then
       begin
            if (State and sfSelected) = 0 then Select;
            MakeLocal(Event.Where, MouseLoc);
            Highlight:= MouseLoc.Y + Delta.Y;
            if Event.Double then DevSel:= true;
            ClearEvent(Event);
       end;

     if Event.What = evNothing then DrawView
                               else inherited HandleEvent(Event);

     OH:= Highlight;
     if Highlight < Delta.Y then Highlight:= Delta.Y;
     if Highlight >= Delta.Y + Size.Y then Highlight:= Delta.Y + Size.Y - 1;
     if OH <> Highlight then DrawView;

     if DevSel then
     begin
          Application^.Current^.Hide;
          Desktop^.ExecView(New(PDeviceInfoDialog, Init(Highlight)));
          Application^.Current^.Show;
     end;
end;

{******}

procedure TDeviceListbox.NewList(AList : PDeviceCollection);

begin
     if DevList <> nil then DevList^.FreeAll;
     DevList:= nil;

     if AList <> nil then
     begin
          DevList:= AList;
          SetLimit(255, AList^.Count);
          DrawView;
     end;
end;

{*** Device Information Dialog ***}

constructor TDeviceInfoDialog.Init(wDeviceNum : word);

var R        : TRect;
    Control  : PView;
    BaseType : integer;
    SubType  : integer;
    IFType   : integer;

begin
     R.Assign(3, 2, 77, 20);
     inherited Init(R, 'Plug and Play Demo');
     Options:= Options or ofCenterX or ofCenterY;
     Palette:= dpBlueDialog;
     Flags:= Flags and not wfClose;
     DeviceNum:= wDeviceNum;

     R.Assign(3, 3, 71, 13);
     Control:= New(PColoredText, Init(R, ' Device information', $1A));
     Control^.Options:= Control^.Options or ofFramed;
     Insert(Control);

     R.Assign(6, 5, 17, 6);
     Control:= New(PStaticText, Init(R, 'Device name'));
     Insert(Control);

     R.Assign(19, 5, 69, 6);
     DeviceNameText:= New(PColoredText, Init(R,
                          PDeviceObj(DeviceList^.At(DeviceNum))^.GetDeviceDesc,
                          $1B));
     Insert(DeviceNameText);

     R.Assign(6, 7, 17, 8);
     Control:= New(PStaticText, Init(R, 'Device type'));
     Insert(Control);

     R.Assign(19, 7, 30, 8);
     DeviceTypeText:= New(PColoredText, Init(R, PDeviceObj(DeviceList^.At(DeviceNum))^.GetDeviceType,
                                             $1B));
     Insert(DeviceTypeText);

     INI_GetProfileInt(PNP_CONFIG_FILENAME, 'DEVICE_' + U_IntToStr(DeviceNum),
                       'DEVICE_BASETYPE', BaseType, 0);

     R.Assign(19, 8, 69, 9);
     BaseTypeText:= New(PColoredText, Init(R, PnP_GetBaseTypeDesc(BaseType), $1B));
     Insert(BaseTypeText);

     INI_GetProfileInt(PNP_CONFIG_FILENAME, 'DEVICE_' + U_IntToStr(DeviceNum),
                       'DEVICE_SUBTYPE', SubType, 0);

     R.Assign(19, 9, 69, 10);
     SubTypeText:= New(PColoredText, Init(R, PnP_GetSubTypeDesc(BaseType, SubType), $1B));
     Insert(SubTypeText);

     INI_GetProfileInt(PNP_CONFIG_FILENAME, 'DEVICE_' + U_IntToStr(DeviceNum),
                       'DEVICE_IFTYPE', IFType, 0);

     R.Assign(19, 10, 69, 11);
     IFTypeText:= New(PColoredText, Init(R, PnP_GetIFTypeDesc(BaseType, SubType, IFType), $1B));
     Insert(IFTypeText);

     R.Assign(2, 15, 13, 17);
     Control:= New(PButton, Init(R, 'IR~Q~', cmIRQ, bfNormal));
     Insert(Control);

     R.Assign(14, 15, 25, 17);
     Control:= New(PButton, Init(R, 'DM~A~', cmDMA, bfNormal));
     Insert(Control);

     R.Assign(26, 15, 37, 17);
     Control:= New(PButton, Init(R, '~I~O port', cmIOPort, bfNormal));
     Insert(Control);

     R.Assign(38, 15, 48, 17);
     Control:= New(PButton, Init(R, '~M~emory', cmMem, bfNormal));
     Insert(Control);

     R.Assign(49, 15, 60, 17);
     Control:= New(PButton, Init(R, '~O~ther', cmOther, bfNormal));
     Insert(Control);

     R.Assign(61, 15, 71, 17);
     Control:= New(PButton, Init(R, '~D~one', cmOK, bfNormal));
     Insert(Control);

     SelectNext(False);
end;

{******}

procedure TDeviceInfoDialog.HandleEvent(var Event: TEvent);

begin
     (*---
     if Event.What and evMessage <> 0 then
        case Event.Command of
        end;    --*)

     inherited HandleEvent(Event);

     (*---
     if Event.What and evMessage <> 0 then
        case Event.Command of
     end;    --*)
end;

{******}

end.
