unit SCDUI;

(* Information
   

   Program Title : CD-ROM demo TurboVision user interface unit.
   External name : SCDUI.TPU
   Version       : 1.0.
   Start date    : 31/8/97
   Last update   : 31/8/97.
   Author        : Rob Anderton.
   Description   : A unit providing the user interface for the CD player demo.
*)

interface

{******}

uses App, Drivers, Objects, Views, Dialogs, ColorTxt, SCDROM, SUTILS;

{*** Application object ***}

type PCDPlayerApp = ^TCDPlayerApp;
     TCDPlayerApp = object(TApplication)
                          constructor Init;
                          procedure   InitDesktop; virtual;
                          procedure   Run; virtual;
                    end;

{*** Desktop object ***}

type PCDPlayerDesktop = ^TCDPlayerDesktop;
     TCDPlayerDesktop = object(TDesktop)
                              procedure InitBackground; virtual;
                        end;

{*** Background object ***}

type PCDPlayerBackground = ^TCDPlayerBackground;
     TCDPlayerBackground = object(TBackground)
                                 procedure   Draw; virtual;
                           end;

{*** Dialog object ***}

type PCDPlayer = ^TCDPlayer;
     TCDPlayer = object(TDialog)
                        CD          : TCDROMDrive;
                        Track       : byte;
                        TrackNum    : PColoredText;
                        TrackTime   : PColoredText;
                        TrackStatus : PColoredText;

                        constructor Init;
                        procedure   HandleEvent(var Event : TEvent); virtual;
                        destructor  Done; virtual;
                 end;

{******}

implementation

{*** Constants ***}

const cmOpenCDPlayer = 1000;

      cmPlay    = 1001;
      cmPause   = 1002;
      cmEject   = 1003;

{******}

constructor TCDPlayerApp.Init;

begin
     inherited Init;
     StatusLine^.Hide;
     MenuBar^.Hide;
end;

{******}

procedure TCDPlayerApp.InitDesktop;

var R : TRect;

begin
     GetExtent(R);
     Desktop:= New(PCDPlayerDesktop, Init(R));
end;

{******}

procedure TCDPlayerApp.Run;

begin
     Desktop^.ExecView(New(PCDPlayer, Init));
end;

{******}

procedure TCDPlayerDesktop.InitBackground;

var R : TRect;

begin
     GetExtent(R);
     Background:= New(PCDPlayerBackground, Init(R, ' '));
end;

{******}

procedure TCDPlayerBackground.Draw;

var I    : integer;
    Buf  : TDrawBuffer;

begin
     for I:= 0 to Size.Y - 1 do
     begin
          MoveChar(Buf, #13, 1, Size.X);
          WriteBuf(0, I, Size.X, 1, Buf);
     end;
end;
          
{******}

constructor TCDPlayer.Init;

var R       : TRect;
    Control : PView;

begin
     R.Assign(3, 2, 62, 12);
     inherited Init(R, 'CD Player');
     Options:= Options or ofCentered;
     Flags:= Flags and not wfMove;

     R.Assign(45, 4, 57, 6);
     Control:= New(PButton, Init(R, 'E~x~it', cmCancel, bfNormal));
     Insert(Control);

     R.Assign(45, 2, 57, 4);
     Control:= New(PButton, Init(R, '~A~bout', cmHelp, bfNormal));
     Insert(Control);

     R.Assign(3, 2, 44, 6);
     Control:= New(PColoredText, Init(R, 'Track', $0A));
     Control^.Options := Control^.Options or ofFramed;
     Insert(Control);

     R.Assign(13, 2, 17, 3);
     Control:= New(PColoredText, Init(R, 'Time', $0A));
     Insert(Control);

     R.Assign(13, 5, 18, 6);
     Control:= New(PColoredText, Init(R, 'track', $0B));
     Insert(Control);

     R.Assign(21, 5, 26, 6);
     Control:= New(PColoredText, Init(R, 'total', $0B));
     Insert(Control);


     R.Assign(36, 2, 43, 3);
     Control:= New(PColoredText, Init(R, 'Status', $0A));
     Insert(Control);

     R.Assign(3, 4, 8, 5);
     TrackNum:= New(PColoredText, Init(R, '', $0E));
     Insert(TrackNum);

     R.Assign(13, 4, 32, 5);
     TrackTime:= New(PColoredText, Init(R, '', $0F));
     Insert(TrackTime);

     R.Assign(36, 4, 43, 5);
     TrackStatus:= New(PColoredText, Init(R, '', $8E));
     Insert(TrackStatus);

     R.Assign(2, 7, 13, 9);
     Control:= New(PButton, Init(R, #16, cmPlay, bfNormal));
     Insert(Control);

     R.Assign(23, 7, 34, 9);
     Control:= New(PButton, Init(R, #254, cmPause, bfNormal));
     Insert(Control);

     R.Assign(34, 7, 45, 9);
     Control:= New(PButton, Init(R, #30, cmEject, bfNormal));
     Insert(Control);

     R.Assign(18, 7, 23, 9);
     Control:= New(PButton, Init(R, #175, cmNext, bfNormal));
     Insert(Control);

     R.Assign(13, 7, 18, 9);
     Control:= New(PButton, Init(R, #174, cmPrev, bfNormal));
     Insert(Control);

     SelectNext(False);

     CD.Init('G');
     Track:= 1;
     DisposeStr(TrackNum^.Text);
     TrackNum^.Text:= NewStr(#3 + U_IntToStr(Track));
     TrackNum^.Draw;

     DisposeStr(TrackStatus^.Text);
     TrackStatus^.Text:= NewStr('stopped');
     TrackStatus^.Draw;
end;

{******}

procedure TCDPlayer.HandleEvent(var Event: TEvent);

function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;

var PosInfo : TCDROMPositionInfo;

begin
     if Event.What and evMessage <> 0 then
        case Event.Command of
             cmPlay  : begin
                            CD.PlayTrack(Track);
                            DisposeStr(TrackStatus^.Text);
                            TrackStatus^.Text:= NewStr('playing');
                            TrackStatus^.Draw;
                       end;
             cmPrev  : begin
                            Dec(Track);
                            if Track < CD.GetFirstTrack then Track:= CD.GetFirstTrack;
                            DisposeStr(TrackNum^.Text);
                            TrackNum^.Text:= NewStr(#3 + U_IntToStr(Track));
                            TrackNum^.Draw;
                       end;
             cmNext  : begin
                            Inc(Track);
                            if Track > CD.GetLastTrack then Track:= CD.GetLastTrack;
                            DisposeStr(TrackNum^.Text);
                            TrackNum^.Text:= NewStr(#3 + U_IntToStr(Track));
                            TrackNum^.Draw;
                       end;
             cmPause : begin
                            CD.PausePlay;
                            DisposeStr(TrackStatus^.Text);
                            TrackStatus^.Text:= NewStr('stopped');
                            TrackStatus^.Draw;
                       end;
             cmEject : CD.OpenDoor;
        end;

     inherited HandleEvent(Event);

     CD.GetPosition(PosInfo);
     DisposeStr(TrackTime^.Text);
     with PosInfo do
          TrackTime^.Text:= NewStr(LeadingZero(TrackInfo.Minute) + ':' +
                                   LeadingZero(TrackInfo.Second) + '   ' +
                                   LeadingZero(TotalInfo.Minute) + ':' +
                                   LeadingZero(TotalInfo.Second));
     TrackTime^.Draw;

end;

{******}

destructor TCDPlayer.Done;

begin
     CD.Done;
     inherited Done;
end;

{******}

end.
