UNIT VgaPro;

INTERFACE

USES Graph,   {VGA output}
     Crt,     {SVGA driver dependency}
     Drivers, {EGA/VGA driver}
     KeyPro,  {Keyboard input}
     NumPro;  {Number utilities}

PROCEDURE InitGraphics(video: String);
PROCEDURE ExitGraphics;
PROCEDURE ShowMessageBox(cap, msg: String);
FUNCTION ShowQuestion(cap, msg: String): Boolean;
FUNCTION EditSignedWordValue(old: Word; cap: String; isNeg: Boolean): Word;
FUNCTION EditWordValue(old: Word; cap: String): Word;
FUNCTION EditString(old: String; cap: String; max: Integer): String;
FUNCTION EditColorByteValue(old: Byte; cap: String): Byte;

IMPLEMENTATION

PROCEDURE EGAVGADriverProc; EXTERNAL;
{$L EGAVGA.OBJ}

VAR regVGADriver: Boolean;

TYPE
  RGBRec = record
    R, G, B: Integer; { Intensity values (values from 0 to 63) }
END;

CONST SVGA256mode : Integer = 2;
  { 0 = 320x200x256    1 = 640x400x256    2 = 640x480x256
    3 = 800x600x256    4 = 1024x768x256   5 = 640x350x256
    6 = 1280x1024x256  }

CONST
     { Table of game's color pallete }
     GameColors : array[0..255] of RGBRec = (
        (R:0;G:0;B:0),
	(R:0;G:0;B:42),
	(R:0;G:42;B:0),
	(R:0;G:42;B:42),
	(R:42;G:0;B:0),
	(R:42;G:0;B:42),
	(R:40;G:40;B:40),
	(R:42;G:42;B:42),
	(R:21;G:21;B:21),
	(R:21;G:21;B:63),
	(R:21;G:63;B:21),
	(R:21;G:63;B:63),
	(R:63;G:21;B:21),
	(R:63;G:21;B:63),
	(R:63;G:63;B:21),
	(R:63;G:63;B:63),
	(R:63;G:63;B:63),
	(R:55;G:55;B:55),
	(R:51;G:51;B:51),
	(R:48;G:48;B:48),
	(R:44;G:44;B:44),
	(R:41;G:41;B:41),
	(R:38;G:38;B:38),
	(R:34;G:34;B:34),
	(R:31;G:31;B:31),
	(R:28;G:28;B:28),
	(R:24;G:24;B:24),
	(R:21;G:21;B:21),
	(R:18;G:18;B:18),
	(R:14;G:14;B:14),
	(R:11;G:11;B:11),
	(R:8;G:8;B:8),
	(R:63;G:54;B:54),
	(R:63;G:46;B:46),
	(R:63;G:39;B:39),
	(R:63;G:31;B:31),
	(R:63;G:23;B:23),
	(R:63;G:16;B:16),
	(R:63;G:8;B:8),
	(R:63;G:0;B:0),
	(R:57;G:0;B:0),
	(R:51;G:0;B:0),
	(R:45;G:0;B:0),
	(R:39;G:0;B:0),
	(R:33;G:0;B:0),
	(R:28;G:0;B:0),
	(R:22;G:0;B:0),
	(R:16;G:0;B:0),
	(R:63;G:58;B:54),
	(R:63;G:55;B:48),
	(R:63;G:53;B:43),
	(R:63;G:50;B:37),
	(R:63;G:48;B:32),
	(R:63;G:46;B:26),
	(R:63;G:43;B:21),
	(R:63;G:41;B:15),
	(R:63;G:39;B:10),
	(R:56;G:34;B:8),
	(R:49;G:30;B:7),
	(R:42;G:25;B:5),
	(R:36;G:21;B:4),
	(R:29;G:16;B:2),
	(R:22;G:12;B:1),
	(R:16;G:8;B:0),
	(R:63;G:63;B:54),
	(R:63;G:63;B:46),
	(R:63;G:63;B:39),
	(R:63;G:63;B:31),
	(R:63;G:62;B:23),
	(R:63;G:61;B:16),
	(R:63;G:61;B:8),
	(R:63;G:61;B:0),
	(R:57;G:54;B:0),
	(R:51;G:48;B:0),
	(R:45;G:41;B:0),
	(R:39;G:35;B:0),
	(R:33;G:29;B:0),
	(R:27;G:22;B:0),
	(R:21;G:16;B:0),
	(R:16;G:10;B:0),
	(R:62;G:63;B:54),
	(R:61;G:63;B:46),
	(R:58;G:63;B:39),
	(R:56;G:63;B:31),
	(R:52;G:63;B:23),
	(R:49;G:63;B:16),
	(R:45;G:63;B:8),
	(R:40;G:63;B:0),
	(R:36;G:57;B:0),
	(R:32;G:51;B:0),
	(R:29;G:45;B:0),
	(R:24;G:39;B:0),
	(R:20;G:33;B:0),
	(R:17;G:28;B:0),
	(R:13;G:22;B:0),
	(R:10;G:16;B:0),
	(R:54;G:63;B:54),
	(R:39;G:63;B:39),
	(R:36;G:59;B:36),
	(R:33;G:56;B:33),
	(R:30;G:52;B:30),
	(R:28;G:49;B:27),
	(R:25;G:46;B:25),
	(R:22;G:42;B:22),
	(R:20;G:39;B:19),
	(R:17;G:36;B:16),
	(R:14;G:32;B:13),
	(R:11;G:29;B:11),
	(R:9;G:26;B:8),
	(R:6;G:22;B:5),
	(R:3;G:19;B:2),
	(R:1;G:16;B:0),
	(R:54;G:63;B:63),
	(R:46;G:63;B:63),
	(R:39;G:63;B:63),
	(R:31;G:63;B:62),
	(R:23;G:63;B:63),
	(R:16;G:63;B:63),
	(R:8;G:63;B:63),
	(R:0;G:63;B:63),
	(R:0;G:57;B:57),
	(R:0;G:51;B:51),
	(R:0;G:45;B:45),
	(R:0;G:39;B:39),
	(R:0;G:33;B:33),
	(R:0;G:28;B:28),
	(R:0;G:22;B:22),
	(R:0;G:16;B:16),
	(R:54;G:59;B:63),
	(R:46;G:56;B:63),
	(R:39;G:53;B:63),
	(R:31;G:50;B:63),
	(R:23;G:47;B:63),
	(R:16;G:44;B:63),
	(R:0;G:39;B:63),
	(R:0;G:35;B:57),
	(R:0;G:32;B:52),
	(R:0;G:29;B:47),
	(R:0;G:25;B:42),
	(R:0;G:22;B:36),
	(R:0;G:19;B:31),
	(R:0;G:15;B:26),
	(R:0;G:12;B:21),
	(R:0;G:9;B:16),
	(R:54;G:54;B:63),
	(R:46;G:47;B:63),
	(R:39;G:39;B:63),
	(R:31;G:32;B:63),
	(R:23;G:24;B:63),
	(R:16;G:16;B:63),
	(R:0;G:1;B:63),
	(R:0;G:0;B:57),
	(R:0;G:0;B:52),
	(R:0;G:0;B:47),
	(R:0;G:0;B:42),
	(R:0;G:0;B:36),
	(R:0;G:0;B:31),
	(R:0;G:0;B:26),
	(R:0;G:0;B:21),
	(R:0;G:0;B:16),
	(R:60;G:54;B:63),
	(R:57;G:46;B:63),
	(R:54;G:39;B:63),
	(R:52;G:31;B:63),
	(R:50;G:23;B:63),
	(R:47;G:16;B:63),
	(R:45;G:8;B:63),
	(R:42;G:0;B:63),
	(R:38;G:0;B:57),
	(R:32;G:0;B:51),
	(R:29;G:0;B:45),
	(R:24;G:0;B:39),
	(R:20;G:0;B:33),
	(R:17;G:0;B:28),
	(R:13;G:0;B:22),
	(R:10;G:0;B:16),
	(R:63;G:54;B:63),
	(R:63;G:46;B:63),
	(R:63;G:39;B:63),
	(R:63;G:31;B:63),
	(R:63;G:23;B:63),
	(R:63;G:16;B:63),
	(R:63;G:8;B:63),
	(R:56;G:0;B:57),
	(R:51;G:0;B:51),
	(R:46;G:0;B:46),
	(R:41;G:0;B:41),
	(R:36;G:0;B:36),
	(R:31;G:0;B:31),
	(R:26;G:0;B:26),
	(R:21;G:0;B:21),
	(R:16;G:0;B:16),
	(R:63;G:58;B:55),
	(R:60;G:53;B:49),
	(R:57;G:49;B:43),
	(R:54;G:45;B:38),
	(R:51;G:40;B:32),
	(R:48;G:36;B:27),
	(R:45;G:32;B:21),
	(R:43;G:28;B:16),
	(R:39;G:25;B:14),
	(R:35;G:23;B:13),
	(R:32;G:21;B:11),
	(R:28;G:19;B:10),
	(R:24;G:16;B:8),
	(R:21;G:14;B:7),
	(R:17;G:12;B:5),
	(R:14;G:10;B:4),
	(R:63;G:54;B:51),
	(R:62;G:51;B:46),
	(R:61;G:48;B:42),
	(R:60;G:45;B:37),
	(R:59;G:42;B:33),
	(R:58;G:39;B:29),
	(R:57;G:37;B:25),
	(R:56;G:35;B:22),
	(R:54;G:32;B:19),
	(R:53;G:30;B:16),
	(R:50;G:27;B:13),
	(R:48;G:24;B:11),
	(R:45;G:21;B:9),
	(R:42;G:18;B:7),
	(R:39;G:15;B:5),
	(R:37;G:12;B:3),
	(R:61;G:48;B:42),
	(R:60;G:47;B:40),
	(R:60;G:46;B:39),
	(R:60;G:45;B:37),
	(R:59;G:44;B:36),
	(R:59;G:43;B:34),
	(R:59;G:42;B:33),
	(R:58;G:41;B:32),
	(R:58;G:40;B:30),
	(R:58;G:39;B:29),
	(R:57;G:38;B:27),
	(R:57;G:37;B:26),
	(R:57;G:37;B:25),
	(R:63;G:39;B:39),
	(R:63;G:37;B:37),
	(R:63;G:36;B:36),
	(R:63;G:35;B:35),
	(R:63;G:33;B:33),
	(R:63;G:32;B:32),
	(R:63;G:31;B:31),
	(R:54;G:45;B:38),
	(R:52;G:43;B:35),
	(R:51;G:41;B:33),
	(R:50;G:39;B:31),
	(R:49;G:37;B:29),
	(R:48;G:36;B:27),
	(R:48;G:48;B:48),
	(R:47;G:47;B:47),
	(R:46;G:46;B:46),
	(R:45;G:45;B:45),
	(R:44;G:44;B:44),
	(R:63;G:63;B:63));


PROCEDURE InitGraphics (video: String);
VAR
    bgiDriver: Integer;
    videoMode: Integer;
    regResult: Integer;
    gci: Integer;
    graphDriver, graphMode: Integer;
BEGIN
    IF video = 'SVGA' THEN
    BEGIN
         bgiDriver := InstallUserDriver('SVGA256',nil);
         videoMode := SVGA256mode;
         InitGraph(bgiDriver, videoMode, '');
         IF GraphResult <> grOk THEN    {Fallback to egavga bgi driver}
         BEGIN
              Writeln('Could not initialize SVGA driver!');
              Writeln;
              Writeln('TIP: Change configuration setting Video to VGA.');
              Writeln;
              Writeln('Press Enter to continue using VGA driver temporarly.');
              Readln;
              regVGADriver := False;
              InitGraphics('VGA');
         END
         ELSE BEGIN
              SetColor(7);
              OutTextXY(12, 1, '4D Sports Driving Car Editor');
              OutTextXY(280,232,'Loading...');
              { Load Game's 256 color palette }
              Line(192,247, 192+255,247);
              FOR gci := 0 TO 255 DO
              WITH GameColors[gci] DO
                   BEGIN
                   SetRGBPalette(gci, R, G, B);
                   Line(192+gci,245, 192+gci,249);
                   END;
              SetRGBPalette(0,42,42,42); {Set LightGray as background color}
         END;
    END
    ELSE {'VGA'}
    BEGIN
         DetectGraph(GraphDriver, GraphMode);
         Assert(GraphResult = grOk,
                'Failed to register linked graphics driver: ' +
                        GraphErrorMsg(GraphResult));
         Assert(GraphDriver = VGA, 'VGA mode not detected.');

         IF (regVGADriver = False) THEN
         BEGIN
            regResult := RegisterBGIDriver(@EGAVGADriverProc);
            Assert(GraphResult = grOk,
                'Failed to register linked graphics driver: ' +
                        GraphErrorMsg(GraphResult));
            regVGADriver := True;
         END;
         bgiDriver := VGA;
         videoMode := VGAHI;
         InitGraph(bgiDriver, videoMode, '');
         Assert(GraphResult = grOk, 'Could not initialize VGA driver: '+
                GraphErrorMsg(GraphResult));
    END;
END;

PROCEDURE ExitGraphics;
BEGIN
    CloseGraph;
END;

PROCEDURE ShowMessageBox(cap, msg: String);
VAR
    key: Word;
BEGIN
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 223);
    SetColor(15);
    Rectangle(160, 160, 479, 223);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    OutTextXY(168, 192, msg);
    SetColor(4); OutTextXY(168, 208, 'Enter');
    SetColor(8); OutTextXY(216, 208, 'Confirm');
    REPEAT
        key := ReadKeyPro;
    UNTIL (key = KEY_ENTER);
END;

FUNCTION ShowQuestion(cap, msg: String): Boolean;
VAR
    key: Word;
BEGIN
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 223);
    SetColor(15);
    Rectangle(160, 160, 479, 223);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    OutTextXY(168, 192, msg);
    SetColor(4); OutTextXY(168, 208, 'Y');
    SetColor(8); OutTextXY(184, 208, 'Yes (Confirm)');
    SetColor(4); OutTextXY(304, 208, 'N');
    SetColor(8); OutTextXY(320, 208, 'No (Cancel)');
    REPEAT
        key := ReadKeyPro;
    UNTIL ((key = KEY_Y) OR (key = KEY_N));
    ShowQuestion := (key = KEY_Y);
END;

FUNCTION EditWordValue(old: Word; cap: String): Word;
BEGIN
     EditWordValue := EditSignedWordValue(old, cap, false);
END;

FUNCTION EditSignedWordValue(old: Word; cap: String; isNeg: Boolean): Word;
VAR
    new:        Word;
    p:          Integer;
    key:        Word;
    lv, mv, rv: Word;
BEGIN
    EditSignedWordValue := old;
    new := old;
    p := 0;
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 226);
    SetColor(15);
    Rectangle(160, 160, 479, 226);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    SetColor(4); OutTextXY(168, 208, 'Left/Right');
    SetColor(8); OutTextXY(256, 208, 'Select');
    SetColor(4); OutTextXY(320, 208, 'Up/Down/0-9');
    SetColor(8); OutTextXY(416, 208, 'Set');
    SetColor(4); OutTextXY(168, 216, 'Enter');
    SetColor(8); OutTextXY(216, 216, 'Confirm');
    SetColor(4); OutTextXY(288, 216, 'Esc');
    SetColor(8); OutTextXY(320, 216, 'Cancel');
    REPEAT
        SetFillStyle(SolidFill, 7);
        Bar(300, 189, 339, 203);
        SetColor(15);
        IF isNeg THEN OutTextXY(292,192,'-');
        OutTextXY(300, 192, Word2Dec(new));
        Line(332-(8*p), 189, 339-(8*p), 189);
        Line(332-(8*p), 202, 339-(8*p), 202);
        key := ReadKeyPro;
        CASE key OF
            KEY_LEFT:
                IF (p < 4) THEN Inc(p);
            KEY_RIGHT:
                IF (p > 0) THEN Dec(p);
            KEY_UP:
                IncWord(new, TenToThe(p));
            KEY_DOWN:
                DecWord(new, TenToThe(p));
            KEY_ENTER:
                EditSignedWordValue := new;
            ELSE
                IF ((key >= KEY_0) AND (key <= KEY_9)) THEN
                BEGIN
                    IF (p < 4) THEN
                       lv := (new DIV TenToThe(p+1)) * TenToThe(p+1)
                    ELSE
                       lv := 0;
                    mv := (key - KEY_0) * TenToThe(p);
                    rv := new MOD TenToThe(p);
                    new := lv + mv + rv;
                    IF (p > 0) THEN Dec(p);
                END;
        END
    UNTIL ((key = KEY_ESC) OR (key = KEY_ENTER));
END;

FUNCTION EditString(old: String; cap: String; max: Integer): String;
VAR
    new: String;
    x:   Integer;
    key: Word;
BEGIN
    EditString := old;
    new := old;
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 226);
    SetColor(15);
    Rectangle(160, 160, 479, 226);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    SetColor(4); OutTextXY(168, 208, 'A-Z/0-9/..');
    SetColor(8); OutTextXY(256, 208, 'Append');
    SetColor(4); OutTextXY(320, 208, 'Backspace');
    SetColor(8); OutTextXY(400, 208, 'Clear');
    SetColor(4); OutTextXY(168, 216, 'Enter');
    SetColor(8); OutTextXY(216, 216, 'Confirm');
    SetColor(4); OutTextXY(288, 216, 'Esc');
    SetColor(8); OutTextXY(320, 216, 'Cancel');
    REPEAT
        SetColor(15);
        OutTextXY(168, 192, new);
        x := (8*Length(new))+168;
        Line(x, 202, x+7, 202);
        key := ReadKeyPro;
        IF ((key >= $20) AND (key <= $7F)) THEN
        BEGIN
           IF (Length(new) < max) THEN
           BEGIN
               new := new + chr(key);
               SetColor(7);
               Line(x, 202, x+7, 202);
           END;
        END ELSE BEGIN
            CASE key OF
                KEY_BKSPC:
                    IF (Length(new) > 0) THEN
                    BEGIN
                        SetFillStyle(SolidFill, 7);
                        Bar(x-8, 189, x+7, 202);
                        new := Copy(new, 1, Length(new)-1);
                    END;
                KEY_ENTER:
                    EditString := new;
            END;
        END;
    UNTIL ((key = KEY_ESC) OR (key = KEY_ENTER));
END;


FUNCTION EditColorByteValue(old: Byte; cap: String): Byte;
VAR
    new:        Byte;
    p:          Integer;
    key:        Word;
    lv, mv, rv: Word;
    i,j,i2:      Integer;
BEGIN
    EditColorByteValue := old;
    new := old;
    p := 0;
    SetFillStyle(SolidFill, 7);
    Bar(160, 160, 479, 250);
    SetColor(15);
    Rectangle(160, 160, 479, 250);
    OutTextXY(168, 168, cap);
    Line(160, 179, 479, 179);
    SetColor(4); OutTextXY(168, 232, 'Left/Right');
    SetColor(8); OutTextXY(256, 232, 'Select');
    SetColor(4); OutTextXY(320, 232, 'Up/Down/0-9');
    SetColor(8); OutTextXY(416, 232, 'Set');
    SetColor(4); OutTextXY(168, 240, 'Enter');
    SetColor(8); OutTextXY(216, 240, 'Confirm');
    SetColor(4); OutTextXY(288, 240, 'Esc');
    SetColor(8); OutTextXY(320, 240, 'Cancel');
    For i:=0 TO GetMaxColor DO
    BEGIN
         IF (i=0) THEN
         BEGIN
            IF GetMaxColor < 16 THEN SetColor(8)
            ELSE SetColor(31)
         END
         ELSE
            SetColor(i);
         Line(192+i,221, 192+i,225);
    END;
    IF GetMaxColor < 16 THEN
    BEGIN
       SetColor(12);
       OutTextXY(168, 186, '(*) Use SVGA to check above 16 colors.');
    END;
    REPEAT
        SetFillStyle(SolidFill, 7);
        Bar(300, 197, 339, 213);
        SetColor(15);
        OutTextXY(308, 200, Byte2Dec(new));
        Line(324-(8*p), 197, 331-(8*p), 197);
        Line(324-(8*p), 210, 331-(8*p), 210);
        IF (new=0) THEN
        BEGIN {simulate black}
           IF GetMaxColor < 16 THEN SetColor(8)
           ELSE SetColor(31)
        END
        ELSE
           SetColor(new);
        IF ((GetMaxColor > 16) OR ((GetMaxColor < 16) AND (new < 16))) THEN
        BEGIN
            OutTextXY(189+new, 214, Chr(31));
            OutTextXY(189+new, 211, Chr(25));
        END;

        key := ReadKeyPro;
        SetColor(7);
        OutTextXY(189+new, 214, Chr(31));
        OutTextXY(189+new, 211, Chr(25));
        CASE key OF
            KEY_LEFT:
                IF (p < 2) THEN Inc(p);
            KEY_RIGHT:
                IF (p > 0) THEN Dec(p);
            KEY_UP:
                IncByte(new, TenToThe(p));
            KEY_DOWN:
                DecByte(new, TenToThe(p));
            KEY_ENTER:
                EditColorByteValue := new;
            ELSE
                IF ((key >= KEY_0) AND (key <= KEY_9)) THEN
                BEGIN
                    IF (p < 4) THEN
                       lv := (new DIV TenToThe(p+1)) * TenToThe(p+1)
                    ELSE
                       lv := 0;
                    mv := (key - KEY_0) * TenToThe(p);
                    rv := new MOD TenToThe(p);
                    new := lv + mv + rv;
                    IF (p > 0) THEN Dec(p);
                END;
        END
    UNTIL ((key = KEY_ESC) OR (key = KEY_ENTER));
END;

END.